/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.templateeditor;

import java.util.HashSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.wolips.bindings.api.ApiCache;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.TagShortcut;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.wodclipse.core.completion.WodCompletionProposal;
import org.objectstyle.wolips.wodclipse.core.completion.WodCompletionUtils;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;

public class InlineWodTagInfo
extends TagInfo {
    private String _elementTypeName;
    private TagShortcut _tagShortcut;
    private IJavaProject _javaProject;
    private boolean _attributeInfoCached;
    private TypeCache _cache;

    public InlineWodTagInfo(String elementTypeName, TypeCache cache) {
        super("wo:" + elementTypeName, true, true);
        this.setRequiresAttributes(true);
        this._cache = cache;
        this._elementTypeName = elementTypeName;
        this._tagShortcut = ApiCache.getTagShortcutNamed((String)elementTypeName);
    }

    public void setJavaProject(IJavaProject javaProject) {
        this._javaProject = javaProject;
    }

    public IJavaProject getJavaProject() {
        return this._javaProject;
    }

    public IType getElementType() {
        IType elementType = null;
        try {
            elementType = BindingReflectionUtils.findElementType((IJavaProject)this._javaProject, (String)this.getExpandedElementTypeName(), (boolean)false, (TypeCache)this._cache);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return elementType;
    }

    public String getElementTypeName() {
        return this._elementTypeName;
    }

    public String getExpandedElementTypeName() {
        String elementTypeName = this._elementTypeName;
        if (this._tagShortcut != null) {
            elementTypeName = this._tagShortcut.getActual();
        }
        return elementTypeName;
    }

    protected void loadAttributeInfo() {
        if (!this._attributeInfoCached) {
            try {
                IType elementType = BindingReflectionUtils.findElementType((IJavaProject)this._javaProject, (String)this.getExpandedElementTypeName(), (boolean)false, (TypeCache)this._cache);
                if (elementType != null) {
                    HashSet proposals = new HashSet();
                    WodCompletionUtils.fillInBindingNameCompletionProposals((IJavaProject)this._javaProject, (IType)elementType, (String)"", (int)0, (int)0, proposals, (boolean)false, (TypeCache)this._cache);
                    for (WodCompletionProposal proposal : proposals) {
                        AttributeInfo attrInfo = new AttributeInfo(proposal.getProposal(), true);
                        this.addAttributeInfo(attrInfo);
                    }
                }
                this._attributeInfoCached = true;
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public AttributeInfo[] getAttributeInfo() {
        this.loadAttributeInfo();
        return super.getAttributeInfo();
    }

    public AttributeInfo getAttributeInfo(String name) {
        this.loadAttributeInfo();
        return super.getAttributeInfo(name);
    }
}

