/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.templateeditor;

import java.io.FileWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.FuzzyXMLText;
import jp.aonir.fuzzyxml.internal.RenderContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.templateeditor.TemplateSourceEditor;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;

public class TemplateOutlinePage
extends Page
implements IContentOutlinePage,
IHTMLOutlinePage,
StatusTextListener,
IAnnotationModelListener,
IAnnotationModelListenerExtension {
    private static final String COMPACT_VIEW_PREFERENCE_KEY = "org.objectstyle.wolips.templateEditor.compactView";
    private static final String COLLAPSE_STRING = "&ndash;";
    private static final String EXPAND_STRING = "+";
    private TemplateSourceEditor _editor;
    private FuzzyXMLDocument _doc;
    private Browser _browser;
    private int _counter;
    private Map<String, FuzzyXMLNode> _idToNodeMap;
    private Map<FuzzyXMLNode, String> _nodeToIDMap;
    private List<ISelectionChangedListener> _selectionChangedListeners;
    private ISelection _selection;
    private Set<String> _collapsedIDs;
    private boolean _compactView;
    private int _lastPageOffset;

    public TemplateOutlinePage(TemplateSourceEditor editor) {
        this._editor = editor;
        this._selectionChangedListeners = new LinkedList<ISelectionChangedListener>();
        this._collapsedIDs = new HashSet<String>();
        this._compactView = HTMLPlugin.getDefault().getPreferenceStore().getBoolean("_pref_template_compact_view");
    }

    public FuzzyXMLDocument getDoc() {
        return this._doc;
    }

    public void createControl(Composite parent) {
        try {
            this._browser = new Browser(parent, 0);
            this._browser.addStatusTextListener((StatusTextListener)this);
        }
        catch (Throwable t) {
            HTMLPlugin.logException(t);
        }
        this.update();
    }

    protected boolean isHTML() {
        return true;
    }

    protected FuzzyXMLParser createParser(IProject project) {
        BuildProperties buildProperties = (BuildProperties)project.getAdapter(BuildProperties.class);
        FuzzyXMLParser parser = new FuzzyXMLParser(buildProperties != null ? buildProperties.isWellFormedTemplateRequired() : false, this.isHTML());
        return parser;
    }

    public Control getControl() {
        return this._browser;
    }

    public void setFocus() {
        if (this._editor.isDirty()) {
            this.update();
        }
        if (this._browser != null) {
            this._browser.setFocus();
        }
    }

    public void changed(StatusTextEvent event) {
        String text = event.text;
        int colonIndex = text.indexOf(58);
        if (colonIndex == -1) {
            return;
        }
        String command = text.substring(0, colonIndex);
        String target = text.substring(colonIndex + 1);
        if ("select".equals(command)) {
            this.outlineNodeSelected(target);
        } else if ("expand".equals(command)) {
            this.outlineNodeExpanded(target);
        } else if ("collapse".equals(command)) {
            this.outlineNodeCollapsed(target);
        } else if ("toggleCompact".equals(command)) {
            this._compactView = !this._compactView;
            HTMLPlugin.getDefault().getPreferenceStore().setValue("_pref_template_compact_view", this._compactView);
        } else if ("pageYOffset".equals(command)) {
            try {
                this._lastPageOffset = Integer.parseInt(target);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                this._lastPageOffset = 0;
            }
        }
    }

    public void outlineNodeCollapsed(String target) {
        if (!this._collapsedIDs.contains(target)) {
            this._collapsedIDs.add(target);
            FuzzyXMLNode selectedNode = this._idToNodeMap.get(target);
            ProjectionAnnotationModel model = ((ProjectionViewer)this._editor.getViewer()).getProjectionAnnotationModel();
            Annotation lastAnnotation = this.getAnnotationForNode(selectedNode, model);
            if (lastAnnotation != null) {
                model.collapse(lastAnnotation);
            }
        }
    }

    public void outlineNodeExpanded(String target) {
        if (this._collapsedIDs.contains(target)) {
            this._collapsedIDs.remove(target);
            FuzzyXMLNode selectedNode = this._idToNodeMap.get(target);
            ProjectionAnnotationModel model = ((ProjectionViewer)this._editor.getViewer()).getProjectionAnnotationModel();
            Annotation lastAnnotation = this.getAnnotationForNode(selectedNode, model);
            if (lastAnnotation != null) {
                model.expand(lastAnnotation);
            }
        }
    }

    public void outlineNodeSelected(String target) {
        FuzzyXMLNode selectedNode = this._idToNodeMap.get(target);
        this._selection = new StructuredSelection((Object)selectedNode);
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this._selection);
        for (ISelectionChangedListener listener : this._selectionChangedListeners) {
            listener.selectionChanged(selectionChangedEvent);
        }
        this._editor.selectAndReveal(selectedNode.getOffset(), selectedNode.getLength());
        this._editor.getViewer().getTextWidget().setFocus();
    }

    protected Annotation getAnnotationForNode(FuzzyXMLNode node, ProjectionAnnotationModel model) {
        Annotation matchingAnnotation = null;
        if (model != null) {
            int index = node.getOffset();
            Iterator annotationsIter = model.getAnnotationIterator();
            while (annotationsIter.hasNext()) {
                Annotation annotation = (Annotation)annotationsIter.next();
                if (model.getPosition(annotation).getOffset() != index) continue;
                matchingAnnotation = annotation;
            }
        }
        return matchingAnnotation;
    }

    public void modelChanged(AnnotationModelEvent event) {
        if (this._browser != null) {
            IAnnotationModel model = event.getAnnotationModel();
            Annotation[] annotations = event.getChangedAnnotations();
            if (annotations != null) {
                for (Annotation annotation : annotations) {
                    if (!(annotation instanceof ProjectionAnnotation)) continue;
                    ProjectionAnnotation projectionAnnotation = (ProjectionAnnotation)annotation;
                    Position annotationPosition = model.getPosition(annotation);
                    FuzzyXMLElement node = this._doc.getElementByOffset(annotationPosition.getOffset());
                    String nodeID = this._nodeToIDMap.get(node);
                    if (nodeID == null) continue;
                    if (projectionAnnotation.isCollapsed()) {
                        this._browser.execute("collapse('" + nodeID + "');");
                    } else {
                        this._browser.execute("expand('" + nodeID + "');");
                    }
                    this._browser.execute("window.scrollTo(getPageXOffset(), getPageYOffset());");
                }
            }
        }
    }

    public void modelChanged(IAnnotationModel model) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        return this._selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void dispose() {
        this._nodeToIDMap.clear();
        this._idToNodeMap.clear();
        this._collapsedIDs.clear();
        this._selectionChangedListeners.clear();
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        ProjectionAnnotationModel model = ((ProjectionViewer)this._editor.getViewer()).getProjectionAnnotationModel();
        model.removeAnnotationModelListener((IAnnotationModelListener)this);
        model.addAnnotationModelListener((IAnnotationModelListener)this);
        try {
            this._doc = this.createParser(this._editor.getParserCache().getProject()).parse(this._editor.getHTMLSource());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._counter = 0;
        this._idToNodeMap = new HashMap<String, FuzzyXMLNode>();
        this._nodeToIDMap = new HashMap<FuzzyXMLNode, String>();
        try {
            boolean rendered;
            WodParserCache cache = this._editor.getParserCache();
            RenderContext renderContext = new RenderContext(true);
            FuzzyXMLElement documentElement = this._doc.getDocumentElement();
            StringBuffer documentContentsBuffer = new StringBuffer();
            this.renderHeader(documentContentsBuffer);
            this.renderElement(documentElement, renderContext, documentContentsBuffer, cache);
            this.renderFooter(documentContentsBuffer);
            if (this._browser != null) {
                this._browser.execute("updatePageYOffset()");
            }
            if (this._lastPageOffset > 0) {
                documentContentsBuffer.append("<script>window.scrollTo(100, " + this._lastPageOffset + ");</script>");
            }
            String documentContents = documentContentsBuffer.toString();
            boolean debug = false;
            if (debug) {
                FileWriter fw = new FileWriter("/tmp/TemplateOutlinePage-" + System.currentTimeMillis() + ".html");
                try {
                    fw.write(documentContents);
                }
                finally {
                    fw.close();
                }
            }
            if (this._browser != null && !(rendered = this._browser.setText(documentContents))) {
                HTMLPlugin.logError("Can't create preview of component HTML.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void renderHeader(StringBuffer renderBuffer) {
        renderBuffer.append("<html>\n");
        renderBuffer.append("<head>\n");
        renderBuffer.append("<style>\n");
        renderBuffer.append("body { font-family: Helvetica; font-size: 8pt; margin: 5px; margin-top: 2px; }\n");
        renderBuffer.append("a { text-decoration: none; }\n");
        renderBuffer.append("div.viewControls { right: 8px; margin: 0px; margin-bottom: 2px; text-align: right; }\n");
        renderBuffer.append("div.viewControls a { color: rgb(0, 0, 200); }\n");
        renderBuffer.append("div.elements { margin-top: 0px; }\n");
        renderBuffer.append("div.element { overflow: hidden; margin-top: 5px; margin-bottom: 5px; margin-right: 0px; padding: 0px; border: 1px solid rgb(230, 230, 230); border-right: none; }\n");
        renderBuffer.append("div.element div.summary { cursor: pointer; white-space: nowrap; background-color: rgb(240, 240, 240); padding: 3px; border-bottom: 1px solid rgb(230, 230, 230); }\n");
        renderBuffer.append("div.element.empty div.summary { border-bottom: none; }\n");
        renderBuffer.append("div.element div.summary:hover { background-color: rgb(220, 220, 220); border-color: rgb(210, 210, 210); }\n");
        renderBuffer.append("div.element div.expandcollapse { cursor: pointer; float: right; background-color: rgb(255, 255, 255); width: 10px; border: 1px solid rgb(230, 230, 230); border-top: none; padding-left: 3px; padding-right: 3px; text-align: center; }\n");
        renderBuffer.append("div.element div.expandcollapse:hover { font-weight: bold; border-width: 2px; border-right-width: 1px; background-color: rgb(245, 245, 245); }\n");
        renderBuffer.append("div.element div.expandcollapse:active { font-weight: bold; border-width: 2px; border-right-width: 1px; background-color: rgb(230, 230, 230); }\n");
        renderBuffer.append("div.element div.contents { background-color: rgb(255, 255, 255); padding-left: 10px; padding-right: 0px; padding-top: 5px; padding-bottom: 5px; }\n");
        renderBuffer.append("div.element.wo { border-color: rgb(200, 200, 255); }\n");
        renderBuffer.append("div.element.wo > div.summary { background-color: rgb(240, 240, 255); border-bottom: 1px solid rgb(200, 200, 255); }\n");
        renderBuffer.append("div.element.wo.empty > div.summary { border-bottom: none; }\n");
        renderBuffer.append("div.element.wo > div.summary:hover { background-color: rgb(210, 210, 255); border-color: rgb(210, 210, 255); }\n");
        renderBuffer.append("div.element.wo > div.summary div.title span.type { font-weight: normal; font-size: 0.80em; color: rgb(150, 150, 150); }\n");
        renderBuffer.append("div.element.wo > div.expandcollapse { border-color: rgb(200, 200, 255); }\n");
        renderBuffer.append("div.element.wo > div.expandcollapse:hover { background-color: rgb(245, 245, 255); }\n");
        renderBuffer.append("div.element.wo > div.expandcollapse:active { background-color: rgb(200, 200, 255); }\n");
        renderBuffer.append("div.element.wo > div.contents { background-color: rgb(250, 250, 255); border-color: rgb(200, 200, 255); }\n");
        renderBuffer.append("div.element div.summary div.title { font-weight: bold; }\n");
        renderBuffer.append("div.element div.summary div.title.nonwo { color: rgb(180, 180, 180); }\n");
        renderBuffer.append("div.element div.summary div.title.missing { font-style: italic; }\n");
        renderBuffer.append("div.element div.summary div.title.nonwo span.idName { font-weight: bold; color: rgb(180, 180, 180); padding-left: 10px; }\n");
        renderBuffer.append("div.element div.summary div.title.nonwo span.className { font-weight: bold; color: rgb(180, 180, 180); padding-left: 10px; }\n");
        renderBuffer.append("div.element div.summary table.bindings { font-family: Helvetica; font-size: 8pt; margin: 0px; padding: 0px; }\n");
        renderBuffer.append("div.element div.summary table.bindings th { text-align: right; font-weight: normal; color: rgb(220, 0, 0); padding-right: 3px; }\n");
        renderBuffer.append("div.element div.summary table.bindings td.literal { color: rgb(0, 0, 200); }\n");
        renderBuffer.append("div.element div.summary table.bindings td.ognl { color: rgb(180, 0, 0); }\n");
        renderBuffer.append("div.element div.summary table.bindings td.keypath { color: rgb(180, 0, 0); }\n");
        renderBuffer.append("div.text { display: inline; }\n");
        renderBuffer.append("span.negate { font-weight: bold; }\n");
        renderBuffer.append("div.element.wo.WOString.simple { display: inline; border: none; }\n");
        renderBuffer.append("div.element.wo.WOString.simple div.summary { display: inline; border: 1px solid rgb(200, 200, 255); border: none; background-color: transparent; padding: 0px; }\n");
        renderBuffer.append("div.element.wo.WOString.simple div.summary div.title { display: inline; }\n");
        renderBuffer.append("div.element.wo.WOString.simple div.text.literal { color: rgb(0, 0, 200); }\n");
        renderBuffer.append("div.element.wo.WOString.simple div.text.ognl { color: rgb(180, 0, 0); }\n");
        renderBuffer.append("div.element.wo.WOString.simple div.text.keypath { color: rgb(180, 0, 0); }\n");
        renderBuffer.append("div.element.wo.ERXLocalizedString.simple { display: inline; border: none; }\n");
        renderBuffer.append("div.element.wo.ERXLocalizedString.simple div.summary { display: inline; border: 1px solid rgb(200, 200, 255); border: none; background-color: transparent; padding: 0px; }\n");
        renderBuffer.append("div.element.wo.ERXLocalizedString.simple div.summary div.title { display: inline; }\n");
        renderBuffer.append("div.element.wo.ERXLocalizedString.simple div.text.literal { color: rgb(0, 0, 200); }\n");
        renderBuffer.append("div.element.wo.ERXLocalizedString.simple div.text.ognl { color: rgb(180, 0, 0); }\n");
        renderBuffer.append("div.element.wo.ERXLocalizedString.simple div.text.keypath { color: rgb(180, 0, 0); }\n");
        renderBuffer.append("div.element.wo.WOConditional { border-color: rgb(190, 250, 190); }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.summary { background-color: rgb(230, 250, 230); }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.summary:hover { background-color: rgb(200, 250, 200); border-color: rgb(200, 255, 200); }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.expandcollapse { border-color: rgb(200, 255, 200); }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.expandcollapse:hover { background-color: rgb(245, 255, 245); }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.expandcollapse:active { background-color: rgb(200, 255, 200); }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.contents { background-color: rgb(250, 255, 250); border-color: rgb(190, 250, 190); }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.summary div.title span.type { display: none; }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.summary table.bindings th { text-align: right; font-weight: normal; color: rgb(220, 0, 0); padding-right: 3px; }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.summary table.bindings td.literal { color: rgb(0, 0, 200); }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.summary table.bindings td.ognl { color: rgb(180, 0, 0); }\n");
        renderBuffer.append("div.element.wo.WOConditional > div.summary table.bindings td.keypath { color: rgb(180, 0, 0); }\n");
        renderBuffer.append("div.element.wo.ERXElse { border-color: rgb(190, 250, 190); }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.summary { background-color: rgb(230, 250, 230); }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.summary:hover { background-color: rgb(200, 250, 200); border-color: rgb(200, 255, 200); }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.expandcollapse { border-color: rgb(200, 255, 200); }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.expandcollapse:hover { background-color: rgb(245, 255, 245); }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.expandcollapse:active { background-color: rgb(200, 255, 200); }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.contents { background-color: rgb(250, 255, 250); border-color: rgb(190, 250, 190); }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.summary div.title span.type { display: none; }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.summary table.bindings th { text-align: right; font-weight: normal; color: rgb(220, 0, 0); padding-right: 3px; }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.summary table.bindings td.literal { color: rgb(0, 0, 200); }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.summary table.bindings td.ognl { color: rgb(180, 0, 0); }\n");
        renderBuffer.append("div.element.wo.ERXElse > div.summary table.bindings td.keypath { color: rgb(180, 0, 0); }\n");
        renderBuffer.append("body.verbose div.element div.summary div.title span.nodeName.verbose { display: block; }\n");
        renderBuffer.append("body.verbose div.element div.summary div.title span.nodeName.compact { display: none; }\n");
        renderBuffer.append("body.compact { font-size: 7.5pt; }\n");
        renderBuffer.append("body.compact div.element { margin-top: 2px; margin-bottom: 3px; }\n");
        renderBuffer.append("body.compact div.element div.expandcollapse { width: 5px; padding-left: 4px; padding-right: 4px; padding-top: 1px; padding-bottom: 1px; }\n");
        renderBuffer.append("body.compact div.element div.expandcollapse:hover { border-width: 1px; }\n");
        renderBuffer.append("body.compact div.element div.summary { padding: 1px; padding-left: 2px; }\n");
        renderBuffer.append("body.compact div.element div.summary table.bindings { display: none; }\n");
        renderBuffer.append("body.compact div.element div.summary div.title { font-weight: normal; }\n");
        renderBuffer.append("body.compact div.element div.summary div.title span.nodeName.verbose { display: none; }\n");
        renderBuffer.append("body.compact div.element div.summary div.title span.nodeName.compact { display: block; }\n");
        renderBuffer.append("body.compact div.element div.summary div.title span.type { display: none; }\n");
        renderBuffer.append("body.compact div.element div.contents { padding-left: 8px; padding-top: 2px; padding-bottom: 2px; }\n");
        renderBuffer.append("body.compact div.element.wo.WOString { display: inline; border: none; }\n");
        renderBuffer.append("body.compact div.element.wo.WOString div.summary { display: inline; border: 1px solid rgb(200, 200, 255); }\n");
        renderBuffer.append("body.compact div.element.wo.WOString div.summary div.title { display: inline; }\n");
        renderBuffer.append("body.compact div.element.wo.WOString.simple { border: none; }\n");
        renderBuffer.append("body.compact div.element.wo.WOString.simple div.summary { border: none; background-color: transparent; padding: 0px; }\n");
        renderBuffer.append("body.compact div.element.wo.WOString.simple div.summary div.title { display: inline; }\n");
        renderBuffer.append("body.compact div.element.wo.ERXLocalizedString { display: inline; border: none; }\n");
        renderBuffer.append("body.compact div.element.wo.ERXLocalizedString div.summary { display: inline; border: 1px solid rgb(200, 200, 255); }\n");
        renderBuffer.append("body.compact div.element.wo.ERXLocalizedString div.summary div.title { display: inline; }\n");
        renderBuffer.append("body.compact div.element.wo.ERXLocalizedString.simple { border: none; }\n");
        renderBuffer.append("body.compact div.element.wo.ERXLocalizedString.simple div.summary { border: none; background-color: transparent; padding: 0px; }\n");
        renderBuffer.append("body.compact div.element.wo.ERXLocalizedString.simple div.summary div.title { display: inline; }\n");
        renderBuffer.append("body div.element.document { margin: 0px; padding: 0px; border: none; }\n");
        renderBuffer.append("body div.element.document > div.summary { margin: 0px; padding: 0px; border: none; display: none; }\n");
        renderBuffer.append("body div.element.document > div.expandcollapse { display: none; }\n");
        renderBuffer.append("body div.element.document > div.contents { margin: 0px; padding: 0px; border: none; }\n");
        renderBuffer.append("</style>\n");
        renderBuffer.append("<script>\n");
        renderBuffer.append("function expandCollapse(id) { if ('none' == document.getElementById(id + '_contents').style.display) { expand(id); } else { collapse(id); } }\n");
        renderBuffer.append("function expand(id) { document.getElementById(id + '_contents').style.display = 'block'; document.getElementById(id + '_toggle').innerHTML = '&ndash;'; window.status = 'expand:' + id; }\n");
        renderBuffer.append("function collapse(id) { document.getElementById(id + '_contents').style.display = 'none'; document.getElementById(id + '_toggle').innerHTML = '+'; window.status = 'collapse:' + id; }\n");
        renderBuffer.append("function toggleCompact() { if ('compact' == document.getElementById('outline').className) { document.getElementById('outline').className = 'verbose'; } else { document.getElementById('outline').className = 'compact'; } window.status = 'toggleCompact:'; }\n");
        renderBuffer.append("function getPageYOffset() { var scrollY; if (document.all) { if (!document.documentElement.scrollTop) { scrollY = document.body.scrollTop; } else { scrollY = document.documentElement.scrollTop; } } else { scrollY = window.pageYOffset; } return scrollY; }\n");
        renderBuffer.append("function getPageXOffset() { var scrollX; if (document.all) { if (!document.documentElement.scrollLeft) { scrollX = document.body.scrollLeft; } else { scrollX = document.documentElement.scrollLeft; } } else { scrollX = window.pageXOffset; } return scrollX; }\n");
        renderBuffer.append("function updatePageYOffset() { window.status = 'pageYOffset:' + getPageYOffset(); }\n");
        renderBuffer.append("</script>\n");
        renderBuffer.append("</head>\n");
        if (this._compactView) {
            renderBuffer.append("<body id = \"outline\" class = \"compact\">\n");
        } else {
            renderBuffer.append("<body id = \"outline\" class = \"verbose\">\n");
        }
        renderBuffer.append("<div class = \"viewControls\"><a href = \"javascript:void(0)\" onclick = \"toggleCompact()\">toggle compact view</a></div>\n");
        renderBuffer.append("<div class = \"elements\">\n");
    }

    protected void renderFooter(StringBuffer renderBuffer) {
        renderBuffer.append("</div></body></html>");
    }

    protected void renderElement(FuzzyXMLNode node, RenderContext renderContext, StringBuffer renderBuffer, WodParserCache cache) {
        String nodeID = "node" + this._counter++;
        this._idToNodeMap.put(nodeID, node);
        this._nodeToIDMap.put(node, nodeID);
        if (node instanceof FuzzyXMLElement) {
            boolean showExpandCollapse;
            FuzzyXMLElement element = (FuzzyXMLElement)node;
            boolean empty = element.isEmpty();
            String nodeName = element.getName();
            String className = "element";
            boolean woTag = WodHtmlUtils.isWOTag((String)nodeName);
            boolean woSimpleString = false;
            IWodElement wodElement = null;
            if (woTag) {
                className = className + " wo";
                try {
                    BuildProperties buildProperties = (BuildProperties)this._editor.getParserCache().getProject().getAdapter(BuildProperties.class);
                    wodElement = WodHtmlUtils.getWodElement((FuzzyXMLElement)element, (BuildProperties)buildProperties, (boolean)true, (WodParserCache)cache);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (wodElement != null) {
                    className = className + " " + wodElement.getElementType();
                    if ("WOString".equals(wodElement.getElementType()) || "ERXLocalizedString".equals(wodElement.getElementType())) {
                        if (wodElement.getBindingNamed("value") != null) {
                            if (wodElement.getBindingNamed("escapeHTML") != null && wodElement.getBindings().size() == 2) {
                                woSimpleString = true;
                            } else if (wodElement.getBindings().size() == 1) {
                                woSimpleString = true;
                            }
                        }
                        if (woSimpleString) {
                            className = className + " simple";
                        }
                    }
                }
            } else {
                className = className + " " + nodeName.toLowerCase();
            }
            boolean bl = showExpandCollapse = !empty;
            if ("script".equalsIgnoreCase(nodeName)) {
                showExpandCollapse = false;
            } else if ("style".equalsIgnoreCase(nodeName)) {
                showExpandCollapse = false;
            }
            if (!showExpandCollapse) {
                className = className + " empty";
            }
            renderBuffer.append("<div id = \"" + nodeID + "\" class = \"" + className + "\">");
            if (showExpandCollapse) {
                renderBuffer.append("<div id = \"" + nodeID + "_toggle\" class = \"expandcollapse\" onclick = \"expandCollapse('" + nodeID + "')\">");
                if (this._collapsedIDs.contains(nodeID)) {
                    renderBuffer.append(EXPAND_STRING);
                } else {
                    renderBuffer.append(COLLAPSE_STRING);
                }
                renderBuffer.append("</div>");
            }
            renderBuffer.append("<div class = \"summary\" onclick = \"window.status = 'select:" + nodeID + "'\">");
            if (woSimpleString) {
                IWodBinding valueBinding = wodElement.getBindingNamed("value");
                String text = valueBinding.getValue();
                String textClassName = valueBinding.isLiteral() ? "text literal" : (valueBinding.isOGNL() ? "text ognl" : "text keypath");
                renderBuffer.append("<div class = \"title\"></div> <div class = \"" + textClassName + "\">[" + text + "]</div>");
            } else if (woTag) {
                if (wodElement != null) {
                    if (WodHtmlUtils.isInline((String)nodeName)) {
                        String value;
                        String summaryName = wodElement.getElementType();
                        renderBuffer.append("<div class = \"title\"><span class = \"nodeName verbose\">" + summaryName + "</span></div>");
                        if ("WOConditional".equals(summaryName)) {
                            String conditionValue = wodElement.getBindingValue("condition");
                            if (conditionValue != null) {
                                summaryName = conditionValue;
                                boolean negated = false;
                                IWodBinding negateBinding = wodElement.getBindingNamed("negate");
                                if (negateBinding != null) {
                                    if (negateBinding.isTrueValue()) {
                                        negated = true;
                                    }
                                } else if (nodeName.equals("wo:not")) {
                                    negated = true;
                                }
                                if (negated) {
                                    summaryName = "<span class = \"negate\">not</span> " + summaryName;
                                } else if (negateBinding != null) {
                                    summaryName = summaryName + " <span class = \"negate\">not = " + negateBinding.getValue() + "</span>";
                                }
                            }
                        } else if ("WOString".equals(summaryName)) {
                            value = wodElement.getBindingValue("value");
                            if (value != null) {
                                summaryName = "WOString: " + value;
                            }
                        } else if ("ERXLocalizedString".equals(summaryName)) {
                            value = wodElement.getBindingValue("value");
                            if (value != null) {
                                summaryName = "ERXLocalizedString: " + value;
                            }
                        } else if (wodElement.getBindingNamed("action") != null) {
                            String action = wodElement.getBindingValue("action");
                            summaryName = wodElement.getElementType() + ": " + action;
                        } else if (wodElement.getBindingNamed("value") != null) {
                            value = wodElement.getBindingValue("value");
                            summaryName = wodElement.getElementType() + ": " + value;
                        } else if (wodElement.getBindingNamed("checked") != null) {
                            String checked = wodElement.getBindingValue("checked");
                            summaryName = wodElement.getElementType() + ": " + checked;
                        } else if (wodElement.getBindingNamed("list") != null) {
                            String list = wodElement.getBindingValue("list");
                            summaryName = wodElement.getElementType() + ": " + (String)list;
                        }
                        renderBuffer.append("<div class = \"title\"><span class = \"nodeName compact\">" + summaryName + "</span></div>");
                    } else {
                        renderBuffer.append("<div class = \"title\"><span class = \"nodeName\">" + wodElement.getElementName() + "</span> <span class = \"type\">: " + wodElement.getElementType() + "</span></div>");
                    }
                    List wodBindings = wodElement.getBindings();
                    if (wodBindings.size() > 0) {
                        renderBuffer.append("<table class = \"bindings\">");
                        for (IWodBinding wodBinding : wodBindings) {
                            renderBuffer.append("<tr>");
                            renderBuffer.append("<th>" + wodBinding.getName() + "</th>");
                            String bindingClass = wodBinding.isLiteral() ? "literal" : (wodBinding.isOGNL() ? "ognl" : "keypath");
                            renderBuffer.append("<td class = \"" + bindingClass + "\">" + wodBinding.getValue() + "</td>");
                            renderBuffer.append("</tr>");
                        }
                        renderBuffer.append("</table>");
                    }
                } else {
                    String missingName = element.getAttributeValue("name");
                    if (missingName == null) {
                        missingName = nodeName;
                    }
                    renderBuffer.append("<div class = \"title missing\">" + missingName + "</div>");
                }
            } else {
                String elementClass;
                renderBuffer.append("<div class = \"title nonwo\"><span class = \"nodeName\">");
                renderBuffer.append(nodeName);
                renderBuffer.append("</span>");
                String elementID = element.getAttributeValue("id");
                if (elementID != null) {
                    renderBuffer.append("<span class = \"idName\">#" + elementID + "</span>");
                }
                if ((elementClass = element.getAttributeValue("class")) != null) {
                    elementClass = elementClass.replace(' ', '.');
                    renderBuffer.append("<span class = \"className\">." + elementClass + "</span>");
                }
                renderBuffer.append("</div>");
            }
            renderBuffer.append("</div>");
            if (showExpandCollapse) {
                FuzzyXMLNode[] children;
                renderBuffer.append("<div id = \"" + nodeID + "_contents\" class = \"contents\"");
                if (this._collapsedIDs.contains(nodeID)) {
                    renderBuffer.append(" style = \"display: none\"");
                }
                renderBuffer.append(">");
                for (FuzzyXMLNode child : children = element.getChildren()) {
                    this.renderElement(child, renderContext, renderBuffer, cache);
                }
                renderBuffer.append("</div>");
            }
            renderBuffer.append("</div>");
        } else {
            StringBuffer nodeBuffer = new StringBuffer();
            node.toXMLString(renderContext, nodeBuffer);
            String nodeStr = nodeBuffer.toString();
            boolean isText = node instanceof FuzzyXMLText;
            if (isText) {
                renderBuffer.append("<div class = \"text\">" + nodeStr + "</div>");
            } else {
                renderBuffer.append(nodeStr);
            }
        }
    }
}

