/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import tk.eclipse.plugin.htmleditor.AbstractValidationDialog;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.jspeditor.editors.ITLDLocator;

public class TLDPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table table;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;

    public TLDPreferencePage() {
        super(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.TLD"));
        this.setPreferenceStore(HTMLPlugin.getDefault().getPreferenceStore());
        this.setDescription(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.LocalTLD"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.table = new Table(composite, 68354);
        this.table.setLayoutData((Object)new GridData(1808));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String path;
                TableItem[] items = TLDPreferencePage.this.table.getSelection();
                boolean enable = false;
                if (items.length > 0 && !(path = items[0].getText(1)).equals("[Default]")) {
                    enable = true;
                }
                TLDPreferencePage.this.buttonEdit.setEnabled(enable);
                TLDPreferencePage.this.buttonRemove.setEnabled(enable);
            }
        });
        TableColumn col1 = new TableColumn(this.table, 16384);
        col1.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Uri"));
        col1.setWidth(100);
        TableColumn col2 = new TableColumn(this.table, 16384);
        col2.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.LocalPath"));
        col2.setWidth(150);
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(1040));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.buttonAdd = new Button(buttons, 8);
        this.buttonAdd.setText(HTMLPlugin.getResourceString("Button.Add"));
        this.buttonAdd.setLayoutData((Object)TLDPreferencePage.createButtonGridData());
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TLDDialog dialog = new TLDDialog(TLDPreferencePage.this.getShell());
                if (dialog.open() == 0) {
                    TableItem item = new TableItem(TLDPreferencePage.this.table, 0);
                    item.setText(new String[]{dialog.getUri(), dialog.getPath()});
                }
            }
        });
        this.buttonEdit = new Button(buttons, 8);
        this.buttonEdit.setText(HTMLPlugin.getResourceString("Button.Edit"));
        this.buttonEdit.setLayoutData((Object)TLDPreferencePage.createButtonGridData());
        this.buttonEdit.setEnabled(false);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TableItem[] items = TLDPreferencePage.this.table.getSelection();
                if (items.length > 0) {
                    String uri = items[0].getText(0);
                    String path = items[0].getText(1);
                    TLDDialog dialog = new TLDDialog(TLDPreferencePage.this.getShell(), uri, path);
                    if (dialog.open() == 0) {
                        items[0].setText(new String[]{dialog.getUri(), dialog.getPath()});
                    }
                }
            }
        });
        this.buttonRemove = new Button(buttons, 8);
        this.buttonRemove.setText(HTMLPlugin.getResourceString("Button.Remove"));
        this.buttonRemove.setLayoutData((Object)TLDPreferencePage.createButtonGridData());
        this.buttonRemove.setEnabled(false);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int[] indices = TLDPreferencePage.this.table.getSelectionIndices();
                TLDPreferencePage.this.table.remove(indices);
            }
        });
        this.performDefaults();
        return composite;
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        TableItem[] items = this.table.getItems();
        StringBuffer uri = new StringBuffer();
        StringBuffer path = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getText(1).startsWith("[Default]")) continue;
            uri.append(items[i].getText(0)).append("\n");
            path.append(items[i].getText(1)).append("\n");
        }
        store.setValue("__pref_tld_uri", uri.toString());
        store.setValue("__pref_tld_path", path.toString());
        return true;
    }

    protected void performDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.table.removeAll();
        Map<String, String> innerTLD = HTMLPlugin.getInnerTLD();
        Iterator<String> ite = innerTLD.keySet().iterator();
        while (ite.hasNext()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{ite.next(), "[Default]"});
        }
        String[] uri = store.getString("__pref_tld_uri").split("\n");
        String[] path = store.getString("__pref_tld_path").split("\n");
        for (int i = 0; i < uri.length; ++i) {
            if (uri[i].trim().equals("") || path[i].trim().equals("")) continue;
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{uri[i].trim(), path[i].trim()});
        }
        ITLDLocator[] contribs = HTMLPlugin.getDefault().getTLDLocatorContributions();
        for (int i = 0; i < contribs.length; ++i) {
            String cURI = contribs[i].getURI();
            String cPath = contribs[i].getPath();
            if (cURI.trim().equals("") || cPath.trim().equals("")) continue;
            TableItem item = new TableItem(this.table, 0);
            item.setText(new String[]{cURI.trim(), "[Default]" + cPath.trim()});
        }
    }

    private static GridData createButtonGridData() {
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        return gd;
    }

    public void init(IWorkbench workbench) {
    }

    private class TLDDialog
    extends AbstractValidationDialog {
        private Text textUri;
        private Text textPath;
        private String uri;
        private String path;

        public TLDDialog(Shell parentShell) {
            super(parentShell);
            this.uri = "";
            this.path = "";
        }

        public TLDDialog(Shell parentShell, String uri, String path) {
            super(parentShell);
            this.uri = "";
            this.path = "";
            this.uri = uri;
            this.path = path;
        }

        protected void constrainShellSize() {
            Shell shell = this.getShell();
            shell.pack();
            shell.setSize(400, shell.getSize().y);
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.TLD"));
            Composite container = new Composite(parent, 0);
            container.setLayoutData((Object)new GridData(1808));
            container.setLayout((Layout)new GridLayout(3, false));
            Label label = new Label(container, 0);
            label.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Dialog.Uri"));
            this.textUri = new Text(container, 2048);
            this.textUri.setLayoutData((Object)new GridData(768));
            this.textUri.setText(this.uri);
            label = new Label(container, 0);
            label = new Label(container, 0);
            label.setText(HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Dialog.LocalPath"));
            this.textPath = new Text(container, 2048);
            this.textPath.setLayoutData((Object)new GridData(768));
            this.textPath.setText(this.path);
            Button button = new Button(container, 8);
            button.setText("...");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    FileDialog openDialog = new FileDialog(TLDDialog.this.getShell(), 4096);
                    String openFile = openDialog.open();
                    if (openFile != null) {
                        TLDDialog.this.textPath.setText(openFile);
                    }
                }
            });
            this.add(this.textUri);
            this.add(this.textPath);
            return container;
        }

        protected void validate() {
            if (this.textUri.getText().equals("")) {
                this.setErrorMessage(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.Uri")}));
                return;
            }
            if (this.textPath.getText().equals("")) {
                this.setErrorMessage(HTMLPlugin.createMessage(HTMLPlugin.getResourceString("Error.Required"), new String[]{HTMLPlugin.getResourceString("HTMLEditorPreferencePage.LocalPath")}));
                return;
            }
            this.setErrorMessage(null);
        }

        protected void okPressed() {
            this.uri = this.textUri.getText();
            this.path = this.textPath.getText();
            super.okPressed();
        }

        public String getUri() {
            return this.uri;
        }

        public String getPath() {
            return this.path;
        }
    }
}

