/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.assist;

import com.steadystate.css.parser.CSSOMParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;

public class CSSAssistProcessor {
    private HashMap<String, ArrayList<String>> _rules = new HashMap();
    private IFile _file;

    public void reload(IFile file, String source) {
        FuzzyXMLDocument doc;
        this._file = file;
        this._rules.clear();
        source = HTMLUtil.scriptlet2space(source, false);
        if ("html".equalsIgnoreCase(file.getFileExtension())) {
            try {
                doc = (FuzzyXMLDocument)WodParserCache.parser((IResource)file).getHtmlEntry().getModel();
            }
            catch (Exception e) {
                e.printStackTrace();
                doc = null;
            }
        } else {
            doc = new FuzzyXMLParser(false).parse(source);
        }
        if (doc != null) {
            this.processElement(doc.getDocumentElement());
        }
    }

    private void processElement(FuzzyXMLElement element) {
        if (element.getName().equalsIgnoreCase("link")) {
            String rel = "";
            String type = "";
            String href = "";
            FuzzyXMLAttribute[] attrs = element.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i].getName().equalsIgnoreCase("rel")) {
                    rel = attrs[i].getValue();
                    continue;
                }
                if (attrs[i].getName().equalsIgnoreCase("type")) {
                    type = attrs[i].getValue();
                    continue;
                }
                if (!attrs[i].getName().equalsIgnoreCase("href")) continue;
                href = attrs[i].getValue();
            }
            if (rel.equalsIgnoreCase("stylesheet") && type.equalsIgnoreCase("text/css")) {
                try {
                    IFile css = this.getFile(href);
                    if (css != null && css.exists()) {
                        String text = new String(HTMLUtil.readStream(css.getContents()));
                        this.processStylesheet(text);
                    }
                }
                catch (Exception exception) {}
            }
        } else if (element.getName().equalsIgnoreCase("style")) {
            String type = "";
            FuzzyXMLAttribute[] attrs = element.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                if (!attrs[i].getName().equalsIgnoreCase("type")) continue;
                type = attrs[i].getValue();
            }
            if (type.equalsIgnoreCase("text/css")) {
                String text = HTMLUtil.getXPathValue(element, "/");
                this.processStylesheet(text);
            }
        }
        FuzzyXMLNode[] children = element.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof FuzzyXMLElement)) continue;
            this.processElement((FuzzyXMLElement)children[i]);
        }
    }

    private IFile getFile(String path) {
        if (path.startsWith("/")) {
            return null;
        }
        return this._file.getProject().getFile(this._file.getParent().getProjectRelativePath().append(path));
    }

    private void processStylesheet(String css) {
        try {
            CSSOMParser parser = new CSSOMParser();
            InputSource is = new InputSource((Reader)new StringReader(css));
            CSSStyleSheet stylesheet = parser.parseStyleSheet(is);
            CSSRuleList list = stylesheet.getCssRules();
            for (int i = 0; i < list.getLength(); ++i) {
                CSSRule rule = list.item(i);
                if (!(rule instanceof CSSStyleRule)) continue;
                CSSStyleRule styleRule = (CSSStyleRule)rule;
                String selector = styleRule.getSelectorText();
                SelectorList selectors = parser.parseSelectors(new InputSource((Reader)new StringReader(selector)));
                for (int j = 0; j < selectors.getLength(); ++j) {
                    ArrayList<Object> classes;
                    Selector sel = selectors.item(j);
                    if (!(sel instanceof ConditionalSelector)) continue;
                    Condition cond = ((ConditionalSelector)sel).getCondition();
                    SimpleSelector simple = ((ConditionalSelector)sel).getSimpleSelector();
                    if (!(simple instanceof ElementSelector)) continue;
                    String tagName = ((ElementSelector)simple).getLocalName();
                    tagName = tagName == null ? "*" : tagName.toLowerCase();
                    if (!(cond instanceof AttributeCondition)) continue;
                    AttributeCondition attrCond = (AttributeCondition)cond;
                    if (this._rules.get(tagName) == null) {
                        classes = new ArrayList<String>();
                        classes.add(attrCond.getValue());
                        this._rules.put(tagName, classes);
                        continue;
                    }
                    classes = this._rules.get(tagName);
                    classes.add(attrCond.getValue());
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public AssistInfo[] getAssistInfo(String tagName, String value) {
        try {
            value = value.indexOf(32) != -1 ? value.substring(0, value.lastIndexOf(32) + 1) : "";
            ArrayList<String> assists = new ArrayList<String>();
            ArrayList<String> all = this._rules.get("*");
            if (all != null) {
                assists.addAll(all);
            }
            if (this._rules.get(tagName.toLowerCase()) != null) {
                ArrayList<String> list = this._rules.get(tagName.toLowerCase());
                assists.addAll(list);
            }
            AssistInfo[] info = new AssistInfo[assists.size()];
            for (int i = 0; i < assists.size(); ++i) {
                String keyword = (String)assists.get(i);
                info[i] = new AssistInfo(value + keyword, keyword);
            }
            return info;
        }
        catch (Exception exception) {
            return new AssistInfo[0];
        }
    }
}

