/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLCDATA;
import jp.aonir.fuzzyxml.FuzzyXMLComment;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditor;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;

public class HTMLOutlinePage
extends ContentOutlinePage
implements IHTMLOutlinePage {
    private RootNode root;
    private HTMLSourceEditor editor;
    private FuzzyXMLDocument doc;

    public HTMLOutlinePage(HTMLSourceEditor editor) {
        this.editor = editor;
    }

    public FuzzyXMLDocument getDoc() {
        return this.doc;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer viewer = this.getTreeViewer();
        this.root = new RootNode();
        viewer.setContentProvider((IContentProvider)new HTMLContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new HTMLLabelProvider());
        viewer.setInput((Object)this.root);
        viewer.addSelectionChangedListener((ISelectionChangedListener)new HTMLSelectionChangedListener());
        try {
            viewer.setExpandedState(this.root.getChildren()[0], true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
    }

    protected boolean isHTML() {
        return true;
    }

    protected FuzzyXMLParser createParser() {
        FuzzyXMLParser parser = new FuzzyXMLParser(this.isHTML());
        return parser;
    }

    public void update() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        IFile file = ((FileEditorInput)this.editor.getEditorInput()).getFile();
        try {
            this.doc = this.createParser().parse(this.editor.getHTMLSource());
            TreeViewer viewer = this.getTreeViewer();
            if (viewer != null) {
                viewer.refresh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Image getNodeImage(FuzzyXMLNode element) {
        if (element instanceof FuzzyXMLCDATA) {
            return null;
        }
        if (element instanceof FuzzyXMLElement) {
            FuzzyXMLElement e = (FuzzyXMLElement)element;
            if (e.getName().equalsIgnoreCase("html")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_html");
            }
            if (e.getName().equalsIgnoreCase("title")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_title");
            }
            if (e.getName().equalsIgnoreCase("body")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_body");
            }
            if (e.getName().equalsIgnoreCase("form")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_form");
            }
            if (e.getName().equalsIgnoreCase("img")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_image");
            }
            if (e.getName().equalsIgnoreCase("a")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_link");
            }
            if (e.getName().equalsIgnoreCase("table")) {
                return HTMLPlugin.getDefault().getImageRegistry().get("_icon_table");
            }
            if (e.getName().equalsIgnoreCase("input")) {
                String type = e.getAttributeValue("type");
                if (type != null) {
                    if (type.equalsIgnoreCase("button") || type.equalsIgnoreCase("reset") || type.equalsIgnoreCase("submit")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_button");
                    }
                    if (type.equalsIgnoreCase("radio")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_radio");
                    }
                    if (type.equalsIgnoreCase("checkbox")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_check");
                    }
                    if (type.equalsIgnoreCase("text")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_text");
                    }
                    if (type.equalsIgnoreCase("password")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_pass");
                    }
                    if (type.equalsIgnoreCase("hidden")) {
                        return HTMLPlugin.getDefault().getImageRegistry().get("_icon_hidden");
                    }
                }
            } else {
                if (e.getName().equalsIgnoreCase("select")) {
                    return HTMLPlugin.getDefault().getImageRegistry().get("_icon_select");
                }
                if (e.getName().equalsIgnoreCase("textarea")) {
                    return HTMLPlugin.getDefault().getImageRegistry().get("_icon_textarea");
                }
            }
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_tag");
        }
        if (element instanceof FuzzyXMLDocType) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_doctype");
        }
        if (element instanceof FuzzyXMLComment) {
            return HTMLPlugin.getDefault().getImageRegistry().get("_icon_comment");
        }
        return null;
    }

    protected Object[] getNodeChildren(FuzzyXMLElement element) {
        ArrayList<FuzzyXMLNode> children = new ArrayList<FuzzyXMLNode>();
        FuzzyXMLNode[] nodes = element.getChildren();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] instanceof FuzzyXMLElement) {
                children.add(nodes[i]);
                continue;
            }
            if (nodes[i] instanceof FuzzyXMLDocType) {
                children.add(nodes[i]);
                continue;
            }
            if (!(nodes[i] instanceof FuzzyXMLComment)) continue;
            children.add(nodes[i]);
        }
        return children.toArray(new FuzzyXMLNode[children.size()]);
    }

    protected String getNodeText(FuzzyXMLNode node) {
        if (node instanceof FuzzyXMLCDATA) {
            return "CDATA";
        }
        if (node instanceof FuzzyXMLElement) {
            StringBuffer sb = new StringBuffer();
            FuzzyXMLAttribute[] attrs = ((FuzzyXMLElement)node).getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(attrs[i].getName() + "=" + attrs[i].getValue());
            }
            if (sb.length() == 0) {
                return ((FuzzyXMLElement)node).getName();
            }
            return ((FuzzyXMLElement)node).getName() + "(" + sb.toString() + ")";
        }
        if (node instanceof FuzzyXMLDocType) {
            return "DOCTYPE";
        }
        if (node instanceof FuzzyXMLComment) {
            return "#comment";
        }
        return node.toString();
    }

    private class HTMLSelectionChangedListener
    implements ISelectionChangedListener {
        private HTMLSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            Object element = sel.getFirstElement();
            if (element instanceof FuzzyXMLNode) {
                int offset = ((FuzzyXMLNode)element).getOffset();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = page.getActiveEditor();
                if (editorPart instanceof HTMLEditor) {
                    ((HTMLEditor)editorPart).setOffset(offset);
                } else if (editorPart instanceof HTMLSourceEditor) {
                    ((HTMLSourceEditor)editorPart).selectAndReveal(offset, 0);
                } else {
                    HTMLSourceEditor sourceEditor = (HTMLSourceEditor)((Object)editorPart.getAdapter(HTMLSourceEditor.class));
                    if (sourceEditor != null) {
                        sourceEditor.selectAndReveal(offset, 0);
                    }
                }
            }
        }
    }

    private class HTMLLabelProvider
    extends LabelProvider {
        private HTMLLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof FuzzyXMLNode) {
                return HTMLOutlinePage.this.getNodeImage((FuzzyXMLNode)element);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof FuzzyXMLNode) {
                return HTMLOutlinePage.this.getNodeText((FuzzyXMLNode)element);
            }
            return super.getText(element);
        }
    }

    private class HTMLContentProvider
    implements ITreeContentProvider {
        private HTMLContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RootNode) {
                return ((RootNode)parentElement).getChildren();
            }
            if (parentElement instanceof FuzzyXMLElement) {
                return HTMLOutlinePage.this.getNodeChildren((FuzzyXMLElement)parentElement);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof FuzzyXMLNode) {
                FuzzyXMLNode parent = ((FuzzyXMLNode)element).getParentNode();
                if (parent == null) {
                    return HTMLOutlinePage.this.root.getChildren()[0];
                }
                return parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class RootNode {
        private boolean _updating;

        public Object[] getChildren() {
            ArrayList<FuzzyXMLNode> children = new ArrayList<FuzzyXMLNode>();
            if (HTMLOutlinePage.this.doc == null) {
                if (this._updating) {
                    System.out.println("RootNode.getChildren: Attempted to update root node while already in an update pass.");
                } else {
                    this._updating = true;
                    try {
                        HTMLOutlinePage.this.update();
                    }
                    finally {
                        this._updating = false;
                    }
                }
            }
            if (HTMLOutlinePage.this.doc != null) {
                if (HTMLOutlinePage.this.doc.getDocumentType() != null) {
                    children.add(HTMLOutlinePage.this.doc.getDocumentType());
                }
                FuzzyXMLNode[] nodes = HTMLOutlinePage.this.doc.getDocumentElement().getChildren();
                for (int i = 0; i < nodes.length; ++i) {
                    if (!(nodes[i] instanceof FuzzyXMLElement)) continue;
                    children.add(nodes[i]);
                }
            }
            return children.toArray(new FuzzyXMLNode[children.size()]);
        }

        public boolean equals(Object obj) {
            return obj instanceof RootNode;
        }
    }
}

