/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class HTMLTagNameRule
extends WordRule
implements IPredicateRule {
    private IToken _woToken;

    public HTMLTagNameRule(IToken defaultToken, IToken woToken) {
        super((IWordDetector)new HTMLTagWordDetector(), defaultToken);
        this._woToken = woToken;
    }

    public IToken getSuccessToken() {
        return this.fDefaultToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        IToken token;
        int startColumn = scanner.getColumn();
        if (startColumn >= 1) {
            int possibleWoChar;
            boolean isTag = false;
            scanner.unread();
            int ch = scanner.read();
            if (ch == 47) {
                if (startColumn >= 2) {
                    scanner.unread();
                    scanner.unread();
                    ch = scanner.read();
                    if (ch == 60) {
                        isTag = true;
                    }
                    scanner.read();
                }
            } else if (ch == 60) {
                isTag = true;
            }
            boolean possibleWoTag = (possibleWoChar = scanner.read()) == 119 || possibleWoChar == 87;
            scanner.unread();
            if (isTag) {
                token = super.evaluate(scanner);
                if (possibleWoTag && token == this.fDefaultToken) {
                    int endColumn = scanner.getColumn();
                    token = this._woToken;
                }
            } else {
                token = Token.UNDEFINED;
            }
        } else {
            token = Token.UNDEFINED;
        }
        return token;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        IToken token = this.evaluate(scanner);
        return token;
    }

    protected static class HTMLTagWordDetector
    implements IWordDetector {
        protected HTMLTagWordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isLetterOrDigit(c) || c == ':' || c == '_';
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c);
        }
    }
}

