/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.editors;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.tidy.Tidy;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;

public class HTMLValidator
implements FuzzyXMLErrorListener {
    private String _original;
    private String _contents;
    private IFile _file;
    private Pattern TIDY_ERROR = Pattern.compile("^line ([0-9]+?) column ([0-9]+?) - (.+?)$", 32);
    private boolean _showXMLErrors;

    public HTMLValidator(IFile file) {
        this._file = file;
        this._showXMLErrors = this.showXMLErrors();
    }

    public boolean showXMLErrors() {
        IPreferenceStore store = HTMLPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("__pref_show_xml_errors");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doValidate() {
        try {
            if (this.validateUsingTidy()) {
                ByteArrayOutputStream out = null;
                try {
                    out = new ByteArrayOutputStream();
                    Tidy tidy = new Tidy();
                    tidy.setXHTML(false);
                    tidy.setCharEncoding(0);
                    tidy.setErrout(new PrintWriter(out, true));
                    tidy.parse(this._file.getContents(), null);
                    String errors = new String(out.toByteArray());
                    errors = errors.replaceAll("\r\n", "\n");
                    errors = errors.replaceAll("\r", "\n");
                    String[] dim = errors.split("\n");
                    for (int i = 0; i < dim.length; ++i) {
                        Matcher matcher;
                        if (!dim[i].startsWith("line") || !(matcher = this.TIDY_ERROR.matcher(dim[i])).matches()) continue;
                        String message = matcher.group(3);
                        if (message.startsWith("Warning")) {
                            HTMLUtil.addMarker((IResource)this._file, 1, Integer.parseInt(matcher.group(1)), matcher.group(3));
                            continue;
                        }
                        HTMLUtil.addMarker((IResource)this._file, 2, Integer.parseInt(matcher.group(1)), matcher.group(3));
                    }
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
            }
            if (this.validateUsingFuzzyXML()) {
                this._original = new String(HTMLUtil.readStream(this._file.getContents()), this._file.getCharset());
                String contents = this.filterContents(this._original, this._file);
                this._contents = contents = HTMLUtil.scriptlet2space(contents, false);
                this._contents = this._contents.replaceAll("\r\n", " \n");
                this._contents = this._contents.replaceAll("\r", "\n");
                FuzzyXMLParser parser = new FuzzyXMLParser(false);
                parser.addErrorListener(this);
                FuzzyXMLDocument doc = parser.parse(contents);
                this.validateDocument(doc);
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    protected boolean validateUsingTidy() {
        return true;
    }

    protected boolean validateUsingFuzzyXML() {
        return false;
    }

    protected void validateDocument(FuzzyXMLDocument doc) {
    }

    protected IFile getFile() {
        return this._file;
    }

    protected String getContent() {
        return this._original;
    }

    protected int getLineAtOffset(int offset) {
        String text = this._contents.substring(0, offset + 1);
        return text.split("\n").length;
    }

    protected String filterContents(String contents, IFile file) {
        return contents;
    }

    protected boolean showXMLError(FuzzyXMLErrorEvent event) {
        return this._showXMLErrors;
    }

    public void error(FuzzyXMLErrorEvent event) {
        if (!this.showXMLError(event)) {
            return;
        }
        int offset = event.getOffset();
        int length = event.getLength();
        String message = event.getMessage();
        HTMLUtil.addMarker((IResource)this.getFile(), 2, this.getLineAtOffset(offset), offset, length, message);
    }
}

