/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.htmleditor.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.views.IPaletteItem;

public class DefaultPaletteItem
implements IPaletteItem {
    private String _name;
    private ImageDescriptor _image;
    private String _content;

    public DefaultPaletteItem(String name, ImageDescriptor image, String content) {
        this._name = name;
        this._image = image;
        this._content = content;
    }

    public ImageDescriptor getImageDescriptor() {
        return this._image;
    }

    public String getLabel() {
        return this._name;
    }

    public String getContent() {
        return this._content;
    }

    public void execute(HTMLSourceEditor editor) {
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        ITextSelection sel = (ITextSelection)editor.getSelectionProvider().getSelection();
        try {
            int cursorOffset;
            int variableOffset;
            int explicitCursorOffset = this._content.indexOf("${cursor}");
            String content = explicitCursorOffset != -1 ? this._content.substring(0, explicitCursorOffset) + this._content.substring(explicitCursorOffset + "${cursor}".length()) : this._content;
            int defaultCursorOffset = content.length();
            if (content.indexOf("></") != -1) {
                defaultCursorOffset = content.indexOf("></") + 1;
            }
            if ((variableOffset = content.indexOf("${selection}")) != -1) {
                doc.replace(sel.getOffset(), 0, content.substring(0, variableOffset));
                doc.replace(sel.getOffset() + variableOffset + sel.getLength(), 0, content.substring(variableOffset + "${selection}".length()));
                cursorOffset = explicitCursorOffset == -1 ? defaultCursorOffset : (explicitCursorOffset < variableOffset ? explicitCursorOffset : explicitCursorOffset + sel.getLength() - "${selection}".length());
            } else {
                doc.replace(sel.getOffset(), sel.getLength(), content);
                cursorOffset = explicitCursorOffset == -1 ? defaultCursorOffset : explicitCursorOffset;
            }
            editor.selectAndReveal(sel.getOffset() + cursorOffset, 0);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

