/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.ICustomTagAttributeAssist;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.TagDefinition;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.assist.TextInfo;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.jspeditor.editors.JSPInfo;
import tk.eclipse.plugin.jspeditor.editors.JSPScriptletAssistProcessor;
import tk.eclipse.plugin.jspeditor.editors.JSPSourceEditor;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;
import tk.eclipse.plugin.xmleditor.editors.ClassNameAssistProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPAssistProcessor
extends HTMLAssistProcessor {
    private static final int SCOPE = 100;
    private static final int CLASS = 101;
    private List<TagInfo> _tagList = new ArrayList<TagInfo>(TagDefinition.getTagInfoAsList());
    private List<TagInfo> _cunstomTagList = new ArrayList<TagInfo>();
    private HashMap<String, String> _namespace = new HashMap();
    private ClassNameAssistProcessor _classNameProcessor = new ClassNameAssistProcessor();
    private JSPScriptletAssistProcessor _scriptletProcessor = new JSPScriptletAssistProcessor();
    private IFile _file = null;

    public JSPAssistProcessor() {
        TagInfo useBean = new TagInfo("jsp:useBean", true);
        useBean.addAttributeInfo(new AttributeInfo("id", true));
        useBean.addAttributeInfo(new AttributeInfo("scope", true, 100));
        useBean.addAttributeInfo(new AttributeInfo("class", true, 101));
        this._tagList.add(useBean);
        TagInfo setProperty = new TagInfo("jsp:setProperty", false);
        setProperty.addAttributeInfo(new AttributeInfo("name", true));
        setProperty.addAttributeInfo(new AttributeInfo("param", true));
        setProperty.addAttributeInfo(new AttributeInfo("property", true));
        this._tagList.add(setProperty);
        TagInfo include = new TagInfo("jsp:include", false);
        include.addAttributeInfo(new AttributeInfo("page", true));
        this._tagList.add(include);
        TagInfo forward = new TagInfo("jsp:forward", true);
        forward.addAttributeInfo(new AttributeInfo("page", true));
        this._tagList.add(forward);
        TagInfo param = new TagInfo("jsp:param", false);
        param.addAttributeInfo(new AttributeInfo("name", true));
        param.addAttributeInfo(new AttributeInfo("value", true));
        this._tagList.add(param);
        TagInfo attribute = new TagInfo("jsp:attribute", true);
        attribute.addAttributeInfo(new AttributeInfo("name", true));
        this._tagList.add(attribute);
        TagInfo body = new TagInfo("jsp:body", true);
        this._tagList.add(body);
        TagInfo element = new TagInfo("jsp:element", true);
        element.addAttributeInfo(new AttributeInfo("name", true));
        this._tagList.add(element);
        TagInfo text = new TagInfo("jsp:text", true);
        this._tagList.add(text);
        this._tagList.add(new TextInfo("<%  %>", 3));
        this._tagList.add(new TextInfo("<%=  %>", 4));
        this._tagList.add(new TextInfo("<%@ page %>", 9));
        this._tagList.add(new TextInfo("<%@ include %>", "<%@ include file=\"\" %>", 18));
        this._tagList.add(new TextInfo("<%@ taglib %>", "<%@ taglib prefix=\"\" %>", 19));
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        int end;
        String rawText = viewer.getDocument().get();
        String text = (rawText = HTMLUtil.comment2space(rawText, false)).substring(0, documentOffset);
        int begin = text.lastIndexOf("<%");
        if (begin >= 0 && (end = rawText.indexOf("%>", begin)) >= 0 && documentOffset < end) {
            return this._scriptletProcessor.computeCompletionProposals(viewer, documentOffset);
        }
        return super.computeCompletionProposals(viewer, documentOffset);
    }

    @Override
    protected AssistInfo[] getAttributeValues(String tagName, String value, TagInfo tagInfo, AttributeInfo attrInfo) {
        if (tagName.indexOf(":") != -1) {
            String[] dim = tagName.split(":");
            String uri = this.getUri(dim[0]);
            ICustomTagAttributeAssist[] assists = HTMLPlugin.getDefault().getCustomTagAttributeAssists();
            for (int i = 0; i < assists.length; ++i) {
                AssistInfo[] values = assists[i].getAttributeValues(dim[1], uri, value, attrInfo);
                if (values == null) continue;
                return values;
            }
        }
        if (attrInfo.getAttributeType() == 100) {
            return new AssistInfo[]{new AssistInfo("application"), new AssistInfo("page"), new AssistInfo("request"), new AssistInfo("session")};
        }
        if (attrInfo.getAttributeType() == 101 && this._file != null) {
            return this._classNameProcessor.getClassAttributeValues(this._file, value);
        }
        return super.getAttributeValues(tagName, value, tagInfo, attrInfo);
    }

    @Override
    protected TagInfo getTagInfo(String name) {
        List<TagInfo> tagList = this.getTagList();
        for (int i = 0; i < tagList.size(); ++i) {
            TagInfo info = tagList.get(i);
            if (info.getTagName() == null || !name.equals(info.getTagName().toLowerCase())) continue;
            return info;
        }
        return null;
    }

    @Override
    protected List<TagInfo> getTagList() {
        ArrayList<TagInfo> list = new ArrayList<TagInfo>();
        list.addAll(this._tagList);
        list.addAll(this._cunstomTagList);
        return list;
    }

    private String getUri(String prefix) {
        return this._namespace.get(prefix);
    }

    @Override
    public void update(HTMLSourceEditor editor, String source) {
        super.update(editor, source);
        this._scriptletProcessor.update((JSPSourceEditor)editor);
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)editor.getEditorInput();
            this._cunstomTagList.clear();
            this._namespace.clear();
            JSPInfo jspInfo = JSPInfo.getJSPInfo(input.getFile(), source);
            TLDInfo[] tlds = jspInfo.getTLDInfo();
            for (int i = 0; i < tlds.length; ++i) {
                this._namespace.put(tlds[i].getPrefix(), tlds[i].getTaglibUri());
                this._cunstomTagList.addAll(tlds[i].getTagInfo());
            }
            this._file = input.getFile();
        }
    }
}

