/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditor;
import tk.eclipse.plugin.htmleditor.editors.HTMLEditorPart;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.jspeditor.editors.JSPConfiguration;
import tk.eclipse.plugin.jspeditor.editors.JSPPreviewConverter;
import tk.eclipse.plugin.jspeditor.editors.JSPSourceEditor;

public class JSPEditor
extends HTMLEditor {
    private JSPConfiguration configuration;

    protected HTMLSourceEditor createHTMLSourceEditor(HTMLConfiguration config) {
        return new JSPSourceEditor(config);
    }

    protected HTMLConfiguration getSourceViewerConfiguration() {
        if (this.configuration == null) {
            this.configuration = new JSPConfiguration(HTMLPlugin.getDefault().getColorProvider());
        }
        return this.configuration;
    }

    public void updatePreview() {
        if (!(this._editor instanceof HTMLEditorPart)) {
            return;
        }
        try {
            if (!((HTMLEditorPart)this._editor).isFileEditorInput()) {
                return;
            }
            HTMLEditorPart editor = (HTMLEditorPart)this._editor;
            IFileEditorInput input = (IFileEditorInput)this._editor.getEditorInput();
            String charset = input.getFile().getCharset();
            String html = editor.getSourceEditor().getDocumentProvider().getDocument((Object)input).get();
            html = JSPPreviewConverter.convertJSP((IFileEditorInput)this.getEditorInput(), html);
            File tmpFile = editor.getSourceEditor().getTempFile();
            FileOutputStream out = new FileOutputStream(tmpFile);
            PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)out, charset), true);
            pw.write(html);
            pw.close();
            if (this._prevTempFile != null && this._prevTempFile.equals(tmpFile)) {
                editor.getBrowser().refresh();
            } else {
                if (this._prevTempFile != null) {
                    this._prevTempFile.delete();
                }
                this._prevTempFile = tmpFile;
                editor.getBrowser().setUrl("file://" + tmpFile.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }
}

