/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jspeditor.editors;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.xerces.parsers.DOMParser;
import org.eclipse.jdt.core.IJavaProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.gefutils.IJarVisitor;
import tk.eclipse.plugin.htmleditor.gefutils.JarAcceptor;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;
import tk.eclipse.plugin.jspeditor.editors.TLDResolver;
import tk.eclipse.plugin.jspeditor.editors.TagFileParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLDParser {
    private IJavaProject project;
    private String uri = null;
    private String prefix = "";
    private ArrayList<TagInfo> result = new ArrayList();

    public TLDParser(IJavaProject project, String prefix) {
        this.project = project;
        this.prefix = prefix;
    }

    public TLDParser(IJavaProject project) {
        this(project, null);
    }

    public String getUri() {
        return this.uri;
    }

    public List<TagInfo> getResult() {
        return this.result;
    }

    public void parse(InputStream in) throws Exception {
        DOMParser parser = new DOMParser();
        parser.setEntityResolver((EntityResolver)new TLDResolver());
        parser.parse(new InputSource(in));
        Document doc = parser.getDocument();
        Element element = doc.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            TagInfo tagInfo;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element childElement = (Element)nodeList.item(i);
            String elementName = childElement.getNodeName();
            if (elementName.equals("tag")) {
                this.result.add(this.parseTagElement(childElement));
                continue;
            }
            if (elementName.equals("uri")) {
                this.uri = TLDParser.getChildText(childElement);
                continue;
            }
            if (elementName.equals("shortname") || elementName.equals("short-name")) {
                if (this.prefix != null) continue;
                this.prefix = TLDParser.getChildText(childElement);
                continue;
            }
            if (!elementName.equals("tag-file") || (tagInfo = this.parseTagFileElement(childElement)) == null) continue;
            this.result.add(tagInfo);
        }
    }

    private TagInfo parseTagElement(Element tag) {
        NodeList children = tag.getChildNodes();
        ArrayList<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
        String name = null;
        String description = "";
        boolean hasBody = true;
        for (int j = 0; j < children.getLength(); ++j) {
            Node node = children.item(j);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String elementName = element.getNodeName();
            if (elementName.equals("name")) {
                name = this.prefix + ":" + TLDParser.getChildText(element);
                continue;
            }
            if (elementName.equals("bodycontent") || elementName.equals("body-content")) {
                hasBody = !TLDParser.getChildText(element).equals("empty");
                continue;
            }
            if (elementName.equals("description")) {
                description = TLDParser.wrap(TLDParser.getChildText(element));
                continue;
            }
            if (!elementName.equals("attribute")) continue;
            AttributeInfo attrInfo = this.parseAttributeElement(element);
            attributes.add(attrInfo);
        }
        TagInfo info = new TagInfo(name, hasBody);
        info.setDescription(description);
        for (int i = 0; i < attributes.size(); ++i) {
            info.addAttributeInfo((AttributeInfo)attributes.get(i));
        }
        return info;
    }

    private AttributeInfo parseAttributeElement(Element attr) {
        NodeList children = attr.getChildNodes();
        String name = null;
        String description = "";
        boolean required = false;
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String elementName = element.getNodeName();
            if (elementName.equals("name")) {
                name = TLDParser.getChildText(element);
                continue;
            }
            if (elementName.equals("description")) {
                description = TLDParser.wrap(TLDParser.getChildText(element));
                continue;
            }
            if (!elementName.equals("required")) continue;
            required = TLDParser.getChildText(element).equals("true");
        }
        AttributeInfo attrInfo = new AttributeInfo(name, true, 0, required);
        attrInfo.setDescription(description);
        return attrInfo;
    }

    private static String getChildText(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Text)) continue;
            sb.append(node.getNodeValue());
        }
        return sb.toString().trim().replaceAll("\\s+", " ");
    }

    private static String wrap(String text) {
        StringBuffer sb = new StringBuffer();
        int word = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (word > 40 && (c == ' ' || c == '\t')) {
                sb.append('\n');
                word = 0;
                continue;
            }
            sb.append(c);
            ++word;
        }
        return sb.toString();
    }

    private TagInfo parseTagFileElement(Element tagFile) throws Exception {
        NodeList children = tagFile.getChildNodes();
        ArrayList<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
        String name = null;
        String description = "";
        boolean hasBody = true;
        for (int j = 0; j < children.getLength(); ++j) {
            Node node = children.item(j);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            String elementName = element.getNodeName();
            if (elementName.equals("name")) {
                name = this.prefix + ":" + TLDParser.getChildText(element);
                continue;
            }
            if (elementName.equals("description")) {
                description = TLDParser.wrap(TLDParser.getChildText(element));
                continue;
            }
            if (!elementName.equals("path") || this.project == null) continue;
            String path = TLDParser.getChildText(element);
            InputStream in = this.getTagFile(path);
            if (in != null) {
                TagInfo tagInfo = TagFileParser.parseTagFile(null, null, in);
                for (int i = 0; i < tagInfo.getAttributeInfo().length; ++i) {
                    attributes.add(tagInfo.getAttributeInfo()[i]);
                }
                continue;
            }
            return null;
        }
        TagInfo info = new TagInfo(name, hasBody);
        info.setDescription(description);
        for (int i = 0; i < attributes.size(); ++i) {
            info.addAttributeInfo((AttributeInfo)attributes.get(i));
        }
        return info;
    }

    private InputStream getTagFile(final String path) {
        try {
            if (path.startsWith("/META-INF/tags")) {
                return (InputStream)JarAcceptor.accept(this.project.getProject(), new IJarVisitor(){

                    public Object visit(JarFile file, JarEntry entry) throws Exception {
                        if (("/" + entry.getName()).equals(path)) {
                            return file.getInputStream(entry);
                        }
                        return null;
                    }
                });
            }
            File basedir = TLDInfo.getBaseDir(this.project.getProject()).getLocation().makeAbsolute().toFile();
            File file = new File(basedir, path);
            return new FileInputStream(file);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
            return null;
        }
    }
}

