/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import com.wutka.dtd.DTD;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDParseException;
import com.wutka.dtd.DTDParser;
import com.wutka.dtd.DTDSequence;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.ui.IFileEditorInput;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.assist.AssistInfo;
import tk.eclipse.plugin.htmleditor.assist.AttributeInfo;
import tk.eclipse.plugin.htmleditor.assist.HTMLAssistProcessor;
import tk.eclipse.plugin.htmleditor.assist.TagInfo;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.xmleditor.editors.ClassNameAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLAssistProcessor
extends HTMLAssistProcessor {
    private List<TagInfo> _tagList = new ArrayList<TagInfo>();
    private Map<String, ArrayList<TagInfo>> _nsTagListMap = new HashMap<String, ArrayList<TagInfo>>();
    private XMLEditor _editor;
    private IFileEditorInput _input;
    private ClassNameAssistProcessor _classNameAssistant = new ClassNameAssistProcessor();

    @Override
    public void update(HTMLSourceEditor editor, String source) {
        if (editor.getEditorInput() instanceof IFileEditorInput) {
            this._input = (IFileEditorInput)editor.getEditorInput();
        }
        if (editor instanceof XMLEditor) {
            this._editor = (XMLEditor)editor;
        }
    }

    public void updateDTDInfo(Reader in) {
        this._tagList.clear();
        try {
            DTDParser parser = new DTDParser(in);
            DTD dtd = parser.parse();
            Object[] obj = dtd.getItems();
            for (int i = 0; i < obj.length; ++i) {
                if (!(obj[i] instanceof DTDElement)) continue;
                DTDElement element = (DTDElement)obj[i];
                String name = element.getName();
                DTDItem item = element.getContent();
                boolean hasBody = true;
                if (item instanceof DTDEmpty) {
                    hasBody = false;
                }
                TagInfo tagInfo = new TagInfo(name, hasBody);
                Iterator ite = element.attributes.keySet().iterator();
                if (item instanceof DTDSequence) {
                    DTDSequence seq = (DTDSequence)item;
                    this.setChildTagName(tagInfo, seq.getItem());
                } else if (item instanceof DTDMixed) {
                    // empty if block
                }
                while (ite.hasNext()) {
                    String attrName = (String)ite.next();
                    DTDAttribute attr = element.getAttribute(attrName);
                    DTDDecl decl = attr.getDecl();
                    boolean required = false;
                    if (decl == DTDDecl.REQUIRED) {
                        required = true;
                    }
                    AttributeInfo attrInfo = new AttributeInfo(attrName, true, 0, required);
                    tagInfo.addAttributeInfo(attrInfo);
                    Object attrType = attr.getType();
                    if (attrType instanceof DTDEnumeration) {
                        DTDEnumeration dtdEnum = (DTDEnumeration)attrType;
                        String[] items = dtdEnum.getItems();
                        for (int j = 0; j < items.length; ++j) {
                            attrInfo.addValue(items[j]);
                        }
                        continue;
                    }
                    if (attrType.equals("ID")) {
                        attrInfo.setAttributeType(6);
                        continue;
                    }
                    if (attrType.equals("IDREF")) {
                        attrInfo.setAttributeType(7);
                        continue;
                    }
                    if (!attrType.equals("IDREFS")) continue;
                    attrInfo.setAttributeType(8);
                }
                this._tagList.add(tagInfo);
            }
        }
        catch (DTDParseException parser) {
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    public void updateXSDInfo(String uri, Reader in) {
        try {
            SchemaGrammar grammer = (SchemaGrammar)new XMLSchemaLoader().loadGrammar(new XMLInputSource(null, null, null, in, null));
            String targetNS = grammer.getTargetNamespace();
            this._nsTagListMap.put(targetNS, new ArrayList());
            List tagList = this._nsTagListMap.get(targetNS);
            XSNamedMap map = grammer.getComponents((short)2);
            for (int i = 0; i < map.getLength(); ++i) {
                XSElementDeclaration element = (XSElementDeclaration)map.item(i);
                this.parseXSDElement(tagList, element);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseXSDElement(List<TagInfo> tagList, XSElementDeclaration element) {
        TagInfo tagInfo = new TagInfo(element.getName(), true);
        if (tagList.contains(tagInfo)) {
            return;
        }
        tagList.add(tagInfo);
        XSTypeDefinition type = element.getTypeDefinition();
        if (type instanceof XSComplexTypeDefinition) {
            XSParticle particle = ((XSComplexTypeDefinition)type).getParticle();
            if (particle != null) {
                XSTerm term = particle.getTerm();
                if (term instanceof XSElementDeclaration) {
                    this.parseXSDElement(tagList, (XSElementDeclaration)term);
                    tagInfo.addChildTagName(((XSElementDeclaration)term).getName());
                }
                if (term instanceof XSModelGroup) {
                    this.parseXSModelGroup(tagInfo, tagList, (XSModelGroup)term);
                }
            }
            XSObjectList attrs = ((XSComplexTypeDefinition)type).getAttributeUses();
            for (int i = 0; i < attrs.getLength(); ++i) {
                XSAttributeUse attrUse = (XSAttributeUse)attrs.item(i);
                XSAttributeDeclaration attr = attrUse.getAttrDeclaration();
                AttributeInfo attrInfo = new AttributeInfo(attr.getName(), true, 0, attrUse.getRequired());
                tagInfo.addAttributeInfo(attrInfo);
            }
        }
    }

    private void parseXSModelGroup(TagInfo tagInfo, List<TagInfo> tagList, XSModelGroup term) {
        XSObjectList list = term.getParticles();
        for (int i = 0; i < list.getLength(); ++i) {
            XSObject obj = list.item(i);
            if (!(obj instanceof XSParticle)) continue;
            XSTerm term2 = ((XSParticle)obj).getTerm();
            if (term2 instanceof XSElementDeclaration) {
                this.parseXSDElement(tagList, (XSElementDeclaration)term2);
                tagInfo.addChildTagName(((XSElementDeclaration)term2).getName());
            }
            if (!(term2 instanceof XSModelGroup)) continue;
            this.parseXSModelGroup(tagInfo, tagList, (XSModelGroup)term2);
        }
    }

    private void setChildTagName(TagInfo tagInfo, DTDItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] instanceof DTDName) {
                DTDName dtdName = (DTDName)items[i];
                tagInfo.addChildTagName(dtdName.getValue());
                continue;
            }
            if (!(items[i] instanceof DTDChoice)) continue;
            DTDChoice dtdChoise = (DTDChoice)items[i];
            this.setChildTagName(tagInfo, dtdChoise.getItem());
        }
    }

    @Override
    protected boolean supportTagRelation() {
        return true;
    }

    @Override
    protected AssistInfo[] getAttributeValues(String tagName, String value, TagInfo tagInfo, AttributeInfo attrInfo) {
        if (attrInfo.getAttributeType() == 7 || attrInfo.getAttributeType() == 8) {
            return super.getAttributeValues(tagName, value, tagInfo, attrInfo);
        }
        String[] values = attrInfo.getValues();
        if (values.length == 0) {
            return this.getClassAttributeValues(value, attrInfo.getAttributeName());
        }
        AssistInfo[] infos = new AssistInfo[values.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new AssistInfo(values[i]);
        }
        return infos;
    }

    protected AssistInfo[] getClassAttributeValues(String value, String attrName) {
        if (this._input == null || this._editor == null || value.length() == 0) {
            return new AssistInfo[0];
        }
        String[] classNameAttributes = this._editor.getClassNameAttributes();
        for (int i = 0; i < classNameAttributes.length; ++i) {
            if (!attrName.equals(classNameAttributes[i])) continue;
            return this._classNameAssistant.getClassAttributeValues(this._input.getFile(), value);
        }
        return new AssistInfo[0];
    }

    @Override
    protected List<TagInfo> getTagList() {
        ArrayList<TagInfo> list = new ArrayList<TagInfo>();
        list.addAll(this._tagList);
        FuzzyXMLElement element = this.getOffsetElement();
        HashMap<String, String> nsPrefixMap = new HashMap<String, String>();
        this.getNamespace(nsPrefixMap, element);
        for (String uri : this._nsTagListMap.keySet()) {
            String prefix = nsPrefixMap.get(uri);
            if (prefix == null || prefix.equals("")) {
                list.addAll((Collection<TagInfo>)this._nsTagListMap.get(uri));
                continue;
            }
            List nsTagList = this._nsTagListMap.get(uri);
            for (int i = 0; i < nsTagList.size(); ++i) {
                TagInfo tagInfo = (TagInfo)nsTagList.get(i);
                list.add(this.createPrefixTagInfo(tagInfo, prefix));
            }
        }
        return list;
    }

    private TagInfo createPrefixTagInfo(TagInfo tagInfo, String prefix) {
        TagInfo newTagInfo = new TagInfo(prefix + ":" + tagInfo.getTagName(), tagInfo.hasBody());
        AttributeInfo[] attrInfos = tagInfo.getAttributeInfo();
        for (int i = 0; i < attrInfos.length; ++i) {
            AttributeInfo newAttrInfo = new AttributeInfo(prefix + ":" + attrInfos[i].getAttributeName(), true, 0, attrInfos[i].isRequired());
            newTagInfo.addAttributeInfo(newAttrInfo);
        }
        String[] children = tagInfo.getChildTagNames();
        for (int i = 0; i < children.length; ++i) {
            newTagInfo.addChildTagName(prefix + ":" + children[i]);
        }
        return newTagInfo;
    }

    private void getNamespace(Map<String, String> map, FuzzyXMLElement element) {
        FuzzyXMLAttribute[] attrs = element.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (!attrs[i].getName().startsWith("xmlns")) continue;
            String name = attrs[i].getName();
            String prefix = "";
            if (name.indexOf(":") >= 0) {
                prefix = name.substring(name.indexOf(":") + 1);
            }
            if (map.get(attrs[i].getValue()) != null) continue;
            map.put(attrs[i].getValue(), prefix);
        }
        if (element.getParentNode() != null) {
            this.getNamespace(map, (FuzzyXMLElement)element.getParentNode());
        }
    }

    @Override
    protected TagInfo getTagInfo(String name) {
        List<TagInfo> tagList = this.getTagList();
        for (int i = 0; i < tagList.size(); ++i) {
            TagInfo info = tagList.get(i);
            if (!info.getTagName().equals(name)) continue;
            return info;
        }
        return new XMLTagInfo(name);
    }

    private class XMLTagInfo
    extends TagInfo {
        public XMLTagInfo(String tagName) {
            super(tagName, true);
        }

        public AttributeInfo getAttributeInfo(String name) {
            AttributeInfo attrInfo = new AttributeInfo(name, true);
            return attrInfo;
        }
    }
}

