/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.xmleditor.editors;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.aonir.fuzzyxml.FuzzyXMLDocType;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.internal.RenderContext;
import jp.aonir.fuzzyxml.internal.WOHTMLRenderDelegate;
import org.apache.xerces.parsers.SAXParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IFileEditorInput;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.editors.HTMLConfiguration;
import tk.eclipse.plugin.htmleditor.editors.HTMLSourceEditor;
import tk.eclipse.plugin.htmleditor.editors.IHTMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.DTDResolver;
import tk.eclipse.plugin.xmleditor.editors.ElementSchemaMapping;
import tk.eclipse.plugin.xmleditor.editors.IDTDResolver;
import tk.eclipse.plugin.xmleditor.editors.SchemaGenerator;
import tk.eclipse.plugin.xmleditor.editors.XMLAssistProcessor;
import tk.eclipse.plugin.xmleditor.editors.XMLConfiguration;
import tk.eclipse.plugin.xmleditor.editors.XMLOutlinePage;
import tk.eclipse.plugin.xmleditor.editors.XMLValidationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEditor
extends HTMLSourceEditor {
    private ArrayList<IDTDResolver> resolvers = new ArrayList();
    public static final String GROUP_XML = "_xml";
    public static final String ACTION_GEN_DTD = "_generate_dtd";
    public static final String ACTION_GEN_XSD = "_generate_xsd";
    public static final String ACTION_ESCAPE_XML = "_escape_xml";
    public static final String ACTION_FORMAT_XML = "_format_xml";
    private String[] _classNameAttributes = null;
    private List<ElementSchemaMapping> _schemaMappings = null;
    private Pattern patternDoctypePublic = Pattern.compile("<!DOCTYPE[\\s\r\n]+?[^<]+?[\\s\r\n]+?PUBLIC[\\s\r\n]*?\"(.+?)\"[\\s\r\n]*?\"(.+?)\".*?>", 32);
    private Pattern patternDoctypeSystem = Pattern.compile("<!DOCTYPE[\\s\r\n]+?[^<]+?[\\s\r\n]+?SYSTEM[\\s\r\n]*?\"(.+?)\".*?>", 32);
    private Pattern patternNsXSD = Pattern.compile("schemaLocation[\\s\r\n]*?=[\\s\r\n]*?\"(.+?)\"", 32);
    private Pattern patternNoNsXSD = Pattern.compile("noNamespaceSchemaLocation[\\s\r\n]*?=[\\s\r\n]*?\"(.+?)\"", 32);

    public XMLEditor() {
        this(new XMLConfiguration(HTMLPlugin.getDefault().getColorProvider()));
    }

    public XMLEditor(XMLConfiguration config) {
        super(config);
        this.setAction(ACTION_GEN_DTD, (IAction)new GenerateDTDAction());
        this.setAction(ACTION_GEN_XSD, (IAction)new GenerateXSDAction());
        this.setAction(ACTION_ESCAPE_XML, (IAction)new EscapeXMLAction());
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.setAction(ACTION_FORMAT_XML, (IAction)new FormatXMLAction());
    }

    @Override
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        this._classNameAttributes = null;
        this._schemaMappings = null;
    }

    public List<ElementSchemaMapping> getSchemaMappings() {
        if (this._schemaMappings == null) {
            this._schemaMappings = ElementSchemaMapping.loadFromPreference();
        }
        return this._schemaMappings;
    }

    public String[] getClassNameAttributes() {
        if (this._classNameAttributes == null) {
            IPreferenceStore store = this.getPreferenceStore();
            this._classNameAttributes = store.getBoolean("__pref_enable_classname") ? StringConverter.asArray((String)store.getString("__pref_classname_attrs")) : new String[0];
        }
        return this._classNameAttributes;
    }

    @Override
    protected IHTMLOutlinePage createOutlinePage() {
        return new XMLOutlinePage(this);
    }

    public void addDTDResolver(IDTDResolver resolver) {
        this.resolvers.add(resolver);
    }

    public IDTDResolver[] getDTDResolvers() {
        return this.resolvers.toArray(new IDTDResolver[this.resolvers.size()]);
    }

    @Override
    protected void doValidate() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        IFileEditorInput input = (IFileEditorInput)XMLEditor.this.getEditorInput();
                        String xml = XMLEditor.this.getDocumentProvider().getDocument((Object)input).get();
                        IFile resource = input.getFile();
                        resource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                        HTMLProjectParams params = new HTMLProjectParams(resource.getProject());
                        if (!params.getValidateXML()) {
                            return;
                        }
                        if (!params.getUseDTD()) {
                            Matcher matcher = XMLEditor.this.patternDoctypePublic.matcher(xml);
                            if (matcher.find()) {
                                xml = XMLEditor.this.removeMatched(xml, matcher.start(), matcher.end());
                            }
                            if ((matcher = XMLEditor.this.patternDoctypeSystem.matcher(xml)).find()) {
                                xml = XMLEditor.this.removeMatched(xml, matcher.start(), matcher.end());
                            }
                        }
                        SAXParser parser = new SAXParser();
                        String dtd = XMLEditor.this.getDTD(xml, false);
                        String[] xsd = XMLEditor.this.getXSD(xml, false);
                        if (dtd == null && xsd == null || !params.getUseDTD()) {
                            parser.setFeature("http://xml.org/sax/features/validation", false);
                        } else {
                            parser.setFeature("http://xml.org/sax/features/validation", true);
                            parser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
                        }
                        if (xsd != null && params.getUseDTD()) {
                            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                            parser.setFeature("http://xml.org/sax/features/namespaces", true);
                        }
                        parser.setFeature("http://xml.org/sax/features/use-entity-resolver2", true);
                        parser.setEntityResolver((EntityResolver)new DTDResolver(XMLEditor.this.getDTDResolvers(), input.getFile().getLocation().makeAbsolute().toFile().getParentFile()));
                        parser.setErrorHandler((ErrorHandler)new XMLValidationHandler((IResource)resource));
                        parser.parse(new InputSource(new StringReader(xml)));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    private String removeMatched(String source, int start, int end) {
        StringBuffer sb = new StringBuffer();
        sb.append(source.substring(0, start));
        for (int i = start; i < end + 1; ++i) {
            char c = source.charAt(i);
            if (c == '\r' || c == '\n') {
                sb.append(c);
                continue;
            }
            sb.append(" ");
        }
        sb.append(source.substring(end + 1, source.length()));
        return sb.toString();
    }

    public String getDTD(String xml, boolean useElementMapping) {
        String firstTag;
        Matcher matcher = this.patternDoctypePublic.matcher(xml);
        if (matcher.find()) {
            return matcher.group(2);
        }
        matcher = this.patternDoctypeSystem.matcher(xml);
        if (matcher.find()) {
            return matcher.group(1);
        }
        if (useElementMapping && (firstTag = XMLEditor.getFirstTag(xml)) != null) {
            List<ElementSchemaMapping> schemaMappings = this.getSchemaMappings();
            for (int i = 0; i < schemaMappings.size(); ++i) {
                ElementSchemaMapping mapping = schemaMappings.get(i);
                if (!mapping.getRootElement().equals(firstTag) || !mapping.getFilePath().endsWith(".dtd")) continue;
                return "file:" + mapping.getFilePath();
            }
        }
        return null;
    }

    public String[] getXSD(String xml, boolean useElementMapping) {
        String firstTag;
        Matcher matcher = this.patternNsXSD.matcher(xml);
        if (matcher.find()) {
            String matched = matcher.group(1).trim();
            matched.replaceAll("\r\n", "\n");
            matched.replaceAll("\r", "\n");
            String[] xsd = matched.split("\n| |\t");
            for (int i = 0; i < xsd.length; ++i) {
                xsd[i] = xsd[i].trim();
            }
            return xsd;
        }
        matcher = this.patternNoNsXSD.matcher(xml);
        if (matcher.find()) {
            return new String[]{matcher.group(3).trim()};
        }
        if (useElementMapping && (firstTag = XMLEditor.getFirstTag(xml)) != null) {
            List<ElementSchemaMapping> schemaMappings = this.getSchemaMappings();
            for (int i = 0; i < schemaMappings.size(); ++i) {
                ElementSchemaMapping mapping = schemaMappings.get(i);
                if (!mapping.getRootElement().equals(firstTag) || !mapping.getFilePath().endsWith(".xsd")) continue;
                return new String[]{"file:" + mapping.getFilePath()};
            }
        }
        return null;
    }

    private static String getFirstTag(String xml) {
        FuzzyXMLDocument doc = new FuzzyXMLParser(false).parse(xml);
        FuzzyXMLNode[] nodes = doc.getDocumentElement().getChildren();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FuzzyXMLElement)) continue;
            return ((FuzzyXMLElement)nodes[i]).getName();
        }
        return null;
    }

    @Override
    protected void updateAssist() {
        try {
            String[] xsd;
            DTDResolver resolver;
            InputStream in;
            XMLConfiguration config = (XMLConfiguration)this.getSourceViewerConfiguration();
            config.getClassNameHyperlinkProvider().setEditor(this);
            if (!this.isFileEditorInput()) {
                return;
            }
            super.updateAssist();
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            HTMLProjectParams params = new HTMLProjectParams(input.getFile().getProject());
            if (!params.getUseDTD()) {
                return;
            }
            String xml = this.getDocumentProvider().getDocument((Object)input).get();
            String dtd = this.getDTD(xml, true);
            if (dtd != null && (in = (resolver = new DTDResolver(this.getDTDResolvers(), input.getFile().getLocation().makeAbsolute().toFile().getParentFile())).getInputStream(dtd)) != null) {
                InputStreamReader reader = new InputStreamReader(in);
                XMLAssistProcessor assistProcessor = (XMLAssistProcessor)((HTMLConfiguration)this.getSourceViewerConfiguration()).getAssistProcessor();
                assistProcessor.updateDTDInfo(reader);
                ((Reader)reader).close();
            }
            if ((xsd = this.getXSD(xml, true)) != null) {
                DTDResolver resolver2 = new DTDResolver(this.getDTDResolvers(), input.getFile().getLocation().makeAbsolute().toFile().getParentFile());
                for (int i = 0; i < xsd.length; ++i) {
                    InputStream in2 = resolver2.getInputStream(xsd[i]);
                    if (in2 == null) continue;
                    InputStreamReader reader = new InputStreamReader(in2);
                    XMLAssistProcessor assistProcessor = (XMLAssistProcessor)((HTMLConfiguration)this.getSourceViewerConfiguration()).getAssistProcessor();
                    assistProcessor.updateXSDInfo(xsd[i], reader);
                    ((Reader)reader).close();
                }
            }
        }
        catch (Exception ex) {
            HTMLPlugin.logException(ex);
        }
    }

    @Override
    protected void addContextMenuActions(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("_html"));
        this.addAction(menu, "_html", ACTION_ESCAPE_XML);
        this.addAction(menu, "_html", "_comment");
        this.addAction(menu, "_html", ACTION_FORMAT_XML);
        menu.add((IContributionItem)new Separator(GROUP_XML));
        this.addAction(menu, GROUP_XML, ACTION_GEN_DTD);
        this.addAction(menu, GROUP_XML, ACTION_GEN_XSD);
    }

    @Override
    protected void updateSelectionDependentActions() {
        super.updateSelectionDependentActions();
        ITextSelection sel = (ITextSelection)this.getSelectionProvider().getSelection();
        if (sel.getText().equals("")) {
            this.getAction(ACTION_ESCAPE_XML).setEnabled(false);
        } else {
            this.getAction(ACTION_ESCAPE_XML).setEnabled(true);
        }
    }

    private class FormatXMLAction
    extends Action {
        public FormatXMLAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.FormatXML"));
            this.setActionDefinitionId("tk.eclipse.plugin.xmleditor.format");
        }

        public void run() {
            try {
                IDocument xmlDocument = XMLEditor.this.getDocumentProvider().getDocument((Object)XMLEditor.this.getEditorInput());
                String xmlString = xmlDocument.get();
                FuzzyXMLDocument htmlModel = new FuzzyXMLParser(false, false).parse(xmlString);
                FuzzyXMLElement documentElement = htmlModel.getDocumentElement();
                IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
                RenderContext renderContext = new RenderContext(true);
                renderContext.setShowNewlines(true);
                renderContext.setIndentSize(prefs.getInt("IndentSize"));
                renderContext.setIndentTabs(prefs.getBoolean("IndentTabs"));
                renderContext.setTrim(true);
                renderContext.setLowercaseAttributes(prefs.getBoolean("LowercaseAttributes"));
                renderContext.setLowercaseTags(prefs.getBoolean("LowercaseTags"));
                renderContext.setSpacesAroundEquals(prefs.getBoolean("SpacesAroundEquals"));
                renderContext.setSpaceInEmptyTags(true);
                renderContext.setAddMissingQuotes(true);
                renderContext.setDelegate(new WOHTMLRenderDelegate(prefs.getBoolean("StickyWOTags")));
                StringBuffer xmlBuffer = new StringBuffer();
                FuzzyXMLDocType docType = htmlModel.getDocumentType();
                if (docType != null) {
                    docType.toXMLString(renderContext, xmlBuffer);
                }
                for (FuzzyXMLNode node : documentElement.getChildren()) {
                    node.toXMLString(renderContext, xmlBuffer);
                }
                xmlDocument.set(xmlBuffer.toString().trim());
            }
            catch (Exception ex) {
                HTMLPlugin.openAlertDialog(ex.toString());
            }
        }
    }

    private class GenerateXSDAction
    extends Action {
        public GenerateXSDAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.GenerateXSD"), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_xsd"));
        }

        public void run() {
            FileDialog dialog = new FileDialog(XMLEditor.this.getViewer().getTextWidget().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.xsd"});
            String file = dialog.open();
            if (file != null) {
                try {
                    SchemaGenerator.generateXSDFromXML(XMLEditor.this.getFile(), new File(file));
                }
                catch (Exception ex) {
                    HTMLPlugin.openAlertDialog(ex.toString());
                }
            }
        }
    }

    private class GenerateDTDAction
    extends Action {
        public GenerateDTDAction() {
            super(HTMLPlugin.getResourceString("XMLEditor.GenerateDTD"), HTMLPlugin.getDefault().getImageRegistry().getDescriptor("_icon_dtd"));
        }

        public void run() {
            FileDialog dialog = new FileDialog(XMLEditor.this.getViewer().getTextWidget().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.dtd"});
            String file = dialog.open();
            if (file != null) {
                try {
                    SchemaGenerator.generateDTDFromXML(XMLEditor.this.getFile(), new File(file));
                }
                catch (Exception ex) {
                    HTMLPlugin.openAlertDialog(ex.toString());
                }
            }
        }
    }

    private class EscapeXMLAction
    extends Action {
        public EscapeXMLAction() {
            super(HTMLPlugin.getResourceString("HTMLEditor.EscapeAction"));
            this.setEnabled(false);
            this.setAccelerator(262236);
        }

        public void run() {
            ITextSelection sel = (ITextSelection)XMLEditor.this.getSelectionProvider().getSelection();
            IDocument doc = XMLEditor.this.getDocumentProvider().getDocument((Object)XMLEditor.this.getEditorInput());
            try {
                doc.replace(sel.getOffset(), sel.getLength(), HTMLUtil.escapeXML(sel.getText()));
            }
            catch (BadLocationException e) {
                HTMLPlugin.logException(e);
            }
        }
    }
}

