/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.actions;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Region;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.SimpleWodBinding;
import org.objectstyle.wolips.bindings.wod.SimpleWodElement;
import org.objectstyle.wolips.componenteditor.ComponenteditorPlugin;
import org.objectstyle.wolips.componenteditor.actions.AbstractTemplateAction;
import org.objectstyle.wolips.componenteditor.actions.InsertComponentSpecification;
import org.objectstyle.wolips.templateeditor.TemplateEditor;
import org.objectstyle.wolips.wodclipse.editor.WodEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InsertHtmlAndWodAction
extends AbstractTemplateAction {
    protected InsertComponentSpecification _componentSpecification;

    public void setComponentSpecification(InsertComponentSpecification componentSpecification) {
        this._componentSpecification = componentSpecification;
    }

    protected abstract List<Binding> getRequiredBindings(String var1);

    protected abstract InsertComponentSpecification getComponentSpecification();

    protected String getIndentText(IDocument doc, int offset) throws BadLocationException {
        IRegion indentRegion = this.getIndentRegion(doc, offset);
        String indentText = doc.get(indentRegion.getOffset(), indentRegion.getLength());
        return indentText;
    }

    protected IRegion getIndentRegion(IDocument doc, int offset) throws BadLocationException {
        IRegion lineRegion = doc.getLineInformationOfOffset(offset);
        int lineStartOffset = lineRegion.getOffset();
        int lineLength = lineRegion.getLength();
        int lineEndOffset = lineStartOffset + lineLength;
        int indentOffset = -1;
        for (int i = lineStartOffset; indentOffset == -1 && i < lineEndOffset; ++i) {
            char ch = doc.getChar(i);
            if (Character.isWhitespace(ch)) continue;
            indentOffset = i;
        }
        Region indentRegion = indentOffset == -1 ? new Region(lineStartOffset, 0) : new Region(lineStartOffset, indentOffset - lineStartOffset);
        return indentRegion;
    }

    protected boolean isLineEmpty(IDocument doc, int offset) throws BadLocationException {
        IRegion lineRegion = doc.getLineInformationOfOffset(offset);
        int lineStartOffset = lineRegion.getOffset();
        int lineLength = lineRegion.getLength();
        int lineEndOffset = lineStartOffset + lineLength;
        boolean isLineEmpty = true;
        for (int i = lineStartOffset; isLineEmpty && i < lineEndOffset; ++i) {
            char ch = doc.getChar(i);
            if (Character.isWhitespace(ch)) continue;
            isLineEmpty = false;
        }
        return isLineEmpty;
    }

    public void run(IAction action) {
        this.insert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert() {
        TemplateEditor te = this.getTemplateEditor();
        WodEditor we = this.getWodEditor();
        InsertComponentSpecification ics = this.getComponentSpecification();
        System.out.println("InsertHtmlAndWodAction.insert: " + te + ", " + we + ", " + ics);
        if (te != null && we != null && ics != null) {
            SimpleWodElement htmlElement;
            SimpleWodElement wodElement = new SimpleWodElement(ics.getComponentInstanceName(), ics.getComponentName());
            List<Binding> bindings = ics.getRequiredBindings();
            if (bindings != null) {
                for (Binding binding : bindings) {
                    wodElement.addBinding((IWodBinding)new SimpleWodBinding(null, binding.getName(), "", true));
                }
            }
            if (ics.getComponentName() == null || ics.getComponentName().length() == 0) {
                wodElement.setTagName(ics.getTagName());
            }
            if (ics.isInline()) {
                htmlElement = wodElement;
            } else {
                htmlElement = new SimpleWodElement("", "");
                htmlElement.setTagName(ics.getTagName());
            }
            Map<String, String> htmlAttributes = ics.getHtmlAttributes();
            if (htmlAttributes != null) {
                for (Map.Entry<String, String> htmlAttribute : htmlAttributes.entrySet()) {
                    htmlElement.addBinding((IWodBinding)new SimpleWodBinding(null, htmlAttribute.getKey(), htmlAttribute.getValue(), true));
                }
            }
            IDocument teDoc = te.getHtmlEditDocument();
            IDocument weDoc = we.getWodEditDocument();
            ITextSelection teDocTSel = (ITextSelection)te.getSourceEditor().getSelectionProvider().getSelection();
            try {
                ITextViewerExtension teExt = (ITextViewerExtension)te.getSourceEditor().getViewer();
                teExt.getRewriteTarget().beginCompoundChange();
                try {
                    int selectionStartOffset = teDocTSel.getOffset();
                    int selectionEndOffset = teDocTSel.getOffset() + teDocTSel.getLength();
                    if (ics.isComponentContent()) {
                        boolean selectionStartedInIndent;
                        int selectionStartLine = teDocTSel.getStartLine();
                        int selectionEndLine = teDocTSel.getEndLine();
                        StringWriter startTagWriter = new StringWriter();
                        htmlElement.writeInlineFormat((Writer)startTagWriter, "", true, true, false, false, "$", "");
                        String startTag = startTagWriter.toString();
                        StringWriter endTagWriter = new StringWriter();
                        htmlElement.writeInlineFormat((Writer)endTagWriter, "", true, false, false, true, "$", "");
                        String endTag = endTagWriter.toString();
                        String indentText = this.getIndentText(teDoc, selectionStartOffset);
                        IRegion startLineRegion = teDoc.getLineInformationOfOffset(selectionStartOffset);
                        IRegion endLineRegion = teDoc.getLineInformationOfOffset(selectionEndOffset);
                        int selectionLineStartOffset = selectionStartOffset - startLineRegion.getOffset();
                        boolean bl = selectionStartedInIndent = indentText.length() >= selectionLineStartOffset;
                        if (selectionStartLine == selectionEndLine) {
                            if (selectionEndOffset == endLineRegion.getOffset() && selectionEndOffset > 0) {
                                teDoc.replace(selectionEndOffset - 1, 0, endTag);
                            } else {
                                teDoc.replace(selectionEndOffset, 0, endTag);
                            }
                            if (selectionStartedInIndent) {
                                if (indentText.length() == 0) {
                                    int offset = Math.max(startLineRegion.getOffset() - 1, 0);
                                    teDoc.replace(offset, 0, startTag);
                                } else {
                                    teDoc.replace(startLineRegion.getOffset() + indentText.length(), 0, startTag);
                                }
                            } else {
                                teDoc.replace(selectionStartOffset, 0, startTag);
                            }
                        } else {
                            String startText;
                            int indentStartOffset;
                            int indentEndOffset;
                            String endText;
                            String lastLineIndentText = this.getIndentText(teDoc, selectionEndOffset);
                            int selectionLineEndOffset = selectionEndOffset - endLineRegion.getOffset();
                            if (lastLineIndentText.length() >= selectionLineEndOffset) {
                                endText = indentText + endTag + "\n";
                                teDoc.replace(endLineRegion.getOffset(), 0, endText);
                                indentEndOffset = 1;
                            } else {
                                endText = "\n" + indentText + endTag + "\n" + indentText;
                                teDoc.replace(selectionEndOffset, 0, endText);
                                indentEndOffset = 2;
                            }
                            if (selectionStartedInIndent) {
                                indentStartOffset = 1;
                                startText = startTag + "\n" + indentText;
                                teDoc.replace(startLineRegion.getOffset() + indentText.length(), 0, startText);
                            } else {
                                indentStartOffset = 2;
                                startText = "\n" + indentText + startTag + "\n" + indentText;
                                teDoc.replace(selectionStartOffset, 0, startText);
                            }
                            for (int line = selectionStartLine + indentStartOffset; line <= selectionEndLine + indentEndOffset; ++line) {
                                int lineOffset = teDoc.getLineOffset(line);
                                teDoc.replace(lineOffset, 0, "\t");
                            }
                        }
                    } else {
                        StringWriter startTagWriter = new StringWriter();
                        htmlElement.writeInlineFormat((Writer)startTagWriter, null, true, true, false, true, "$", "");
                        String tag = startTagWriter.toString();
                        teDoc.replace(selectionStartOffset, 0, tag);
                    }
                }
                finally {
                    teExt.getRewriteTarget().endCompoundChange();
                }
                if (!ics.isInline()) {
                    int firstBindingValueOffset = -1;
                    int offset = weDoc.getLength();
                    StringWriter wodElementWriter = new StringWriter();
                    if (offset > 0) {
                        wodElementWriter.write("\n");
                    }
                    wodElement.writeWodFormat((Writer)wodElementWriter, true);
                    wodElementWriter.flush();
                    String wodElementStr = wodElementWriter.toString();
                    weDoc.replace(offset, 0, wodElementStr);
                    if (-1 != firstBindingValueOffset) {
                        we.selectAndReveal(offset + firstBindingValueOffset, 0);
                    } else {
                        we.selectAndReveal(offset, wodElementStr.length());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                ComponenteditorPlugin.getDefault().log(e);
            }
        }
    }
}

