/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.WodProblem;
import org.objectstyle.wolips.wodclipse.core.util.WodModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingsLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private int _column;
    private IWodElement _wodElement;
    private List<WodProblem> _problems;

    public BindingsLabelProvider(int column) {
        this._column = column;
    }

    public void setContext(IWodElement wodElement, List<WodProblem> problems) {
        this._wodElement = wodElement;
        this._problems = problems;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getText(Object element) {
        return this.getColumnText(element, this._column);
    }

    public String getColumnText(Object element, int columnIndex) {
        IWodBinding wodBinding;
        IApiBinding apiBinding = (IApiBinding)element;
        String text = null;
        if (columnIndex == 0) {
            text = apiBinding.getName();
        } else if (columnIndex == 1 && (wodBinding = this._wodElement.getBindingNamed(apiBinding.getName())) != null) {
            text = wodBinding.getValue();
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element) {
        return this.getForeground(element, this._column);
    }

    public Color getForeground(Object element, int columnIndex) {
        Color color = null;
        IApiBinding apiBinding = (IApiBinding)element;
        if (WodModelUtils.hasValidationProblem((IApiBinding)apiBinding, this._problems)) {
            color = Display.getCurrent().getSystemColor(3);
        }
        return color;
    }

    public Font getFont(Object element) {
        return this.getFont(element, this._column);
    }

    public Font getFont(Object element, int columnIndex) {
        Font font = null;
        if (columnIndex == 0 && element instanceof IWodBinding) {
            font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
        }
        return font;
    }
}

