/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.inspector;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.objectstyle.wolips.baseforuiplugins.utils.ListContentProvider;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.componenteditor.inspector.BindingsDragHandler;
import org.objectstyle.wolips.componenteditor.inspector.IWOBrowserDelegate;
import org.objectstyle.wolips.componenteditor.inspector.WOBrowser;
import org.objectstyle.wolips.componenteditor.inspector.WOBrowserColumnLabelProvider;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;

public class WOBrowserColumn
extends Composite
implements ISelectionProvider,
ISelectionChangedListener,
IElementChangedListener {
    private WOBrowser _browser;
    private List<ISelectionChangedListener> _listeners = new LinkedList<ISelectionChangedListener>();
    private IType _type;
    private TableViewer _keysViewer;
    private Font _typeNameFont;
    private BindingsDragHandler _lineDragHandler;
    private IWOBrowserDelegate _delegate;
    private List<Object> _bindingValueKeys;

    public WOBrowserColumn(WOBrowser browser, IType type, Composite parent, int style) throws JavaModelException {
        super(parent, style);
        this.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        this.setLayout((Layout)layout);
        this._browser = browser;
        this._type = type;
        Label typeName = new Label((Composite)this, 0);
        typeName.setBackground(this.getBackground());
        Font originalFont = typeName.getFont();
        FontData[] fontData = originalFont.getFontData();
        this._typeNameFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        typeName.setFont(this._typeNameFont);
        GridData typeNameData = new GridData(768);
        typeNameData.horizontalIndent = 3;
        typeName.setLayoutData((Object)typeNameData);
        typeName.setText(type.getElementName());
        Composite tableContainer = new Composite((Composite)this, 0);
        tableContainer.setBackground(parent.getBackground());
        tableContainer.setLayoutData((Object)new GridData(1808));
        this._keysViewer = new TableViewer(tableContainer, 68100);
        this._keysViewer.getControl().setLayoutData((Object)new GridData(1808));
        this._keysViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this._keysViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this._keysViewer.setLabelProvider((IBaseLabelProvider)new WOBrowserColumnLabelProvider(this._type, (Control)this._keysViewer.getTable()));
        TableColumnLayout keysLayout = new TableColumnLayout();
        tableContainer.setLayout((Layout)keysLayout);
        TableColumn nameColumn = new TableColumn(this._keysViewer.getTable(), 0);
        nameColumn.setText("Column 1");
        keysLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(1, 200));
        TableColumn iconColumn = new TableColumn(this._keysViewer.getTable(), 0);
        iconColumn.setText("Column 2");
        keysLayout.setColumnData((Widget)iconColumn, (ColumnLayoutData)new ColumnWeightData(1, 20));
        this.reload();
        tableContainer.pack();
        this._lineDragHandler = new BindingsDragHandler(this);
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
    }

    public void elementChanged(ElementChangedEvent event) {
        for (IJavaElementDelta delta : event.getDelta().getAffectedChildren()) {
            IJavaProject project;
            IJavaElement element;
            if ((delta.getFlags() & 8) == 0 || (element = delta.getElement()) == null || (project = element.getJavaProject()) == null || !project.equals(this._type.getJavaProject())) continue;
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        WOBrowserColumn.this.reload();
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void reload() throws JavaModelException {
        Map typeKeys = BindingReflectionUtils.getGroupedBindingValueKeys((String)"", (IType)this._type, (TypeCache)WodParserCache.getTypeCache());
        LinkedList<Object> sortedBindingValueKeys = new LinkedList<Object>();
        for (Map.Entry typeKeysEntry : typeKeys.entrySet()) {
            IType groupType;
            if (!this._type.equals(typeKeysEntry.getKey()) && (groupType = (IType)typeKeysEntry.getKey()) != null) {
                sortedBindingValueKeys.add(groupType.getElementName());
            }
            sortedBindingValueKeys.addAll((Collection)typeKeysEntry.getValue());
        }
        this._bindingValueKeys = sortedBindingValueKeys;
        if (this._keysViewer.getContentProvider() != null) {
            this._keysViewer.setInput(this._bindingValueKeys);
        }
    }

    public BindingValueKey getBindingValueKeyStartingWith(String partialKeyPath) {
        BindingValueKey matchingKey = null;
        for (Object keyObj : this._bindingValueKeys) {
            BindingValueKey key;
            if (!(keyObj instanceof BindingValueKey) || !(key = (BindingValueKey)keyObj).getBindingName().startsWith(partialKeyPath)) continue;
            matchingKey = key;
            break;
        }
        return matchingKey;
    }

    public WOBrowser getBrowser() {
        return this._browser;
    }

    public void setDelegate(IWOBrowserDelegate delegate) {
        this._delegate = delegate;
    }

    public IWOBrowserDelegate getDelegate() {
        return this._delegate;
    }

    public void dispose() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
        this._typeNameFont.dispose();
        if (this._lineDragHandler != null) {
            this._lineDragHandler.dispose();
            this._lineDragHandler = null;
        }
        super.dispose();
    }

    public boolean setFocus() {
        return this._keysViewer.getControl().setFocus();
    }

    public IType getType() {
        return this._type;
    }

    public TableViewer getViewer() {
        return this._keysViewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.add(listener);
    }

    public ISelection getSelection() {
        return this._keysViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this._listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this._keysViewer.setSelection(selection, true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        SelectionChangedEvent wrappedEvent = new SelectionChangedEvent((ISelectionProvider)this, event.getSelection());
        for (ISelectionChangedListener listener : this._listeners) {
            listener.selectionChanged(wrappedEvent);
        }
    }

    public String getSelectedKeyPath() {
        BindingValueKey bindingValueKey;
        Object keyPath = this._browser == null ? ((bindingValueKey = this.getSelectedKey()) == null ? null : bindingValueKey.getBindingName()) : this._browser.getSelectedKeyPath();
        return keyPath;
    }

    public BindingValueKey getSelectedKey() {
        Object selectedObject;
        BindingValueKey selectedKey = null;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (selection != null && (selectedObject = selection.getFirstElement()) instanceof BindingValueKey) {
            selectedKey = (BindingValueKey)selectedObject;
        }
        return selectedKey;
    }
}

