/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.componenteditor.part;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dnd.IDragAndDropService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.componenteditor.ComponenteditorPlugin;
import org.objectstyle.wolips.componenteditor.part.ComponentDropTargetAdaptor;
import org.objectstyle.wolips.componenteditor.part.ComponentEditorPart;
import org.objectstyle.wolips.components.input.ComponentEditorInput;
import org.objectstyle.wolips.templateeditor.TemplateEditor;
import org.objectstyle.wolips.templateeditor.TemplateSourceEditor;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.IWOEditor;

public class ComponentEditor
extends ComponentEditorPart
implements IGotoMarker,
ITextEditor,
IWOEditor {
    public static final String ID = "org.objectstyle.wolips.componenteditor.ComponentEditor";
    private boolean _dragAndDropInitialized;

    public WodParserCache getParserCache() throws Exception {
        IEditorPart editorPart = this.getActiveEditor();
        WodParserCache parserCache = null;
        if (editorPart instanceof IWOEditor) {
            parserCache = ((IWOEditor)editorPart).getParserCache();
        }
        return parserCache;
    }

    public Control getWOEditorControl() {
        IEditorPart editorPart = this.getActiveEditor();
        Control editorControl = null;
        if (editorPart instanceof IWOEditor) {
            editorControl = ((IWOEditor)editorPart).getWOEditorControl();
        }
        return editorControl;
    }

    public IWodElement getSelectedElement(boolean resolveWodElement, boolean refreshModel) throws Exception {
        IEditorPart editorPart = this.getActiveEditor();
        IWodElement selectedElement = null;
        if (editorPart instanceof IWOEditor) {
            selectedElement = ((IWOEditor)editorPart).getSelectedElement(resolveWodElement, refreshModel);
        }
        return selectedElement;
    }

    public IWodElement getWodElementAtPoint(Point point, boolean resolveWodElement, boolean refreshModel) throws Exception {
        IEditorPart editorPart = this.getActiveEditor();
        IWodElement wodElement = null;
        if (editorPart instanceof IWOEditor) {
            wodElement = ((IWOEditor)editorPart).getWodElementAtPoint(point, resolveWodElement, refreshModel);
        }
        return wodElement;
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (editorInput instanceof ComponentEditorInput) {
            super.init(site, editorInput);
            return;
        }
        FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
        IFile file = fileEditorInput.getFile();
        String extension = file.getFileExtension();
        ComponentEditorInput input = null;
        if (extension.equals("html")) {
            try {
                input = ComponentEditorInput.createWithDotHtml((IFile)file);
            }
            catch (CoreException e) {
                ComponenteditorPlugin.getDefault().log(e);
            }
        }
        if (extension.equals("wod")) {
            try {
                input = ComponentEditorInput.createWithDotWod((IFile)file);
            }
            catch (CoreException e) {
                ComponenteditorPlugin.getDefault().log(e);
            }
        }
        if (extension.equals("api")) {
            try {
                input = ComponentEditorInput.createWithDotApi((IFile)file);
            }
            catch (CoreException e) {
                ComponenteditorPlugin.getDefault().log(e);
            }
        }
        if (extension.equals("woo")) {
            try {
                input = ComponentEditorInput.createWithDotWoo((IFile)file);
            }
            catch (CoreException e) {
                ComponenteditorPlugin.getDefault().log(e);
            }
        }
        super.init(site, (IEditorInput)input);
    }

    protected void createPages() {
        super.createPages();
        if (!this._dragAndDropInitialized) {
            TemplateEditor templateEditor = this.getTemplateEditor();
            if (templateEditor != null) {
                TemplateSourceEditor templateSourceEditor = templateEditor.getSourceEditor();
                this.initializeDragAndDrop(templateSourceEditor.getViewer());
            }
            this._dragAndDropInitialized = true;
        }
        CTabFolder ctf = (CTabFolder)this.getContainer();
        ctf.setBorderVisible(false);
        if (this.getPageCount() <= 1) {
            ctf.setTabHeight(0);
        }
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
        IDragAndDropService dndService = (IDragAndDropService)this.getSite().getService(IDragAndDropService.class);
        if (dndService != null) {
            StyledText st = viewer.getTextWidget();
            ComponentDropTargetAdaptor dropTarget = new ComponentDropTargetAdaptor(this);
            dndService.addMergedDropTarget((Control)st, 3, new Transfer[]{LocalSelectionTransfer.getInstance()}, (DropTargetListener)dropTarget);
        }
    }

    public IDocumentProvider getDocumentProvider() {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return null;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        return textEditor.getDocumentProvider();
    }

    public void close(boolean save) {
        super.close(save);
    }

    public boolean isEditable() {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return false;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        return textEditor.isEditable();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    public void doSaveAs() {
        super.doSaveAs();
    }

    public void doRevertToSaved() {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        textEditor.doRevertToSaved();
    }

    public void setAction(String actionID, IAction action) {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        textEditor.setAction(actionID, action);
    }

    public IAction getAction(String actionId) {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return null;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        return textEditor.getAction(actionId);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        textEditor.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
    }

    public void removeActionActivationCode(String actionId) {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        textEditor.removeActionActivationCode(actionId);
    }

    public boolean showsHighlightRangeOnly() {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return false;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        return textEditor.showsHighlightRangeOnly();
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        textEditor.showHighlightRangeOnly(showHighlightRangeOnly);
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        textEditor.setHighlightRange(offset, length, moveCursor);
    }

    public IRegion getHighlightRange() {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return null;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        return textEditor.getHighlightRange();
    }

    public void resetHighlightRange() {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        textEditor.resetHighlightRange();
    }

    public ISelectionProvider getSelectionProvider() {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return null;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        return textEditor.getSelectionProvider();
    }

    public void selectAndReveal(int offset, int length) {
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart == null || !(this.getActiveEditor() instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)editorPart;
        textEditor.selectAndReveal(offset, length);
    }

    public String getTitleToolTip() {
        String componentName = null;
        IEditorInput[] editorInputArray = this.componentEditorInput.getInput();
        for (int i = 0; componentName == null && i < editorInputArray.length; ++i) {
            IFile inputFileFromEditor = ResourceUtil.getFile((IEditorInput)editorInputArray[i]);
            if (inputFileFromEditor == null) continue;
            String name = inputFileFromEditor.getName();
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex != -1) {
                name = name.substring(0, dotIndex);
            }
            componentName = name;
        }
        return componentName + " WOComponent";
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void gotoMarker(IMarker marker) {
        IResource resource = marker.getResource();
        if (resource == null) {
            return;
        }
        IEditorInput[] editorInputArray = this.componentEditorInput.getInput();
        for (int i = 0; i < editorInputArray.length; ++i) {
            IPath pathFromResource;
            IPath pathFromInputFile;
            IFile inputFileFromEditor = ResourceUtil.getFile((IEditorInput)editorInputArray[i]);
            if (inputFileFromEditor == null || (pathFromInputFile = inputFileFromEditor.getLocation()) == null || (pathFromResource = resource.getLocation()) == null || !pathFromInputFile.equals((Object)pathFromResource)) continue;
            IEditorPart editorPart = null;
            if (pathFromInputFile.getFileExtension().equals("html")) {
                this.htmlWodTab().setHtmlActive();
                editorPart = this.htmlWodTab().getActiveEmbeddedEditor();
            }
            if (pathFromInputFile.getFileExtension().equals("wod")) {
                this.htmlWodTab().setWodActive();
                editorPart = this.htmlWodTab().getActiveEmbeddedEditor();
            }
            if (editorPart == null) continue;
            IGotoMarker gotoMarker = (IGotoMarker)editorPart.getAdapter(IGotoMarker.class);
            if (gotoMarker == null) {
                return;
            }
            if (this.htmlWodTab().isHtmlActive()) {
                this.switchToHtml();
            }
            if (!this.htmlWodTab().isHtmlActive()) {
                this.switchToWod();
            }
            gotoMarker.gotoMarker(marker);
            return;
        }
    }
}

