/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.objectstyle.wolips.baseforplugins.util.URLUtils;
import org.objectstyle.wolips.eogenerator.core.model.EOGeneratorModel;
import org.objectstyle.wolips.eogenerator.core.model.EOModelReference;
import org.objectstyle.wolips.eogenerator.jdt.EOGeneratorCreator;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.jdt.ProjectFrameworkAdapter;
import org.objectstyle.wolips.wizards.EOGeneratorWizardPage;

public class EOGeneratorWizard
extends Wizard
implements INewWizard {
    private EOGeneratorWizardPage _page;
    private ISelection _selection;

    public EOGeneratorWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this._page = new EOGeneratorWizardPage(this._selection);
        this.addPage((IWizardPage)this._page);
    }

    public boolean performFinish() {
        final String containerName = this._page.getContainerName();
        final String fileName = this._page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    EOGeneratorWizard.this.doFinish(containerName, fileName, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return true;
    }

    protected void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            EOGeneratorModel model = EOGeneratorCreator.createDefaultModel((IProject)container.getProject());
            model.writeToFile(file, monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        monitor.worked(1);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.objectstyle.wolips.eogenerator.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._selection = selection;
    }

    public static EOGeneratorModel createEOGeneratorModel(IContainer parentResource, EOModel targetModel, boolean includeRefModels) {
        EOGeneratorModel eogenModel = EOGeneratorCreator.createDefaultModel((IProject)parentResource.getProject());
        EOModelGroup modelGroup = targetModel.getModelGroup();
        LinkedList<EOModel> exceptModels = new LinkedList<EOModel>();
        exceptModels.add(targetModel);
        List modelReferences = EOGeneratorModel.createModelReferencesForModelGroup((EOModelGroup)modelGroup, exceptModels);
        File modelFolder = URLUtils.cheatAndTurnIntoFile((URL)targetModel.getModelURL());
        if (modelFolder != null) {
            eogenModel.addModel(new EOModelReference((IPath)new Path(modelFolder.getAbsolutePath())));
        }
        if (includeRefModels) {
            eogenModel.setLoadModelGroup(Boolean.FALSE);
            for (EOModelReference modelReference : modelReferences) {
                eogenModel.addRefModel(modelReference);
            }
        }
        try {
            if (eogenModel.getDefaultJavaTemplate() == null && ((ProjectFrameworkAdapter)parentResource.getProject().getAdapter(ProjectFrameworkAdapter.class)).isLinkedToFrameworkNamed("ERExtensions")) {
                eogenModel.setJavaTemplate("_WonderEntity.java");
                eogenModel.setSubclassJavaTemplate("WonderEntity.java");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return eogenModel;
    }
}

