/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards;

import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewLinkPage;
import org.objectstyle.wolips.wizards.Messages;

public class PackageSpecifierWizardPage
extends WizardNewLinkPage {
    static String packageNameText;
    public static final String OPTIONS_STRING;
    public static final String DEFAULT_PACKAGE_STRING;

    public PackageSpecifierWizardPage(String pageName, int type) {
        super(pageName, type);
    }

    public String getPackageName() {
        return packageNameText != null ? packageNameText : "";
    }

    public String getConvertedPath() {
        String convertedPackagePath = "";
        if (this.getPackageName().trim().length() > 0) {
            convertedPackagePath = this.getPackageName().trim().replace(".", File.separator);
        }
        return convertedPackagePath;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(font);
        Group optionGroup = new Group(topLevel, 4);
        GridLayout clientlayout = new GridLayout();
        optionGroup.setLayout((Layout)clientlayout);
        optionGroup.setLayoutData((Object)new GridData(768));
        optionGroup.setText(OPTIONS_STRING);
        optionGroup.setFont(topLevel.getFont());
        Text text = new Text((Composite)optionGroup, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setText(DEFAULT_PACKAGE_STRING);
        packageNameText = DEFAULT_PACKAGE_STRING;
        text.addModifyListener((ModifyListener)new TextFieldModifyListener());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    public void updatePageComplete() {
        this.setPageComplete(false);
        if (packageNameText.endsWith(".") || packageNameText.contains("/")) {
            this.setMessage(null);
            this.setErrorMessage("Invalid package name: " + packageNameText);
            return;
        }
        this.setPageComplete(true);
        this.setMessage(null);
        this.setErrorMessage(null);
    }

    static {
        OPTIONS_STRING = Messages.getString("PackageSpecifierWizardPage.options.text");
        DEFAULT_PACKAGE_STRING = Messages.getString("PackageSpecifierWizardPage.options.defaultPackage");
    }

    class TextFieldModifyListener
    implements ModifyListener {
        TextFieldModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            if (event.getSource() instanceof Text) {
                packageNameText = ((Text)event.getSource()).getText();
                PackageSpecifierWizardPage.this.updatePageComplete();
            }
        }
    }
}

