/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wizards.template;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.objectstyle.wolips.templateengine.ProjectTemplate;
import org.objectstyle.wolips.wizards.NewWOProjectWizard;
import org.objectstyle.wolips.wizards.template.SelectTemplateWizardPage;
import org.objectstyle.wolips.wizards.template.TemplateInputsWizardPage;

public class NewProjectFromTemplateWizard
extends NewWOProjectWizard {
    private SelectTemplateWizardPage _selectTemplatePage;
    private TemplateInputsWizardPage _templateInputsPage;

    public NewProjectFromTemplateWizard() {
    }

    public NewProjectFromTemplateWizard(String projectTemplateName) {
        this.setProjectTemplate(ProjectTemplate.loadProjectTemplateNamed(null, (String)"Project Templates", (String)projectTemplateName));
    }

    protected NewWOProjectWizard.WizardType getWizardType() {
        return NewWOProjectWizard.WizardType.NEWPROJ_TEMPLATE_WIZARD;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public void addPages() {
        ProjectTemplate projectTemplate = this.getProjectTemplate();
        if (projectTemplate == null) {
            this._selectTemplatePage = new SelectTemplateWizardPage();
            this.addPage((IWizardPage)this._selectTemplatePage);
        }
        this._templateInputsPage = new TemplateInputsWizardPage();
        if (projectTemplate != null) {
            this._templateInputsPage.setProjectTemplate(projectTemplate);
        }
        if (projectTemplate == null || projectTemplate.getInputs().size() > 0) {
            this.addPage((IWizardPage)this._templateInputsPage);
        }
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage;
        Object currentPage = page;
        if (currentPage == this._selectTemplatePage) {
            ProjectTemplate projectTemplate = this._selectTemplatePage.getSelectedProjectTemplate();
            this.setProjectTemplate(projectTemplate);
            if (projectTemplate != null && projectTemplate.getInputs().size() == 0) {
                currentPage = this._templateInputsPage;
            }
        }
        if ((nextPage = super.getNextPage(currentPage)) == this._templateInputsPage) {
            this._templateInputsPage.setProjectTemplate(this.getProjectTemplate());
        }
        return nextPage;
    }

    protected void postInstallTemplate(IProject project, IProgressMonitor progressMonitor) throws Exception {
    }
}

