/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.core.sql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseConfig;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.core.sql.IEOSQLGenerator;
import org.objectstyle.wolips.eomodeler.core.sql.IEOSQLGeneratorFactory;
import org.objectstyle.wolips.eomodeler.core.sql.WOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EOFSQLGeneratorFactory
implements IEOSQLGeneratorFactory {
    @Override
    public IEOSQLGenerator sqlGenerator(EOModel model, List<String> entityNames, EODatabaseConfig databaseConfig, ClassLoader eomodelClassLoader, boolean runInEntityModeler) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        WOUtils.setWOSystemProperties();
        String className = "org.objectstyle.wolips.eomodeler.core.sql.EOFSQLGenerator53";
        Class<?> sqlGeneratorClass = Class.forName(className, true, eomodelClassLoader);
        LinkedList<URL> modelURLs = new LinkedList<URL>();
        for (EOModel otherModel : model.getModelGroup().getModels()) {
            if (otherModel == model) continue;
            URL otherModelURL = otherModel.getModelURL();
            modelURLs.add(WOUtils.trimModelURLs(otherModelURL));
        }
        modelURLs.add(WOUtils.trimModelURLs(model.getModelURL()));
        Constructor<?> sqlGeneratorConstructor = sqlGeneratorClass.getConstructor(String.class, List.class, List.class, Map.class, Boolean.TYPE);
        if (databaseConfig == null) {
            throw new IllegalStateException("Database config is not defined");
        }
        Object sqlGeneratorButICantCastItBecauseItCrossesClassLoaders = sqlGeneratorConstructor.newInstance(model.getName(), modelURLs, entityNames, databaseConfig.toMap().getBackingMap(), runInEntityModeler);
        ReflectionSQLGenerator sqlGenerator = new ReflectionSQLGenerator(sqlGeneratorButICantCastItBecauseItCrossesClassLoaders);
        return sqlGenerator;
    }

    protected static class ReflectionSQLGenerator
    implements IEOSQLGenerator {
        private Object _eofSQLGenerator;

        public ReflectionSQLGenerator(Object eofSQLGenerator) {
            this._eofSQLGenerator = eofSQLGenerator;
        }

        public void executeSQL(String sql) throws SQLException {
            try {
                this._eofSQLGenerator.getClass().getMethod("executeSQL", String.class).invoke(this._eofSQLGenerator, sql);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to generate SQL.", e);
            }
        }

        public String generateSchemaCreationScript(Map flagsMap) {
            try {
                return (String)this._eofSQLGenerator.getClass().getMethod("generateSchemaCreationScript", Map.class).invoke(this._eofSQLGenerator, flagsMap);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to generate SQL.", e);
            }
        }
    }
}

