/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.attributes;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.utils.TablePropertyLabelProvider;

public class EOAttributesLabelProvider
extends TablePropertyLabelProvider
implements ITableColorProvider,
ITableFontProvider,
ILabelProvider {
    private TableViewer _tableViewer;
    private Font _inheritedFont;
    private Font _flattenedFont;
    private Font _flattenedInheritedFont;
    private String _blankText;

    public EOAttributesLabelProvider(String[] properties) {
        super(properties);
    }

    public EOAttributesLabelProvider(String tableName) {
        this(null, tableName, null);
    }

    public EOAttributesLabelProvider(String tableName, String blankText) {
        this(null, tableName, blankText);
    }

    public EOAttributesLabelProvider(TableViewer tableViewer, String tableName) {
        this(tableViewer, tableName, null);
    }

    public EOAttributesLabelProvider(TableViewer tableViewer, String tableName, String blankText) {
        super(tableName);
        this._tableViewer = tableViewer;
        this._blankText = blankText;
    }

    public void setBlankText(String blankText) {
        this._blankText = blankText;
    }

    public Image getColumnImage(Object _element, String _property) {
        EOAttribute attribute = (EOAttribute)_element;
        Image image = null;
        if ("primaryKey".equals(_property)) {
            image = this.yesNoImage(attribute.isPrimaryKey(), Activator.getDefault().getImageRegistry().get("primaryKey"), null, null);
        } else if ("usedForLocking".equals(_property)) {
            image = this.yesNoImage(attribute.isUsedForLocking(), Activator.getDefault().getImageRegistry().get("locking"), null, null);
        } else if ("classProperty".equals(_property)) {
            image = this.yesNoImage(attribute.isClassProperty(), Activator.getDefault().getImageRegistry().get("classProperty"), null, null);
        } else if ("allowsNull".equals(_property)) {
            image = this.yesNoImage(attribute.isAllowsNull(), Activator.getDefault().getImageRegistry().get("allowNull"), null, null);
        }
        return image;
    }

    protected String yesNoText(EOAttribute _attribute, Boolean _bool) {
        return this.yesNoText(_bool, !_attribute.getEntity().isPrototype());
    }

    public String getColumnText(Object _element, String _property) {
        EOAttribute attribute = (EOAttribute)_element;
        String text = null;
        if (!("primaryKey".equals(_property) || "usedForLocking".equals(_property) || "classProperty".equals(_property) || "allowsNull".equals(_property))) {
            if ("prototype".equals(_property)) {
                EOAttribute prototype = attribute.getPrototype();
                if (prototype != null) {
                    text = prototype.getName();
                }
            } else {
                text = super.getColumnText(_element, _property);
                if (text == null) {
                    text = this._blankText;
                }
            }
        }
        return text;
    }

    public Font getFont(Object _element, int _columnIndex) {
        Font font = null;
        if (this._tableViewer != null) {
            EOAttribute attribute = (EOAttribute)_element;
            boolean inherited = attribute.isInherited();
            boolean flattened = attribute.isFlattened();
            if (flattened && inherited) {
                if (this._flattenedInheritedFont == null) {
                    Font originalFont = this._tableViewer.getTable().getFont();
                    FontData[] fontData = this._tableViewer.getTable().getFont().getFontData();
                    this._flattenedInheritedFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 3);
                }
                font = this._flattenedInheritedFont;
            } else if (flattened) {
                if (this._flattenedFont == null) {
                    Font originalFont = this._tableViewer.getTable().getFont();
                    FontData[] fontData = this._tableViewer.getTable().getFont().getFontData();
                    this._flattenedFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
                }
                font = this._flattenedFont;
            } else if (inherited) {
                if (this._inheritedFont == null) {
                    Font originalFont = this._tableViewer.getTable().getFont();
                    FontData[] fontData = this._tableViewer.getTable().getFont().getFontData();
                    this._inheritedFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 2);
                }
                font = this._inheritedFont;
            }
        }
        return font;
    }

    public Color getBackground(Object _element, int _columnIndex) {
        return null;
    }

    public Color getForeground(Object _element, int _columnIndex) {
        Color color = null;
        EOAttribute attribute = (EOAttribute)_element;
        if (attribute != null) {
            boolean isClassProperty;
            String property = this.getColumnProperty(_columnIndex);
            boolean isAttributePrototyped = attribute.isPrototyped(property);
            boolean bl = isClassProperty = attribute.isClassProperty() != null && attribute.isClassProperty() != false;
            if (isAttributePrototyped) {
                color = Display.getCurrent().getSystemColor(4);
            } else if (!isClassProperty) {
                color = Display.getCurrent().getSystemColor(16);
            }
        }
        return color;
    }

    public void dispose() {
        if (this._inheritedFont != null) {
            this._inheritedFont.dispose();
        }
        if (this._flattenedFont != null) {
            this._flattenedFont.dispose();
        }
        if (this._flattenedInheritedFont != null) {
            this._flattenedInheritedFont.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, "name");
    }

    public String getText(Object element) {
        return this.getColumnText(element, "name");
    }
}

