/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.entity;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorPart;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.editors.IEntityEditor;
import org.objectstyle.wolips.eomodeler.editors.attributes.EOAttributesTableViewer;
import org.objectstyle.wolips.eomodeler.editors.relationships.EORelationshipsTableViewer;

public class EOEntityEditor
extends EditorPart
implements IEntityEditor,
ISelectionProvider {
    private EOAttributesTableViewer myAttributesTableViewer;
    private EORelationshipsTableViewer myRelationshipsTableViewer;
    private EOEntity myEntity;
    private ListenerList myListenerList = new ListenerList();

    public EOModel getModel() {
        return this.myEntity == null ? null : this.myEntity.getModel();
    }

    public void setEntity(EOEntity _entity) {
        this.myEntity = _entity;
        this.updateTableViewers();
    }

    public EOEntity getEntity() {
        return this.myEntity;
    }

    public void doSave(IProgressMonitor _monitor) {
    }

    public void doSaveAs() {
    }

    public EOAttributesTableViewer getAttributesTableViewer() {
        return this.myAttributesTableViewer;
    }

    public EORelationshipsTableViewer getRelationshipsTableViewer() {
        return this.myRelationshipsTableViewer;
    }

    public void init(IEditorSite _site, IEditorInput _input) {
        this.setSite((IWorkbenchPartSite)_site);
        this.setInput(_input);
        this.setEntity(null);
    }

    public boolean isDirty() {
        return this.myEntity != null && this.myEntity.getModel().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite _parent) {
        SashForm sashForm = new SashForm(_parent, 512);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.myAttributesTableViewer = new EOAttributesTableViewer((Composite)sashForm, 0);
        this.myAttributesTableViewer.setLayoutData(new GridData(1808));
        this.myAttributesTableViewer.addSelectionChangedListener(new AttributeSelectionChangedListener());
        this.myRelationshipsTableViewer = new EORelationshipsTableViewer((Composite)sashForm, 0);
        this.myRelationshipsTableViewer.setLayoutData(new GridData(1808));
        this.myRelationshipsTableViewer.addSelectionChangedListener(new RelationshipSelectionChangedListener());
        sashForm.setWeights(new int[]{2, 1});
        this.updateTableViewers();
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.myRelationshipsTableViewer != null) {
            this.myRelationshipsTableViewer.dispose();
        }
        if (this.myAttributesTableViewer != null) {
            this.myAttributesTableViewer.dispose();
        }
        super.dispose();
    }

    protected void updateTableViewers() {
        if (this.myRelationshipsTableViewer != null) {
            this.myRelationshipsTableViewer.setEntity(this.myEntity);
        }
        if (this.myAttributesTableViewer != null) {
            this.myAttributesTableViewer.setEntity(this.myEntity);
        }
    }

    public void fireSelectionChanged(ISelection _selection) {
        Object[] listeners = this.myListenerList.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, _selection));
        }
    }

    public void setSelection(ISelection _selection) {
        this.myAttributesTableViewer.setSelection(_selection);
        this.myRelationshipsTableViewer.setSelection(_selection);
    }

    public ISelection getSelection() {
        ISelection selection = this.myAttributesTableViewer.getSelection();
        if (selection.isEmpty()) {
            selection = this.myRelationshipsTableViewer.getSelection();
        }
        return selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener _listener) {
        this.myListenerList.add((Object)_listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener _listener) {
        this.myListenerList.remove((Object)_listener);
    }

    protected class RelationshipSelectionChangedListener
    implements ISelectionChangedListener {
        protected RelationshipSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent _event) {
            if (!_event.getSelection().isEmpty()) {
                EOEntityEditor.this.getAttributesTableViewer().setSelection(null);
                EOEntityEditor.this.fireSelectionChanged(_event.getSelection());
            }
        }
    }

    protected class AttributeSelectionChangedListener
    implements ISelectionChangedListener {
        protected AttributeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent _event) {
            if (!_event.getSelection().isEmpty()) {
                EOEntityEditor.this.getRelationshipsTableViewer().setSelection(null);
                EOEntityEditor.this.fireSelectionChanged(_event.getSelection());
            }
        }
    }
}

