/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.fetchspec;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.eomodeler.Messages;
import org.objectstyle.wolips.eomodeler.core.model.AbstractEOAttributePath;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.core.model.IEOAttribute;
import org.objectstyle.wolips.eomodeler.outline.EOEntityTreeViewUpdater;
import org.objectstyle.wolips.eomodeler.outline.EOModelOutlineContentProvider;
import org.objectstyle.wolips.eomodeler.utils.FormUtils;
import org.objectstyle.wolips.eomodeler.utils.UglyFocusHackWorkaroundListener;

public class EOFetchSpecQualifierEditorSection
extends AbstractPropertySection
implements ISelectionChangedListener {
    private EOFetchSpecification _fetchSpecification;
    private Text _nameText;
    private Text _qualifierText;
    private TreeViewer _modelTreeViewer;
    private EOEntityTreeViewUpdater _entityTreeViewUpdater;
    private DataBindingContext _bindingContext;
    private CLabel _errorLabel;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite form = this.getWidgetFactory().createFlatFormComposite(parent);
        FormLayout formLayout = new FormLayout();
        form.setLayout((Layout)formLayout);
        Composite topForm = FormUtils.createForm(this.getWidgetFactory(), form);
        this.getWidgetFactory().createCLabel(topForm, Messages.getString("EOFetchSpecification.name"), 0);
        this._nameText = new Text(topForm, 2048);
        GridData nameLayoutData = new GridData(768);
        this._nameText.setLayoutData((Object)nameLayoutData);
        UglyFocusHackWorkaroundListener.addListener(this._nameText);
        this._modelTreeViewer = new TreeViewer(topForm);
        GridData modelTreeLayoutData = new GridData(1808);
        modelTreeLayoutData.horizontalSpan = 2;
        modelTreeLayoutData.heightHint = 200;
        this._modelTreeViewer.getTree().setLayoutData((Object)modelTreeLayoutData);
        this._entityTreeViewUpdater = new EOEntityTreeViewUpdater(this._modelTreeViewer, new EOModelOutlineContentProvider(true, true, true, false, false, false, false, true));
        this._modelTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this._qualifierText = this.getWidgetFactory().createText(topForm, "", 578);
        this._qualifierText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        GridData qualifierLayoutData = new GridData(1808);
        qualifierLayoutData.horizontalSpan = 2;
        qualifierLayoutData.widthHint = 150;
        qualifierLayoutData.heightHint = 100;
        this._qualifierText.setLayoutData((Object)qualifierLayoutData);
        this._errorLabel = this.getWidgetFactory().createCLabel(topForm, "", 0);
        this._errorLabel.setForeground(topForm.getDisplay().getSystemColor(3));
        GridData qualifierErrorData = new GridData(768);
        qualifierErrorData.horizontalSpan = 2;
        this._errorLabel.setLayoutData((Object)qualifierErrorData);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (ComparisonUtils.equals((Object)selection, (Object)this.getSelection())) {
            return;
        }
        super.setInput(part, selection);
        this.disposeBindings();
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        this._fetchSpecification = (EOFetchSpecification)selectedObject;
        if (this._fetchSpecification != null) {
            this._bindingContext = new DataBindingContext();
            this._bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int)24), BeansObservables.observeValue((Object)this._fetchSpecification, (String)"name"), null, null);
            Binding qualifierBinding = this._bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this._qualifierText, (int)24), BeansObservables.observeValue((Object)this._fetchSpecification, (String)"qualifierString"), null, null);
            this._bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this._errorLabel), qualifierBinding.getValidationStatus(), null, null);
            this._entityTreeViewUpdater.setEntity(this._fetchSpecification.getEntity());
        }
    }

    protected void disposeBindings() {
        if (this._bindingContext != null) {
            this._bindingContext.dispose();
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeBindings();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object selectedObject = selection.getFirstElement();
        String keyPath = selectedObject instanceof IEOAttribute ? ((IEOAttribute)selectedObject).getName() : (selectedObject instanceof AbstractEOAttributePath ? ((AbstractEOAttributePath)selectedObject).toKeyPath() : null);
        if (keyPath != null) {
            String qualifierString = this._qualifierText.getText();
            if (qualifierString != null) {
                char ch;
                int endPosition;
                int caretPosition;
                int startPosition = caretPosition = this._qualifierText.getCaretPosition();
                for (startPosition = caretPosition - 1; startPosition >= 0; --startPosition) {
                    char ch2 = qualifierString.charAt(startPosition);
                    if (Character.isLetterOrDigit(ch2) || ch2 == '.') continue;
                    ++startPosition;
                    break;
                }
                for (endPosition = caretPosition; endPosition < qualifierString.length() && (Character.isLetterOrDigit(ch = qualifierString.charAt(endPosition)) || ch == '.'); ++endPosition) {
                }
                this._qualifierText.setSelection(startPosition, endPosition);
                if (startPosition > 0 && qualifierString.charAt(startPosition - 1) != ' ' && qualifierString.charAt(startPosition - 1) != '(') {
                    keyPath = " " + keyPath;
                }
            }
            this._qualifierText.insert(keyPath);
            this._qualifierText.setFocus();
        }
    }
}

