/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.qualifier;

import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.objectstyle.wolips.eomodeler.core.model.EOQualifierFactory;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOAggregateQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOKeyComparisonQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOKeyValueQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOQualifier;
import org.objectstyle.wolips.eomodeler.core.model.qualifier.EOTruePredicate;
import org.objectstyle.wolips.eomodeler.editors.qualifier.AbstractQualifierTypeEditor;

public class KeyValueQualifierTypeEditor
extends AbstractQualifierTypeEditor {
    private String _key;
    private ComboViewer _operatorCombo;
    private Text _valueText;

    public KeyValueQualifierTypeEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        this.setLayout((Layout)layout);
        this._operatorCombo = new ComboViewer((Composite)this, 8);
        this._operatorCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String text = element == null ? "" : ((EOQualifier.Comparison)element).getDisplayName();
                return text;
            }
        });
        this._operatorCombo.add((Object)new EOQualifier.Comparison("="));
        this._operatorCombo.add((Object)new EOQualifier.Comparison("<>", "!="));
        this._operatorCombo.add((Object)new EOQualifier.Comparison("<"));
        this._operatorCombo.add((Object)new EOQualifier.Comparison("<="));
        this._operatorCombo.add((Object)new EOQualifier.Comparison(">"));
        this._operatorCombo.add((Object)new EOQualifier.Comparison(">="));
        this._operatorCombo.add((Object)new EOQualifier.Comparison("contains"));
        this._operatorCombo.add((Object)new EOQualifier.Comparison("like"));
        this._operatorCombo.add((Object)new EOQualifier.Comparison("caseinsensitivelike", "like (any case)"));
        this._operatorCombo.getCombo().setLayoutData((Object)new GridData());
        this._valueText = new Text((Composite)this, 2048);
        this._valueText.setLayoutData((Object)new GridData(768));
    }

    public void setQualifier(EOQualifier qualifier) {
        List<EOQualifier> qualifiers;
        EOQualifier finalQualifier = qualifier;
        if (finalQualifier instanceof EOAggregateQualifier && !(qualifiers = ((EOAggregateQualifier)finalQualifier).getQualifiers()).isEmpty()) {
            finalQualifier = qualifiers.get(0);
        }
        if (finalQualifier instanceof EOKeyValueQualifier) {
            String valueStr;
            EOKeyValueQualifier kvQualifier = (EOKeyValueQualifier)finalQualifier;
            this._key = kvQualifier.getKey();
            this._operatorCombo.setSelection((ISelection)new StructuredSelection((Object)kvQualifier.getComparison()));
            Object value = kvQualifier.getValue();
            if (value instanceof String) {
                String escapedValue = (String)value;
                escapedValue = escapedValue.replaceAll("'", "\\'");
                valueStr = "'" + escapedValue + "'";
            } else {
                valueStr = value instanceof Number ? value.toString() : (value == null ? "" : value.toString());
            }
            this._valueText.setText(valueStr);
        } else if (finalQualifier instanceof EOKeyComparisonQualifier) {
            EOKeyComparisonQualifier kcQualifier = (EOKeyComparisonQualifier)finalQualifier;
            this._key = kcQualifier.getLeftKey();
            this._operatorCombo.setSelection((ISelection)new StructuredSelection((Object)kcQualifier.getComparison()));
            String valueStr = kcQualifier.getRightKey() == null ? "" : kcQualifier.getRightKey();
            this._valueText.setText(valueStr);
        } else {
            this._operatorCombo.setSelection((ISelection)new StructuredSelection(this._operatorCombo.getElementAt(0)));
            this._valueText.setText("");
        }
    }

    public EOQualifier getQualifier() {
        EOQualifier qualifier;
        if (this._key == null) {
            qualifier = null;
        } else {
            EOQualifier.Comparison comparison = (EOQualifier.Comparison)((IStructuredSelection)this._operatorCombo.getSelection()).getFirstElement();
            String value = this._valueText.getText();
            qualifier = EOQualifierFactory.fromString(this._key + " " + comparison + " " + value);
        }
        if (qualifier == null) {
            qualifier = new EOTruePredicate();
        }
        return qualifier;
    }
}

