/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.editors.relationships;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOJoin;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.utils.TablePropertyLabelProvider;

public class EORelationshipsLabelProvider
extends TablePropertyLabelProvider
implements ITableColorProvider,
ITableFontProvider {
    private TableViewer _tableViewer;
    private Font _flattenedFont;
    private Font _inheritedFont;
    private Font _flattenedInheritedFont;

    public EORelationshipsLabelProvider(TableViewer tableViewer, String tableName) {
        super(tableName);
        this._tableViewer = tableViewer;
    }

    public Image getColumnImage(Object element, String property) {
        EORelationship relationship = (EORelationship)element;
        Image image = null;
        if ("toMany".equals(property)) {
            image = this.yesNoImage(relationship.isToMany(), Activator.getDefault().getImageRegistry().get("toMany"), Activator.getDefault().getImageRegistry().get("toOne"), Activator.getDefault().getImageRegistry().get("toOne"));
        } else if ("classProperty".equals(property)) {
            image = this.yesNoImage(relationship.isClassProperty(), Activator.getDefault().getImageRegistry().get("classProperty"), null, null);
        } else if ("optional".equals(property)) {
            image = this.yesNoImage(relationship.isOptional(), Activator.getDefault().getImageRegistry().get("allowNull"), null, null);
        }
        return image;
    }

    public String getColumnText(Object element, String property) {
        EORelationship relationship = (EORelationship)element;
        String text = null;
        if (!("toMany".equals(property) || "classProperty".equals(property) || "optional".equals(property))) {
            if ("destination".equals(property)) {
                EOEntity destination = relationship.getDestination();
                if (destination != null) {
                    text = destination.getName();
                }
            } else if ("sourceAttribute".equals(property)) {
                EOAttribute sourceAttribute;
                EOJoin firstJoin = relationship.getFirstJoin();
                if (firstJoin != null && (sourceAttribute = firstJoin.getSourceAttribute()) != null) {
                    text = sourceAttribute.getName();
                }
            } else if ("destinationAttribute".equals(property)) {
                EOAttribute destinationAttribute;
                EOJoin firstJoin = relationship.getFirstJoin();
                if (firstJoin != null && (destinationAttribute = firstJoin.getDestinationAttribute()) != null) {
                    text = destinationAttribute.getName();
                }
            } else {
                text = super.getColumnText(element, property);
            }
        }
        return text;
    }

    public Font getFont(Object element, int columnIndex) {
        EORelationship relationship = (EORelationship)element;
        Font font = null;
        boolean inherited = relationship.isInherited();
        boolean flattened = relationship.isFlattened();
        if (flattened && inherited) {
            if (this._flattenedInheritedFont == null) {
                Font originalFont = this._tableViewer.getTable().getFont();
                FontData[] fontData = this._tableViewer.getTable().getFont().getFontData();
                this._flattenedInheritedFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 3);
            }
            font = this._flattenedInheritedFont;
        } else if (flattened) {
            if (this._flattenedFont == null) {
                Font originalFont = this._tableViewer.getTable().getFont();
                FontData[] fontData = this._tableViewer.getTable().getFont().getFontData();
                this._flattenedFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
            }
            font = this._flattenedFont;
        } else if (inherited) {
            if (this._inheritedFont == null) {
                Font originalFont = this._tableViewer.getTable().getFont();
                FontData[] fontData = this._tableViewer.getTable().getFont().getFontData();
                this._inheritedFont = new Font(originalFont.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 2);
            }
            font = this._inheritedFont;
        }
        return font;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        boolean isClassProperty;
        EORelationship relationship = (EORelationship)element;
        Color color = null;
        boolean bl = isClassProperty = relationship.isClassProperty() != null && relationship.isClassProperty() != false;
        if (!isClassProperty) {
            color = Display.getCurrent().getSystemColor(16);
        }
        return color;
    }

    public void dispose() {
        if (this._flattenedFont != null) {
            this._flattenedFont.dispose();
        }
        if (this._inheritedFont != null) {
            this._inheritedFont.dispose();
        }
        if (this._flattenedInheritedFont != null) {
            this._flattenedInheritedFont.dispose();
        }
        super.dispose();
    }
}

