/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.outline;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.objectstyle.wolips.eomodeler.Activator;
import org.objectstyle.wolips.eomodeler.core.model.EOModel;
import org.objectstyle.wolips.eomodeler.editors.EOModelClipboardHandler;
import org.objectstyle.wolips.eomodeler.editors.EOModelEditor;
import org.objectstyle.wolips.eomodeler.outline.EOModelLoading;
import org.objectstyle.wolips.eomodeler.outline.EOModelOutlineColumnLabelProvider;
import org.objectstyle.wolips.eomodeler.outline.EOModelOutlineContentProvider;
import org.objectstyle.wolips.eomodeler.outline.EOModelOutlineEditingSupport;
import org.objectstyle.wolips.eomodeler.outline.EOModelTreeViewUpdater;

public class EOModelContentOutlinePage
extends ContentOutlinePage
implements PropertyChangeListener {
    private EOModelTreeViewUpdater _updater;
    private EOModelEditor _editor;
    private EOModelClipboardHandler _clipboardHandler = new EOModelClipboardHandler();
    private ToggleNonClassPropertiesAction _toggleNonClassPropertiesAction;
    private ToggleModelGroupAction _toggleModelGroupAction;
    private Menu _contextMenu;
    private boolean _selectedWithOutline = true;

    public EOModelContentOutlinePage(EOModelEditor editor) {
        this._editor = editor;
    }

    protected void updateClipboardHandler() {
        IPageSite site = this.getSite();
        if (site != null && this._editor != null) {
            IActionBars actionBars = site.getActionBars();
            this._clipboardHandler.attach(actionBars, this._editor);
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer treeViewer = this.getTreeViewer();
        TreeViewerColumn column = new TreeViewerColumn(treeViewer, 0);
        column.setLabelProvider((CellLabelProvider)new EOModelOutlineColumnLabelProvider(treeViewer));
        column.setEditingSupport((EditingSupport)new EOModelOutlineEditingSupport(treeViewer));
        column.getColumn().setWidth(400);
        ColumnViewerEditorActivationStrategy strategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)treeViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 3;
            }
        };
        TreeViewerEditor.create((TreeViewer)treeViewer, null, (ColumnViewerEditorActivationStrategy)strategy, (int)1);
        if (this._updater != null) {
            this._updater.dispose();
        }
        this._updater = new EOModelTreeViewUpdater(treeViewer, new EOModelOutlineContentProvider(true, true, true, true, true, true, true, true));
        this._updater.setModel(this._editor.getModel());
        this.updateClipboardHandler();
        IActionBars actionBars = this.getSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        this._toggleNonClassPropertiesAction = new ToggleNonClassPropertiesAction();
        toolBarManager.add((IAction)this._toggleNonClassPropertiesAction);
        this._toggleModelGroupAction = new ToggleModelGroupAction();
        toolBarManager.add((IAction)this._toggleModelGroupAction);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                m.add((IContributionItem)new Separator("additions"));
            }
        });
        Tree tree = treeViewer.getTree();
        this._contextMenu = menuManager.createContextMenu((Control)treeViewer.getTree());
        tree.setMenu(this._contextMenu);
        this.getSite().registerContextMenu("org.objectstyle.wolips.eomodeler.outline", menuManager, (ISelectionProvider)treeViewer);
        if (this._editor.getModel() == null) {
            treeViewer.setInput((Object)new EOModelLoading(null));
            treeViewer.expandAll();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null) {
            Set oldModels = (Set)evt.getOldValue();
            HashSet newModels = new HashSet((Set)evt.getNewValue());
            newModels.removeAll(oldModels);
            if (newModels.size() == 1) {
                EOModel newModel = (EOModel)newModels.iterator().next();
                Object input = treeViewer.getInput();
                if (input instanceof EOModelLoading) {
                    ((EOModelLoading)input).setModel(newModel);
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        EOModelContentOutlinePage.this.getTreeViewer().refresh(EOModelContentOutlinePage.this.getTreeViewer().getInput());
                        EOModelContentOutlinePage.this.getTreeViewer().expandAll();
                    }
                });
            }
        }
    }

    public void dispose() {
        if (this._contextMenu != null && !this._contextMenu.isDisposed()) {
            this._contextMenu.dispose();
            this._contextMenu = null;
        }
        if (this._updater != null) {
            this._updater.dispose();
        }
        super.dispose();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.updateClipboardHandler();
    }

    public boolean isSelectedWithOutline() {
        return this._selectedWithOutline;
    }

    protected void fireSelectionChanged(ISelection selection) {
        super.fireSelectionChanged(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        this._clipboardHandler.selectionChanged(event);
    }

    public void setSelection(ISelection selection) {
        this._selectedWithOutline = false;
        try {
            super.setSelection(selection);
        }
        finally {
            this._selectedWithOutline = true;
        }
    }

    public EOModelTreeViewUpdater getUpdater() {
        return this._updater;
    }

    public void showModelGroup() {
        this._toggleModelGroupAction.showModelGroup();
    }

    public void showModel() {
        this._toggleModelGroupAction.showModel();
    }

    public class ToggleNonClassPropertiesAction
    extends Action {
        private boolean _showNonClassProperties = true;

        public ToggleNonClassPropertiesAction() {
            this.refreshUI();
            this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("classProperty"));
        }

        public void toggleChanged() {
            this._showNonClassProperties = !this._showNonClassProperties;
            this.refreshUI();
        }

        public void refreshUI() {
            if (this._showNonClassProperties) {
                EOModelContentOutlinePage.this.getUpdater().showNonClassProperties();
                this.setToolTipText("Hide Non-Class Properties");
                this.setChecked(true);
            } else {
                EOModelContentOutlinePage.this.getUpdater().hideNonClassProperties();
                this.setToolTipText("Show Non-Class Properties");
                this.setChecked(false);
            }
        }

        public void run() {
            this.toggleChanged();
        }
    }

    public class ToggleModelGroupAction
    extends Action {
        private boolean _showModel = true;

        public ToggleModelGroupAction() {
            this.refreshUI();
            this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("eoModel"));
        }

        public void toggleChanged() {
            this._showModel = !this._showModel;
            this.refreshUI();
        }

        public void showModelGroup() {
            this._showModel = false;
            this.refreshUI();
        }

        public void showModel() {
            this._showModel = true;
            this.refreshUI();
        }

        public void refreshUI() {
            if (this._showModel) {
                EOModelContentOutlinePage.this.getUpdater().showModel();
                this.setToolTipText("Show ModelGroup");
                this.setChecked(false);
            } else {
                EOModelContentOutlinePage.this.getUpdater().showModelGroup();
                this.setToolTipText("Show Model");
                this.setChecked(true);
            }
        }

        public void run() {
            this.toggleChanged();
        }
    }
}

