/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.eomodeler.utils;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.baseforuiplugins.utils.ErrorUtils;
import org.objectstyle.wolips.eomodeler.core.kvc.CachingKeyPath;
import org.objectstyle.wolips.eomodeler.core.kvc.IKey;
import org.objectstyle.wolips.eomodeler.core.utils.IPropertyChangeSource;

public class ComboViewerBinding
implements ISelectionChangedListener,
PropertyChangeListener {
    private ComboViewer myViewer;
    private IPropertyChangeSource myObj;
    private String myPropertyName;
    private IPropertyChangeSource myListObj;
    private String myListPropertyName;
    private Object myBlankValue;
    private Map<String, IKey> myKeys;

    public ComboViewerBinding(ComboViewer _viewer, IPropertyChangeSource _obj, String _propertyName, IPropertyChangeSource _listObj, String _listPropertyName, Object _blankValue) {
        this.myViewer = _viewer;
        this.myKeys = new HashMap<String, IKey>();
        this.myObj = _obj;
        this.myPropertyName = _propertyName;
        this.myListObj = _listObj;
        this.myListPropertyName = _listPropertyName;
        this.myBlankValue = _blankValue;
        Object initialValue = this.getKey(this.myPropertyName).getValue(this.myObj);
        this.setSelectedValue(initialValue);
        this.myViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.myObj.addPropertyChangeListener(this.myPropertyName, this);
        if (this.myListObj != null) {
            this.myListObj.addPropertyChangeListener(this.myListPropertyName, this);
        }
    }

    protected synchronized IKey getKey(String _property) {
        IKey key = this.myKeys.get(_property);
        if (key == null) {
            key = new CachingKeyPath(_property);
            this.myKeys.put(_property, key);
        }
        return key;
    }

    public void dispose() {
        this.myViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.myObj.removePropertyChangeListener(this.myPropertyName, this);
        if (this.myListObj != null) {
            this.myListObj.removePropertyChangeListener(this.myListPropertyName, this);
        }
    }

    public void propertyChange(PropertyChangeEvent _event) {
        Object source = _event.getSource();
        String propertyName = _event.getPropertyName();
        if (source == this.myObj && this.myPropertyName.equals(propertyName)) {
            Object newValue = _event.getNewValue();
            this.setSelectedValue(newValue);
        } else if (this.myListObj != null && source == this.myListObj && this.myListPropertyName.equals(propertyName)) {
            ISelection selection = this.myViewer.getSelection();
            if (this.myViewer.getContentProvider() != null) {
                this.myViewer.setInput((Object)this.myListObj);
                this.myViewer.setSelection(selection);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent _event) {
        try {
            IKey key;
            Object existingValue;
            Object newValue = ((IStructuredSelection)_event.getSelection()).getFirstElement();
            if (ComparisonUtils.equals((Object)this.myBlankValue, (Object)newValue)) {
                newValue = null;
            }
            if (!ComparisonUtils.equals((Object)(existingValue = (key = this.getKey(this.myPropertyName)).getValue(this.myObj)), (Object)newValue)) {
                key.setValue(this.myObj, newValue);
            }
        }
        catch (Exception e) {
            ErrorUtils.openErrorDialog((Shell)Display.getDefault().getActiveShell(), (Throwable)e);
        }
    }

    protected void setSelectedValue(Object _newValue) {
        if (_newValue == null || _newValue == this.myBlankValue || this.myBlankValue != null && this.myBlankValue.equals(_newValue)) {
            if (this.myBlankValue != null) {
                this.myViewer.setSelection((ISelection)new StructuredSelection(this.myBlankValue), true);
            }
        } else {
            this.myViewer.setSelection((ISelection)new StructuredSelection(_newValue), true);
        }
    }
}

