/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.JdtPlugin;
import org.objectstyle.wolips.jdt.classpath.model.EclipseFrameworkModel;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;
import org.objectstyle.wolips.variables.BuildProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFrameworkAdapter {
    private IProject _project;

    public ProjectFrameworkAdapter(IProject project) {
        this._project = project;
    }

    public IProject getProject() {
        return this._project;
    }

    public IEclipseFramework getFramework() {
        EclipseFrameworkModel frameworkModel = JdtPlugin.getDefault().getFrameworkModel(this._project);
        IEclipseFramework framework = (IEclipseFramework)frameworkModel.getApplicationWithName(this._project.getName());
        if (framework == null) {
            framework = (IEclipseFramework)frameworkModel.getFrameworkWithName(this._project.getName());
        }
        return framework;
    }

    public void addFrameworkNamed(String frameworkName) throws JavaModelException {
        this.addFrameworksNamed(frameworkName);
    }

    public void addFrameworksNamed(List<String> frameworkNames) throws JavaModelException {
        this.addFrameworksNamed(frameworkNames.toArray(new String[frameworkNames.size()]));
    }

    public void addFrameworksNamed(String ... frameworkNames) throws JavaModelException {
        IProject project = this.getProject();
        EclipseFrameworkModel frameworkModel = JdtPlugin.getDefault().getFrameworkModel(project);
        LinkedList<IEclipseFramework> frameworks = new LinkedList<IEclipseFramework>();
        for (String frameworkName : frameworkNames) {
            IEclipseFramework framework = (IEclipseFramework)frameworkModel.getFrameworkWithName(frameworkName);
            if (framework == null) {
                throw new NoSuchElementException("There is no framework named '" + frameworkName + "'.");
            }
            frameworks.add(framework);
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IEclipseFramework.Utility.addFrameworksToProject(frameworks, javaProject, true);
    }

    public void addFrameworks(IEclipseFramework ... frameworks) throws JavaModelException {
        LinkedList<IEclipseFramework> frameworksList = new LinkedList<IEclipseFramework>();
        for (IEclipseFramework framework : frameworks) {
            frameworksList.add(framework);
        }
        IProject project = this.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IEclipseFramework.Utility.addFrameworksToProject(frameworksList, javaProject, true);
    }

    public void removeFrameworkNamed(String frameworkName) throws JavaModelException {
        this.removeFrameworksNamed(frameworkName);
    }

    public void removeFrameworksNamed(List<String> frameworkNames) throws JavaModelException {
        this.removeFrameworksNamed(frameworkNames.toArray(new String[frameworkNames.size()]));
    }

    public void removeFrameworksNamed(String ... frameworkNames) throws JavaModelException {
        IProject project = this.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        EclipseFrameworkModel frameworkModel = JdtPlugin.getDefault().getFrameworkModel(project);
        LinkedList<IEclipseFramework> frameworks = new LinkedList<IEclipseFramework>();
        for (String frameworkName : frameworkNames) {
            IEclipseFramework framework = (IEclipseFramework)frameworkModel.getFrameworkWithName(frameworkName);
            if (framework == null) {
                throw new NoSuchElementException("There is no framework named '" + frameworkName + "'.");
            }
            frameworks.add(framework);
        }
        IEclipseFramework.Utility.removeFrameworksFromProject(frameworks, javaProject, true);
    }

    public List<IEclipseFramework> getLinkedFrameworks() throws JavaModelException {
        IProject project = this.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return IEclipseFramework.Utility.getFrameworks(javaProject);
    }

    public Set<String> getLinkedFrameworkNames() throws JavaModelException {
        HashSet<String> frameworkNames = new HashSet<String>();
        for (IEclipseFramework framework : this.getLinkedFrameworks()) {
            frameworkNames.add(framework.getName());
        }
        return frameworkNames;
    }

    public boolean isLinkedToFrameworkNamed(String frameworkName) throws JavaModelException {
        return this.getLinkedFrameworkNames().contains(frameworkName);
    }

    public IEclipseFramework getLinkedFrameworkNamed(String frameworkName) throws JavaModelException {
        for (IEclipseFramework linkedFramework : this.getLinkedFrameworks()) {
            if (!linkedFramework.getName().equals(frameworkName)) continue;
            return linkedFramework;
        }
        EclipseFrameworkModel frameworkModel = JdtPlugin.getDefault().getFrameworkModel(this.getProject());
        IEclipseFramework framework = (IEclipseFramework)frameworkModel.getFrameworkWithName(frameworkName);
        return framework;
    }

    public Map<String, IEclipseFramework> getPluginFrameworks() {
        TreeMap<String, IEclipseFramework> pluginFrameworks = new TreeMap<String, IEclipseFramework>();
        Pattern pluginPattern = Pattern.compile("(.*)PlugIn");
        EclipseFrameworkModel frameworkModel = JdtPlugin.getDefault().getFrameworkModel(this.getProject());
        for (IEclipseFramework framework : frameworkModel.getAllFrameworks()) {
            String frameworkName = framework.getName();
            Matcher matcher = pluginPattern.matcher(frameworkName);
            if (!matcher.matches()) continue;
            String pluginName = matcher.group(1);
            pluginFrameworks.put(pluginName, framework);
        }
        return pluginFrameworks;
    }

    public Map<String, IEclipseFramework> getAdaptorFrameworks() {
        TreeMap<String, IEclipseFramework> adaptorFrameworks = new TreeMap<String, IEclipseFramework>();
        Pattern adaptorPattern = Pattern.compile("Java(.*)Adaptor");
        EclipseFrameworkModel frameworkModel = JdtPlugin.getDefault().getFrameworkModel(this.getProject());
        for (IEclipseFramework framework : frameworkModel.getAllFrameworks()) {
            String frameworkName = framework.getName();
            Matcher matcher = adaptorPattern.matcher(frameworkName);
            if (!matcher.matches()) continue;
            String adaptorName = matcher.group(1);
            adaptorFrameworks.put(adaptorName, framework);
        }
        return adaptorFrameworks;
    }

    public List<IPath> getFrameworkPaths() {
        ArrayList<IPath> list = new ArrayList<IPath>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!this.isFrameworkReference(projects[i])) continue;
            list.add(projects[i].getLocation());
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.getProject());
            list.addAll(this.toFrameworkPaths(javaProject.getResolvedClasspath(false)));
        }
        catch (JavaModelException e) {
            JdtPlugin.getDefault().getPluginLogger().log((Throwable)e);
        }
        return list;
    }

    private List<IPath> toFrameworkPaths(IClasspathEntry[] classpathEntries) {
        ArrayList<IPath> arrayList = new ArrayList<IPath>();
        for (int i = 0; i < classpathEntries.length; ++i) {
            IPath path = classpathEntries[i].getPath();
            IPath choppedFrameworkPath = null;
            int count = path.segmentCount();
            for (int pathElementNum = 0; pathElementNum < count && choppedFrameworkPath == null; ++pathElementNum) {
                String segment = path.segment(pathElementNum);
                if (!segment.endsWith(".framework")) continue;
                choppedFrameworkPath = path.removeLastSegments(count - pathElementNum - 1);
            }
            if (choppedFrameworkPath == null || choppedFrameworkPath.lastSegment().startsWith("JavaVM")) continue;
            arrayList.add(choppedFrameworkPath);
        }
        return arrayList;
    }

    public boolean isFrameworkReference(IProject iProject) {
        boolean isFrameworkReference;
        IJavaProject javaProject = null;
        try {
            ProjectAdapter project;
            javaProject = JavaCore.create((IProject)this.getProject());
            isFrameworkReference = javaProject == null ? false : (project = (ProjectAdapter)iProject.getAdapter(ProjectAdapter.class)) != null && project.isFramework() && ProjectFrameworkAdapter.isProjectReferencedByProject(iProject, javaProject.getProject());
        }
        catch (Exception e) {
            JdtPlugin.getDefault().getPluginLogger().log((Throwable)e);
            isFrameworkReference = false;
        }
        return isFrameworkReference;
    }

    public static boolean isProjectReferencedByProject(IProject child, IProject mother) {
        IProject[] projects;
        try {
            projects = mother.getReferencedProjects();
        }
        catch (Exception e) {
            JdtPlugin.getDefault().getPluginLogger().log((Throwable)e);
            return false;
        }
        for (IProject project : projects) {
            if (!project.equals(child)) continue;
            return true;
        }
        return false;
    }

    public void initializeProject() {
        this._project.getAdapter(BuildProperties.class);
    }
}

