/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.classpath;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.objectstyle.wolips.jdt.JdtPlugin;
import org.objectstyle.wolips.jdt.classpath.WOFrameworkClasspathContainer;
import org.objectstyle.wolips.jdt.classpath.model.EclipseFrameworkModel;
import org.objectstyle.wolips.jdt.classpath.model.IEclipseFramework;
import org.objectstyle.wolips.variables.VariablesPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WOFrameworkContainerInitializer
extends ClasspathContainerInitializer {
    protected Map<IEclipseFramework, WOFrameworkClasspathContainer> classpathContainerCache = new HashMap<IEclipseFramework, WOFrameworkClasspathContainer>();

    public String getDescription(IPath containerPath, IJavaProject project) {
        String frameworkName = this.frameworkNameForClasspathPath(containerPath);
        return frameworkName + " WebObjects Framework";
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        this.initialize(containerPath, project);
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        if (containerPath == null) {
            return null;
        }
        return this.frameworkNameForClasspathPath(containerPath);
    }

    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        String containerID = containerPath.segment(0);
        if ("WOFramework".equals(containerID)) {
            WOFrameworkClasspathContainer frameworkContainer = this.classpathContainerForPath(containerPath, javaProject);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{frameworkContainer}, null);
        }
    }

    protected synchronized WOFrameworkClasspathContainer classpathContainerForFramework(IEclipseFramework framework, IPath containerPath) {
        if (framework == null) {
            return null;
        }
        WOFrameworkClasspathContainer container = this.classpathContainerCache.get(framework);
        if (container == null) {
            container = new WOFrameworkClasspathContainer(framework, this.paramsForClasspathPath(containerPath));
            this.classpathContainerCache.put(framework, container);
        }
        return container;
    }

    protected WOFrameworkClasspathContainer classpathContainerForPath(IPath containerPath, IJavaProject javaProject) {
        String frameworkName = this.frameworkNameForClasspathPath(containerPath);
        boolean hasProjectConfig = VariablesPlugin.getDefault().hasProjectVariables(javaProject.getProject());
        EclipseFrameworkModel frameworkModel = JdtPlugin.getDefault().getFrameworkModel(hasProjectConfig ? javaProject.getProject() : null);
        IEclipseFramework framework = (IEclipseFramework)frameworkModel.getFrameworkWithName(frameworkName);
        return this.classpathContainerForFramework(framework, containerPath);
    }

    protected Map<String, String> paramsForClasspathPath(IPath path) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (path == null) {
            return params;
        }
        for (int segmentNum = 2; segmentNum < path.segmentCount(); ++segmentNum) {
            String kvPair = path.segment(segmentNum);
            int equalsIndex = kvPair.indexOf(61);
            if (equalsIndex == -1) continue;
            String key = kvPair.substring(0, equalsIndex);
            String value = kvPair.substring(equalsIndex + 1);
            params.put(key, value);
        }
        return params;
    }

    protected String frameworkNameForClasspathPath(IPath path) {
        return path.segment(1);
    }
}

