/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.classpath.model;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.woenvironment.frameworks.IFramework;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.jdt.JdtPlugin;
import org.objectstyle.wolips.jdt.classpath.WOFrameworkClasspathContainer;
import org.objectstyle.wolips.jdt.classpath.model.EclipseFrameworkModel;
import org.objectstyle.wolips.jdt.classpath.model.EclipseJarFramework;

public interface IEclipseFramework
extends IFramework {
    public IClasspathEntry[] getClasspathEntries();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Utility {
        public static void addFrameworksToProject(List<IEclipseFramework> frameworksToAdd, IJavaProject javaProject, boolean reload) throws JavaModelException {
            IClasspathEntry[] existingEntries = reload ? javaProject.readRawClasspath() : javaProject.getRawClasspath();
            LinkedList<IClasspathEntry> newEntries = new LinkedList<IClasspathEntry>();
            for (IClasspathEntry existingEntry : existingEntries) {
                newEntries.add(existingEntry);
            }
            boolean addedFramework = false;
            for (IEclipseFramework newFramework : frameworksToAdd) {
                addedFramework |= Utility.addFrameworkToProject(newFramework, javaProject, newEntries);
            }
            if (addedFramework) {
                javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
            }
        }

        public static void addFrameworkToProject(IEclipseFramework frameworkToAdd, IJavaProject javaProject, boolean reload) throws JavaModelException {
            IClasspathEntry[] existingEntries = reload ? javaProject.readRawClasspath() : javaProject.getRawClasspath();
            LinkedList<IClasspathEntry> newEntries = new LinkedList<IClasspathEntry>();
            for (IClasspathEntry existingEntry : existingEntries) {
                newEntries.add(existingEntry);
            }
            boolean addedFramework = Utility.addFrameworkToProject(frameworkToAdd, javaProject, newEntries);
            if (addedFramework) {
                javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
            }
        }

        public static boolean addProjectToProject(IProject referencedProject, IJavaProject javaProject, List<IClasspathEntry> existingEntries) {
            IClasspathEntry classpathEntry;
            IEclipseFramework framework;
            boolean addedProject = false;
            boolean referencedProjectIsFramework = false;
            ProjectAdapter referencedProjectAdaptor = (ProjectAdapter)referencedProject.getAdapter(ProjectAdapter.class);
            if (referencedProjectAdaptor != null && (framework = (IEclipseFramework)JdtPlugin.getDefault().getFrameworkModel(javaProject.getProject()).getFrameworkWithName(referencedProjectAdaptor.getBundleName())) != null) {
                referencedProjectIsFramework = true;
                addedProject = Utility.addFrameworkToProject(framework, javaProject, existingEntries);
            }
            if (!referencedProjectIsFramework && !existingEntries.contains(classpathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath()))) {
                existingEntries.add(classpathEntry);
                addedProject = true;
            }
            return addedProject;
        }

        public static boolean addFrameworkToProject(IEclipseFramework frameworkToAdd, IJavaProject javaProject, List<IClasspathEntry> existingEntries) {
            boolean addFramework = true;
            String name = frameworkToAdd.getName();
            for (IClasspathEntry existingEntry : existingEntries) {
                IEclipseFramework framework;
                WOFrameworkClasspathContainer frameworkContainer = WOFrameworkClasspathContainer.getFrameworkClasspathContainer(javaProject, existingEntry);
                if (frameworkContainer == null || !(framework = frameworkContainer.getFramework()).getName().equals(name)) continue;
                addFramework = false;
            }
            if (addFramework) {
                WOFrameworkClasspathContainer newContainer = new WOFrameworkClasspathContainer(frameworkToAdd);
                IClasspathEntry newEntry = JavaCore.newContainerEntry((IPath)newContainer.getPath());
                existingEntries.add(newEntry);
            }
            return addFramework;
        }

        public static void removeFrameworksFromProject(List<IEclipseFramework> frameworksToRemove, IJavaProject javaProject, boolean reload) throws JavaModelException {
            IClasspathEntry[] existingEntries = reload ? javaProject.readRawClasspath() : javaProject.getRawClasspath();
            LinkedList<IClasspathEntry> newEntries = new LinkedList<IClasspathEntry>();
            for (IClasspathEntry existingEntry : existingEntries) {
                newEntries.add(existingEntry);
            }
            boolean removedFramework = false;
            for (IEclipseFramework newFramework : frameworksToRemove) {
                removedFramework |= Utility.removeFrameworkFromProject(newFramework, javaProject, newEntries);
            }
            if (removedFramework) {
                javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
            }
        }

        public static void removeFrameworkFromProject(IEclipseFramework frameworkToRemove, IJavaProject javaProject, boolean reload) throws JavaModelException {
            IClasspathEntry[] existingEntries = reload ? javaProject.readRawClasspath() : javaProject.getRawClasspath();
            LinkedList<IClasspathEntry> newEntries = new LinkedList<IClasspathEntry>();
            for (IClasspathEntry existingEntry : existingEntries) {
                newEntries.add(existingEntry);
            }
            boolean removedFramework = Utility.removeFrameworkFromProject(frameworkToRemove, javaProject, newEntries);
            if (removedFramework) {
                javaProject.setRawClasspath(newEntries.toArray(new IClasspathEntry[newEntries.size()]), null);
            }
        }

        public static boolean removeFrameworkFromProject(IEclipseFramework frameworkToRemove, IJavaProject javaProject, List<IClasspathEntry> existingEntries) {
            IClasspathEntry removeEntry = null;
            String name = frameworkToRemove.getName();
            for (IClasspathEntry existingEntry : existingEntries) {
                IEclipseFramework framework;
                WOFrameworkClasspathContainer frameworkContainer = WOFrameworkClasspathContainer.getFrameworkClasspathContainer(javaProject, existingEntry);
                if (frameworkContainer == null || !(framework = frameworkContainer.getFramework()).getName().equals(name)) continue;
                removeEntry = existingEntry;
            }
            if (removeEntry != null) {
                existingEntries.remove(removeEntry);
            }
            return removeEntry != null;
        }

        public static List<IEclipseFramework> getFrameworks(IJavaProject javaProject) throws JavaModelException {
            IClasspathEntry[] classpathEntries;
            EclipseFrameworkModel frameworkModel = JdtPlugin.getDefault().getFrameworkModel(javaProject.getProject());
            LinkedList<IEclipseFramework> frameworks = new LinkedList<IEclipseFramework>();
            for (IClasspathEntry classpathEntry : classpathEntries = javaProject.getRawClasspath()) {
                EclipseJarFramework jarFramework;
                IClasspathEntry resolvedClasspathEntry;
                File classpathFile;
                WOFrameworkClasspathContainer frameworkContainer = WOFrameworkClasspathContainer.getFrameworkClasspathContainer(javaProject, classpathEntry);
                if (frameworkContainer != null) {
                    IEclipseFramework framework = frameworkContainer.getFramework();
                    frameworks.add(framework);
                    continue;
                }
                if (classpathEntry.getEntryKind() != 1 || !(classpathFile = (resolvedClasspathEntry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)classpathEntry)).getPath().toFile()).exists() || !classpathFile.getName().toLowerCase().endsWith(".jar") || !(jarFramework = new EclipseJarFramework(frameworkModel.getRootWithShortName("ProjectLocal"), classpathFile)).isValid()) continue;
                frameworks.add(jarFramework);
            }
            return frameworks;
        }
    }
}

