/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.jdt.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.objectstyle.wolips.jdt.ui.WOPackageExplorerPart;
import org.objectstyle.wolips.jdt.ui.tags.ITaggedComponentsContentProvider;
import org.objectstyle.wolips.jdt.ui.tags.TaggedComponentsContentProvider;
import org.objectstyle.wolips.jdt.ui.tags.WOTagLibResourceChangeListener;

public class WOPackageExplorerContentProvider
extends PackageExplorerContentProvider {
    private IResourceChangeListener resourceChangeListener;
    WOPackageExplorerPart woPackageExplorerPart;
    Map<IProject, TaggedComponentsContentProvider> taggedComponentsContentProviders = new HashMap<IProject, TaggedComponentsContentProvider>();

    public WOPackageExplorerContentProvider(boolean provideMembers, WOPackageExplorerPart woPackageExplorerPart) {
        super(provideMembers);
        this.woPackageExplorerPart = woPackageExplorerPart;
        this.resourceChangeListener = new WOTagLibResourceChangeListener(){

            public void update(IProject project) {
                TaggedComponentsContentProvider taggedComponentsContentProvider = WOPackageExplorerContentProvider.this.taggedComponentsContentProviders.get(project);
                if (taggedComponentsContentProvider != null) {
                    taggedComponentsContentProvider.forgetTagLib();
                    WOPackageExplorerContentProvider.this.woPackageExplorerPart.getTreeViewer().refresh((Object)taggedComponentsContentProvider);
                }
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ITaggedComponentsContentProvider) {
            ITaggedComponentsContentProvider taggedComponentsContentProvider = (ITaggedComponentsContentProvider)parentElement;
            return taggedComponentsContentProvider.getChildren();
        }
        Object[] children = super.getChildren(parentElement);
        if (parentElement instanceof IJavaProject && children.length > 2) {
            Object[] tags;
            IJavaProject javaProject = (IJavaProject)parentElement;
            IProject project = javaProject.getProject();
            TaggedComponentsContentProvider taggedComponentsContentProvider = this.taggedComponentsContentProviders.get(project);
            if (taggedComponentsContentProvider == null) {
                taggedComponentsContentProvider = new TaggedComponentsContentProvider(project);
                this.taggedComponentsContentProviders.put(project, taggedComponentsContentProvider);
            }
            if ((tags = taggedComponentsContentProvider.getChildren()) != null && tags.length > 0) {
                Object[] newChildren = new Object[children.length + 1];
                newChildren[newChildren.length - 1] = taggedComponentsContentProvider;
                for (int i = 0; i < children.length; ++i) {
                    Object object;
                    newChildren[i] = object = children[i];
                }
                return newChildren;
            }
        }
        return children;
    }

    protected Object[] getFolderContent(IFolder folder) throws CoreException {
        Object[] contents = WOPackageExplorerContentProvider.isBundle(folder) ? NO_CHILDREN : super.getFolderContent(folder);
        return contents;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ITaggedComponentsContentProvider) {
            ITaggedComponentsContentProvider taggedComponentsContentProvider = (ITaggedComponentsContentProvider)element;
            return taggedComponentsContentProvider.hasChildren();
        }
        return super.hasChildren(element);
    }

    public static boolean isBundle(IFolder folder) {
        String folderName = folder.getName();
        boolean bundle = folderName.endsWith(".eomodeld") || folderName.endsWith(".wo");
        return bundle;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.dispose();
    }
}

