/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.action;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.objectstyle.wolips.wodclipse.core.completion.WodCompletionProposal;
import org.objectstyle.wolips.wodclipse.core.completion.WodCompletionUtils;

public class ComponentLiveSearch
implements ModifyListener,
SelectionListener {
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    private IJavaProject _project;
    private IProgressMonitor _progressMonitor;
    private String _lastSearch;
    private Point _lastSelection;
    private String _lastValue;
    private Boolean _ignoreModify = false;
    private Object _completionLock = new Object();

    public ComponentLiveSearch(IJavaProject project, IProgressMonitor progressMonitor) {
        this._project = project;
        this._progressMonitor = progressMonitor;
    }

    public void attachTo(Combo combo) {
        if (combo != null) {
            combo.addModifyListener((ModifyListener)this);
            combo.addSelectionListener((SelectionListener)this);
        }
    }

    public void detachFrom(Combo combo) {
        if (combo != null) {
            combo.removeModifyListener((ModifyListener)this);
            combo.removeSelectionListener((SelectionListener)this);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void widgetSelected(SelectionEvent e) {
        Combo componentNameCombo = (Combo)e.getSource();
        Point selection = componentNameCombo.getSelection();
        if (this._lastSelection != null && selection.x == 0) {
            selection.x = this._lastSelection.y;
            Boolean bl = this._ignoreModify;
            synchronized (bl) {
                this._ignoreModify = true;
                componentNameCombo.setSelection(selection);
                this._ignoreModify = false;
            }
            componentNameCombo.notifyListeners(24, new Event());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyText(ModifyEvent e) {
        String partialName;
        if (this._ignoreModify.booleanValue()) {
            return;
        }
        final Combo componentNameCombo = (Combo)e.getSource();
        Point selection = componentNameCombo.getSelection();
        boolean _deleted = false;
        if (selection.x > 0 && this._lastSelection != null && selection.x == selection.y && selection.x == this._lastSelection.x && this._lastSelection.y >= selection.x && this._lastSelection.y >= componentNameCombo.getText().length()) {
            _deleted = true;
            String text = componentNameCombo.getText();
            Boolean bl = this._ignoreModify;
            synchronized (bl) {
                this._ignoreModify = true;
                componentNameCombo.setText(text.substring(0, selection.x - 1));
                selection.y = selection.x = text.length() - 1;
                componentNameCombo.setSelection(selection);
                this._ignoreModify = false;
            }
        }
        if (isWindows && selection.x == 0 && selection.x != selection.y && selection.y == componentNameCombo.getText().length()) {
            return;
        }
        if (selection != null && selection.x != selection.y) {
            partialName = componentNameCombo.getText().substring(0, selection.x);
        } else {
            partialName = componentNameCombo.getText();
            this._lastSelection = selection;
        }
        if (this._lastValue != null && !_deleted) {
            _deleted = partialName.length() < this._lastValue.length() && selection.x != 0;
        }
        this._lastValue = partialName;
        if (this._lastSearch == null || !this._lastSearch.toLowerCase().equals(partialName.toLowerCase())) {
            final boolean wasDeleted = _deleted;
            this._lastSearch = partialName;
            this._progressMonitor.setCanceled(true);
            WorkspaceJob job = new WorkspaceJob("Searching for components ..."){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    Object object = ComponentLiveSearch.this._completionLock;
                    synchronized (object) {
                        ComponentLiveSearch.this._progressMonitor.setCanceled(false);
                        Comparator<WodCompletionProposal> nameOrder = new Comparator<WodCompletionProposal>(){

                            @Override
                            public int compare(WodCompletionProposal p1, WodCompletionProposal p2) {
                                return p1.getDisplayString().compareTo(p2.getDisplayString());
                            }
                        };
                        try {
                            final TreeSet<WodCompletionProposal> proposals = new TreeSet<WodCompletionProposal>(nameOrder);
                            WodCompletionUtils.fillInElementTypeCompletionProposals(ComponentLiveSearch.this._project, partialName, 0, partialName.length(), proposals, false, ComponentLiveSearch.this._progressMonitor);
                            if (!ComponentLiveSearch.this._progressMonitor.isCanceled()) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        block14: {
                                            if (!componentNameCombo.isDisposed()) {
                                                componentNameCombo.remove(0, componentNameCombo.getItemCount() - 1);
                                                boolean exactMatch = false;
                                                for (WodCompletionProposal elementName : proposals) {
                                                    String displayString = elementName.getDisplayString();
                                                    if (displayString != null && displayString.equals(ComponentLiveSearch.this._lastSearch)) {
                                                        exactMatch = true;
                                                    }
                                                    componentNameCombo.add(displayString);
                                                }
                                                try {
                                                    String text;
                                                    Method setListVisible = componentNameCombo.getClass().getDeclaredMethod("setListVisible", Boolean.TYPE);
                                                    setListVisible.setAccessible(true);
                                                    if (!isWindows) {
                                                        setListVisible.invoke((Object)componentNameCombo, false);
                                                    }
                                                    Point _selection = componentNameCombo.getSelection();
                                                    if (componentNameCombo.getItemCount() > 1) {
                                                        text = componentNameCombo.getItem(0);
                                                        _selection.y = text.length();
                                                        Boolean bl = ComponentLiveSearch.this._ignoreModify;
                                                        synchronized (bl) {
                                                            String partialText = componentNameCombo.getText();
                                                            if (!text.toLowerCase().startsWith(partialText.toLowerCase())) {
                                                                return;
                                                            }
                                                            ComponentLiveSearch.this._ignoreModify = true;
                                                            setListVisible.invoke((Object)componentNameCombo, true);
                                                            componentNameCombo.setText(text);
                                                            componentNameCombo.setSelection(_selection);
                                                            ComponentLiveSearch.this._ignoreModify = false;
                                                            break block14;
                                                        }
                                                    }
                                                    if (componentNameCombo.getItemCount() != 1) break block14;
                                                    setListVisible.invoke((Object)componentNameCombo, false);
                                                    text = componentNameCombo.getItem(0);
                                                    if (_selection.x != _selection.y || wasDeleted) break block14;
                                                    _selection.y = text.length();
                                                    Boolean bl = ComponentLiveSearch.this._ignoreModify;
                                                    synchronized (bl) {
                                                        ComponentLiveSearch.this._ignoreModify = true;
                                                        componentNameCombo.setText(text);
                                                        componentNameCombo.setSelection(_selection);
                                                        ComponentLiveSearch.this._ignoreModify = false;
                                                    }
                                                    ComponentLiveSearch.this._lastSelection = _selection;
                                                }
                                                catch (Throwable ex) {
                                                    ex.printStackTrace();
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                        }
                        catch (OperationCanceledException proposals) {
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        return Status.OK_STATUS;
                    }
                }
            };
            job.schedule();
        }
    }
}

