/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.builder;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.core.resources.builder.AbstractFullAndIncrementalBuilder;
import org.objectstyle.wolips.core.resources.types.SuperTypeHierarchyCache;
import org.objectstyle.wolips.core.resources.types.WOHierarchyScope;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.variables.VariablesPlugin;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.util.WodModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WodBuilder
extends AbstractFullAndIncrementalBuilder {
    private static ExecutorService validationThreadPool;
    private static ValidationProgressJob _validationJob;
    private boolean _validateTemplatesAtAll;
    private boolean _validateTemplatesNow;
    private int _buildKind;
    private boolean _threadedBuild;

    public boolean isEnabled() {
        return true;
    }

    protected static boolean getBooleanProperty(String propertiesKey, String preferencesKey, IProject project, IPreferenceStore preferenceStore) {
        String globalPropertiesValueStr;
        BuildProperties buildProperties = (BuildProperties)project.getAdapter(BuildProperties.class);
        String buildPropertiesValueStr = buildProperties.get(propertiesKey);
        boolean value = buildPropertiesValueStr != null ? "true".equalsIgnoreCase(buildPropertiesValueStr) : ((globalPropertiesValueStr = VariablesPlugin.getDefault().getGlobalVariables().getString(propertiesKey + "." + project.getName())) != null ? "true".equalsIgnoreCase(globalPropertiesValueStr) : preferenceStore.getBoolean(preferencesKey));
        return value;
    }

    public boolean buildStarted(int kind, Map args, IProgressMonitor monitor, IProject project, Map buildCache) {
        this._buildKind = kind;
        if (WodBuilder.getBooleanProperty("component.validateTemplates", "ValidateTemplatesKey", project, Activator.getDefault().getPreferenceStore())) {
            this._validateTemplatesAtAll = true;
            this._validateTemplatesNow = WodBuilder.getBooleanProperty("component.validateTemplatesOnBuild", "ValidateTemplatesOnBuildKey", project, Activator.getDefault().getPreferenceStore());
        }
        this._threadedBuild = WodBuilder.getBooleanProperty("component.threadedValidation", "ThreadedValidation", project, Activator.getDefault().getPreferenceStore());
        if (kind == 6) {
            WodParserCache.getModelGroupCache().clearCacheForProject(project);
            WodParserCache.getTypeCache().clearCacheForProject(project);
            WOHierarchyScope.clearCacheForProject((IProject)project);
        }
        return false;
    }

    public boolean buildPreparationDone(int kind, Map args, IProgressMonitor monitor, IProject project, Map buildCache) {
        return false;
    }

    public void handleClasses(IResource resource, IProgressMonitor monitor, Map buildCache) {
    }

    public void handleSource(IResource resource, IProgressMonitor progressMonitor, Map buildCache) {
        if (this._validateTemplatesNow) {
            try {
                LocalizedComponentsLocateResult results;
                IFile wodFile;
                ITypeHierarchy typeHierarchy;
                IType woElementType;
                IType type;
                ICompilationUnit compilationUnit;
                if ((this._buildKind == 10 || this._buildKind == 9) && (compilationUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource))) != null && (type = compilationUnit.findPrimaryType()) != null && (woElementType = type.getJavaProject().findType("com.webobjects.appserver.WOElement", progressMonitor)) != null && (typeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)type, (IProgressMonitor)progressMonitor)) != null && typeHierarchy.contains(woElementType) && (wodFile = (results = LocatePlugin.getDefault().getLocalizedComponentsLocateResult(resource)).getFirstWodFile()) != null && wodFile.exists()) {
                    wodFile.touch(progressMonitor);
                    this.validateWodFile((IResource)wodFile, progressMonitor);
                }
            }
            catch (Throwable t) {
                Activator.getDefault().log(t);
            }
        }
    }

    public void handleClasspath(IResource resource, IProgressMonitor monitor, Map buildCache) {
    }

    protected Set<IContainer> componentBuildCache(Map buildCache) {
        HashSet builtComponents = (HashSet)buildCache.get("builtComponents");
        if (builtComponents == null) {
            builtComponents = new HashSet();
            buildCache.put("builtComponents", builtComponents);
        }
        return builtComponents;
    }

    public void handleOther(IResource resource, IProgressMonitor monitor, Map buildCache) {
    }

    protected boolean shouldValidate(IResource resource, Map buildCache) {
        boolean validate = false;
        Set<IContainer> builtComponents = this.componentBuildCache(buildCache);
        Object woFolder = resource instanceof IFile ? resource.getParent() : (resource instanceof IContainer ? (IContainer)resource : null);
        if (woFolder != null && !builtComponents.contains(woFolder)) {
            validate = true;
            builtComponents.add((IContainer)woFolder);
        }
        return validate;
    }

    public void handleWebServerResources(IResource resource, IProgressMonitor monitor, Map buildCache) {
    }

    public void handleWoappResources(IResource resource, IProgressMonitor monitor, Map buildCache) {
        if (this._validateTemplatesNow) {
            try {
                IContainer folder;
                String fileExtension;
                boolean validate = false;
                if (resource instanceof IFile) {
                    if (resource.getParent().getName().endsWith(".wo")) {
                        IFile file = (IFile)resource;
                        String fileExtension2 = file.getFileExtension();
                        if ("wod".equals(fileExtension2)) {
                            validate = this.shouldValidate((IResource)file, buildCache);
                        } else if ("html".equals(fileExtension2)) {
                            validate = this.shouldValidate((IResource)file, buildCache);
                        } else if ("api".equals(fileExtension2)) {
                            validate = false;
                        } else if ("woo".equals(fileExtension2)) {
                            validate = this.shouldValidate((IResource)file, buildCache);
                        }
                    }
                } else if (resource instanceof IContainer && "wo".equals(fileExtension = (folder = (IContainer)resource).getFileExtension())) {
                    validate = this.shouldValidate((IResource)folder, buildCache);
                }
                if (validate) {
                    this.validateWodFile(resource, monitor);
                }
            }
            catch (Throwable e) {
                Activator.getDefault().log(e);
            }
        } else if (!this._validateTemplatesAtAll || this._buildKind == 6 || this._buildKind == 15) {
            IContainer folder;
            String fileExtension;
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                String fileExtension3 = file.getFileExtension();
                if ("wod".equals(fileExtension3)) {
                    WodModelUtils.deleteProblems(file);
                } else if ("html".equals(fileExtension3)) {
                    WodModelUtils.deleteProblems(file);
                } else if ("woo".equals(fileExtension3)) {
                    WodModelUtils.deleteProblems(file);
                }
            } else if (resource instanceof IContainer && "wo".equals(fileExtension = (folder = (IContainer)resource).getFileExtension())) {
                String componentName = folder.getName().substring(0, folder.getName().lastIndexOf(46));
                WodModelUtils.deleteProblems(folder.getFile((IPath)new Path(componentName + ".html")));
                WodModelUtils.deleteProblems(folder.getFile((IPath)new Path(componentName + ".wod")));
                WodModelUtils.deleteProblems(folder.getFile((IPath)new Path(componentName + ".woo")));
            }
        }
    }

    protected void validateWodFile(IResource resource, IProgressMonitor progressMonitor) {
        WodBuilder.validateComponent(resource, this._threadedBuild, progressMonitor);
    }

    public static void validateComponent(IResource resource, boolean threaded, IProgressMonitor progressMonitor) {
        if (threaded) {
            validationThreadPool.execute(new ValidatingComponent(resource, progressMonitor));
        } else {
            WodBuilder._validateComponent(resource, progressMonitor, true);
        }
    }

    public static void _validateComponent(IResource resource, IProgressMonitor progressMonitor, boolean showProgress) {
        if (resource != null) {
            String resourceName = resource.getName();
            if (progressMonitor != null && showProgress) {
                progressMonitor.subTask("Locating components for " + resourceName + " ...");
            }
            try {
                WodParserCache cache = WodParserCache.parser(resource);
                if (progressMonitor != null && cache.getWodEntry().getFile() != null && showProgress) {
                    progressMonitor.subTask("Building WO " + cache.getWodEntry().getFile().getName() + " ...");
                }
                cache.clearParserCache();
                cache.parse();
                cache.validate(true, false);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static {
        _validationJob = new ValidationProgressJob();
        validationThreadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    }

    public static class ValidatingComponent
    implements Runnable {
        private IResource _resource;
        private IProgressMonitor _monitor;

        public ValidatingComponent(IResource resource, IProgressMonitor monitor) {
            this._resource = resource;
            this._monitor = monitor;
        }

        public void run() {
            if (this._monitor == null || !this._monitor.isCanceled()) {
                _validationJob.start(this._resource);
                try {
                    WodBuilder._validateComponent(this._resource, this._monitor, false);
                }
                finally {
                    _validationJob.finish(this._resource);
                }
            }
        }
    }

    public static class ValidationProgressJob
    extends Job {
        private ConcurrentLinkedQueue<IResource> _validatingResources;
        private Object _lock = new Object();

        public ValidationProgressJob() {
            super("Component Validation");
            this.setPriority(30);
            this.setUser(false);
            this._validatingResources = new ConcurrentLinkedQueue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(IResource resource) {
            this._validatingResources.add(resource);
            WOHierarchyScope.incrementReferenceCountForProject((IProject)resource.getProject());
            Object object = this._lock;
            synchronized (object) {
                this._lock.notifyAll();
            }
            this.schedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish(IResource resource) {
            this._validatingResources.remove(resource);
            WOHierarchyScope.decrementReferenceCountForProject((IProject)resource.getProject());
            Object object = this._lock;
            synchronized (object) {
                this._lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = null;
            long completedAtStart = ((ThreadPoolExecutor)validationThreadPool).getCompletedTaskCount();
            while (!monitor.isCanceled() && status == null) {
                Object object = this._lock;
                synchronized (object) {
                    if (this._validatingResources.size() == 0) {
                        monitor.done();
                        status = Status.OK_STATUS;
                    } else {
                        this.setName("Component Validation");
                        try {
                            this._lock.wait();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this._validatingResources.size() <= 0 || monitor.isCanceled()) continue;
                monitor.beginTask("Validating ...", -1);
                StringBuffer sb = new StringBuffer();
                sb.append("Validating ");
                Iterator<IResource> resourceIter = this._validatingResources.iterator();
                while (resourceIter.hasNext()) {
                    IResource resource = resourceIter.next();
                    sb.append(resource.getName());
                    if (!resourceIter.hasNext()) continue;
                    sb.append(", ");
                }
                long taskCount = ((ThreadPoolExecutor)validationThreadPool).getTaskCount() - completedAtStart;
                long completedTaskCount = ((ThreadPoolExecutor)validationThreadPool).getCompletedTaskCount() - completedAtStart;
                sb.append(" (" + completedTaskCount + " of " + taskCount + ")");
                sb.append("...");
                monitor.setTaskName(sb.toString());
                monitor.beginTask(sb.toString(), (int)taskCount);
                monitor.worked((int)completedTaskCount);
            }
            return monitor.isCanceled() ? Status.CANCEL_STATUS : status;
        }
    }
}

