/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.completion;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.util.WodModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheEntry<T> {
    private WodParserCache _cache;
    private T _model;
    private IFile _file;
    private String _contents;
    private IDocument _document;
    private boolean _documentChanged;
    private long _lastParseTime;
    private boolean _validated;

    public AbstractCacheEntry(WodParserCache cache) {
        this._cache = cache;
        this.clear();
    }

    public WodParserCache getCache() {
        return this._cache;
    }

    public void deleteProblems() {
        if (this._file != null && this._file.exists()) {
            WodModelUtils.deleteProblems(this._file);
        }
    }

    public abstract void validate() throws Exception;

    public void _setModel(T model) {
        this._model = model;
    }

    public boolean isValidated() {
        return this._validated;
    }

    public void setValidated(boolean validated) {
        this._validated = validated;
    }

    public void setModel(T model) {
        this._model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getModel() throws Exception {
        WodParserCache wodParserCache = this.getCache();
        synchronized (wodParserCache) {
            T model = this._getModel();
            if (model == null) {
                this.getCache().parse();
                this.getCache().validate(false, true);
                model = this._getModel();
            }
            return model;
        }
    }

    public T _getModel() {
        return this._model;
    }

    public synchronized void setContents(String contents) {
        this._setContents(contents);
        this._setModel(null);
        this._file = null;
        this._document = null;
        this._documentChanged = true;
    }

    public void _setContents(String contents) {
        this._contents = contents;
    }

    public String getContents() {
        return this._contents;
    }

    public synchronized void setDocument(IDocument document) {
        this._document = document;
        this._documentChanged = true;
    }

    public void _setDocument(IDocument document) {
        this._document = document;
    }

    public IDocument getDocument() {
        return this._document;
    }

    public IFile getFile() {
        return this._file;
    }

    public void setFile(IFile file) {
        this._file = file;
    }

    protected abstract T _parse(String var1) throws Exception;

    protected String _process(String contents) {
        return contents;
    }

    protected synchronized T _parse(String contents, boolean updateCache) throws Exception {
        String processedContents = this._process(contents);
        if (updateCache) {
            this._contents = processedContents;
        }
        T model = this._parse(processedContents);
        if (updateCache) {
            this._setModel(model);
            this._documentChanged = false;
            this._validated = false;
            this.getCache()._setValidated(false);
        }
        return model;
    }

    public synchronized T parse(String contents, boolean updateCache) throws Exception {
        T model = this._parse(contents, updateCache);
        if (updateCache) {
            this._setModel(model);
            this._documentChanged = false;
            this._lastParseTime = System.currentTimeMillis();
            this._validated = false;
            this.getCache()._setValidated(false);
        }
        return model;
    }

    protected T _parse(IDocument document, boolean updateCache) throws Exception {
        T model = this._parse(document.get(), updateCache);
        return model;
    }

    public synchronized T parse(IDocument document, boolean updateCache) throws Exception {
        T model = this._parse(document, updateCache);
        if (updateCache) {
            this._setModel(model);
            this._documentChanged = false;
            if (this._file != null && this._file.exists()) {
                this._lastParseTime = this._file.getModificationStamp();
            }
            this._validated = false;
            this.getCache()._setValidated(false);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T _parse(IFile file, boolean updateCache) throws Exception {
        String contents;
        InputStream in = file.getContents();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                int len = 0;
                byte[] buf = new byte[8192];
                while ((len = in.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                contents = out.toString(file.getCharset());
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
        try {
            T model = this._parse(contents, updateCache);
            return model;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to parse '" + file + "'.", t);
        }
    }

    public synchronized T parse(IFile file, boolean updateCache) throws Exception {
        T model = this._parse(file, updateCache);
        if (updateCache) {
            this._file = file;
            this._setModel(model);
            if (file != null && file.exists()) {
                this._lastParseTime = file.getModificationStamp();
            }
            this._documentChanged = false;
        }
        return model;
    }

    public synchronized void clear() {
        this._setModel(null);
        this._lastParseTime = -1L;
    }

    public synchronized T parse() throws Exception {
        T model = null;
        this.clear();
        if (this._document != null) {
            model = this.parse(this._document, true);
        } else if (this._file != null && this._file.exists()) {
            model = this.parse(this._file, true);
        } else if (this._contents != null) {
            model = this.parse(this._contents, true);
        } else {
            model = null;
            this._setModel(null);
            this._contents = null;
            this._lastParseTime = -1L;
            this._documentChanged = false;
            this._validated = false;
            this.getCache()._setValidated(false);
        }
        return model;
    }

    public synchronized boolean shouldParse() {
        return this._documentChanged || this._file != null && (this._file.exists() && this._file.getModificationStamp() != this._lastParseTime || !this._file.exists() && this._lastParseTime > 0L);
    }
}

