/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.completion;

import java.util.LinkedList;
import java.util.List;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorEvent;
import jp.aonir.fuzzyxml.event.FuzzyXMLErrorListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Position;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.wod.HtmlElementCache;
import org.objectstyle.wolips.variables.BuildProperties;
import org.objectstyle.wolips.wodclipse.core.completion.AbstractCacheEntry;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.util.WodHtmlUtils;
import org.objectstyle.wolips.wodclipse.core.validation.HtmlProblem;
import org.objectstyle.wolips.wodclipse.core.validation.TemplateValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCacheEntry
extends AbstractCacheEntry<FuzzyXMLDocument>
implements FuzzyXMLErrorListener {
    private HtmlElementCache _htmlElementCache;
    private List<HtmlProblem> _parserProblems;

    public HtmlCacheEntry(WodParserCache cache) {
        super(cache);
    }

    public HtmlElementCache getHtmlElementCache() throws Exception {
        this.getCache().parse();
        this.getCache().validate(false, true);
        return this._htmlElementCache;
    }

    @Override
    public void validate() throws Exception {
        this.setValidated(true);
        IFile htmlFile = this.getFile();
        FuzzyXMLDocument htmlXmlDocument = (FuzzyXMLDocument)this._getModel();
        if (htmlXmlDocument != null && (htmlFile == null || htmlFile.exists())) {
            String htmlErrorsSeverity = Activator.getDefault().getPluginPreferences().getString("HtmlErrorsSeverityKey");
            if (!"ignore".equals(htmlErrorsSeverity) && htmlFile != null && htmlFile.exists()) {
                for (HtmlProblem problem : this.getParserProblems()) {
                    problem.createMarker(htmlFile, htmlErrorsSeverity);
                }
            }
            new TemplateValidator(this.getCache()).validate(htmlXmlDocument);
        }
    }

    @Override
    protected String _process(String contents) {
        String processedHtmlContents = contents;
        processedHtmlContents = processedHtmlContents.replaceAll("\r\n", " \n");
        processedHtmlContents = processedHtmlContents.replaceAll("\r", "\n");
        return processedHtmlContents;
    }

    @Override
    protected FuzzyXMLDocument _parse(String contents) {
        BuildProperties buildProperties = (BuildProperties)this.getCache().getProject().getAdapter(BuildProperties.class);
        FuzzyXMLParser parser = new FuzzyXMLParser(buildProperties != null ? buildProperties.isWellFormedTemplateRequired() : false, true);
        parser.addErrorListener((FuzzyXMLErrorListener)this);
        FuzzyXMLDocument htmlXmlDocument = parser.parse(contents);
        return htmlXmlDocument;
    }

    @Override
    public void clear() {
        super.clear();
        this._parserProblems = new LinkedList<HtmlProblem>();
        this._htmlElementCache = new HtmlElementCache();
    }

    public void error(FuzzyXMLErrorEvent event) {
        int offset = event.getOffset();
        int length = event.getLength();
        String message = event.getMessage();
        IFile htmlFile = this.getFile();
        String contents = this.getContents();
        HtmlProblem problem = new HtmlProblem(htmlFile, message, new Position(offset, length), WodHtmlUtils.getLineAtOffset(contents, offset), false);
        this._parserProblems.add(problem);
    }

    public List<HtmlProblem> getParserProblems() {
        return this._parserProblems;
    }
}

