/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.completion;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.PlatformUI;
import org.objectstyle.wolips.bindings.api.ApiCache;
import org.objectstyle.wolips.bindings.api.ApiUtils;
import org.objectstyle.wolips.bindings.api.Binding;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.api.Wo;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.BindingValueKey;
import org.objectstyle.wolips.bindings.wod.BindingValueKeyPath;
import org.objectstyle.wolips.bindings.wod.HtmlElementCache;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.core.resources.types.TypeNameCollector;
import org.objectstyle.wolips.wodclipse.core.completion.WodCompletionProposal;
import org.objectstyle.wolips.wodclipse.core.completion.WodDeprecatedCompletionProposal;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.AddActionDialog;
import org.objectstyle.wolips.wodclipse.core.refactoring.AddActionInfo;
import org.objectstyle.wolips.wodclipse.core.refactoring.AddKeyDialog;
import org.objectstyle.wolips.wodclipse.core.refactoring.AddKeyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WodCompletionUtils {
    public static void openBinding(String bindingValue, IApiBinding binding, IType componentType, boolean onlyIfMissing) throws CoreException {
        BindingValueKeyPath bindingValueKeyPath = new BindingValueKeyPath(bindingValue, componentType, componentType.getJavaProject(), WodParserCache.getTypeCache());
        if (bindingValueKeyPath.isValid()) {
            if (bindingValueKeyPath.exists()) {
                IMember member;
                if (!onlyIfMissing && (member = bindingValueKeyPath.getLastBindingKey().getBindingMember()) != null) {
                    JavaUI.openInEditor((IJavaElement)member, (boolean)true, (boolean)true);
                }
            } else if (bindingValueKeyPath.canAddKey()) {
                WodCompletionUtils.addKeyOrAction(bindingValueKeyPath, binding, componentType);
            }
        }
    }

    public static String addKeyOrAction(BindingValueKeyPath bindingValueKeyPath, IApiBinding binding, IType componentType) throws CoreException {
        String name = null;
        if (binding.isAction()) {
            AddActionInfo info = new AddActionInfo(componentType);
            info.setName(bindingValueKeyPath.getOriginalKeyPath());
            AddActionDialog.open(info, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            name = info.getName();
        } else {
            AddKeyInfo info = new AddKeyInfo(componentType);
            info.setName(bindingValueKeyPath.getOriginalKeyPath());
            AddKeyDialog.open(info, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            name = info.getName();
        }
        return name;
    }

    protected static boolean shouldSmartInsert() {
        return true;
    }

    public static void fillInElementNameCompletionProposals(Set<String> alreadyUsedElementNames, String token, int tokenOffset, int offset, Set<WodCompletionProposal> completionProposalsSet, boolean guessed, HtmlElementCache validElementNames) {
        String partialToken = WodCompletionUtils.partialToken(token, tokenOffset, offset).toLowerCase();
        for (String validElementName : validElementNames.elementNames()) {
            if (!validElementName.toLowerCase().startsWith(partialToken) || alreadyUsedElementNames.contains(validElementName)) continue;
            WodCompletionProposal completionProposal = WodCompletionUtils.shouldSmartInsert() && guessed ? new WodCompletionProposal(token, tokenOffset, offset, validElementName + " : ", validElementName, validElementName.length() + 3) : new WodCompletionProposal(token, tokenOffset, offset, validElementName);
            completionProposalsSet.add(completionProposal);
        }
    }

    public static void fillInElementTypeCompletionProposals(IJavaProject project, String token, int tokenOffset, int offset, Set<WodCompletionProposal> completionProposalsSet, boolean guessed, IProgressMonitor progressMonitor) throws JavaModelException {
        String partialToken = WodCompletionUtils.partialToken(token, tokenOffset, offset);
        if (partialToken.length() > 0) {
            TypeNameCollector typeNameCollector = new TypeNameCollector(project, false);
            BindingReflectionUtils.findMatchingElementClassNames((String)partialToken, (int)1, (TypeNameCollector)typeNameCollector, (IProgressMonitor)progressMonitor);
            boolean includePackageName = token.indexOf(46) != -1;
            Iterator matchingElementClassNamesIter = typeNameCollector.typeNames();
            while (matchingElementClassNamesIter.hasNext()) {
                String matchingElementTypeName = (String)matchingElementClassNamesIter.next();
                String elementTypeName = includePackageName ? matchingElementTypeName : BindingReflectionUtils.getShortClassName((String)matchingElementTypeName);
                IType type = typeNameCollector.getTypeForClassName(matchingElementTypeName);
                WodCompletionProposal completionProposal = WodCompletionUtils.shouldSmartInsert() && guessed ? (BindingReflectionUtils.memberIsDeprecated((IMember)type) ? new WodDeprecatedCompletionProposal(token, tokenOffset, offset, elementTypeName + " {\n\t\n}", elementTypeName, elementTypeName.length() + 4) : new WodCompletionProposal(token, tokenOffset, offset, elementTypeName + " {\n\t\n}", elementTypeName, elementTypeName.length() + 4)) : (BindingReflectionUtils.memberIsDeprecated((IMember)type) ? new WodDeprecatedCompletionProposal(token, tokenOffset, offset, elementTypeName) : new WodCompletionProposal(token, tokenOffset, offset, elementTypeName));
                completionProposalsSet.add(completionProposal);
            }
        }
    }

    public static void fillInBindingNameCompletionProposals(IJavaProject project, IType elementType, String token, int tokenOffset, int offset, Set<WodCompletionProposal> completionProposalsSet, boolean guessed, TypeCache cache) throws JavaModelException {
        String partialToken = WodCompletionUtils.partialToken(token, tokenOffset, offset);
        boolean showReflectionBindings = true;
        try {
            Wo wo = ApiUtils.findApiModelWo((IType)elementType, (ApiCache)cache.getApiCache(project));
            if (wo != null) {
                String lowercasePartialToken = partialToken.toLowerCase();
                List bindings = wo.getBindings();
                for (Binding binding : bindings) {
                    String bindingName = binding.getName();
                    String lowercaseBindingName = bindingName.toLowerCase();
                    if (!lowercaseBindingName.startsWith(lowercasePartialToken)) continue;
                    WodCompletionProposal completionProposal = WodCompletionUtils.shouldSmartInsert() && guessed ? new WodCompletionProposal(token, tokenOffset, offset, bindingName + " = ", bindingName, bindingName.length() + 3) : new WodCompletionProposal(token, tokenOffset, offset, bindingName);
                    completionProposalsSet.add(completionProposal);
                }
                if (bindings != null && bindings.size() > 0) {
                    showReflectionBindings = false;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (showReflectionBindings) {
            List bindingKeys = BindingReflectionUtils.getBindingKeys((IJavaProject)project, (IType)elementType, (String)partialToken, (boolean)false, (int)1, (boolean)false, (TypeCache)cache);
            WodCompletionUtils._fillInCompletionProposals(bindingKeys, token, tokenOffset, offset, completionProposalsSet, false);
        }
    }

    public static boolean fillInBindingValueCompletionProposals(IJavaProject project, IType elementType, String token, int tokenOffset, int offset, Set<WodCompletionProposal> completionProposalsSet, TypeCache cache) throws JavaModelException {
        boolean checkBindingType = false;
        String partialToken = WodCompletionUtils.partialToken(token, tokenOffset, offset);
        BindingValueKeyPath bindingKeyPath = new BindingValueKeyPath(partialToken, elementType, project, cache);
        List possibleBindingKeyMatchesList = bindingKeyPath.getPartialMatchesForLastBindingKey(false);
        if (possibleBindingKeyMatchesList != null) {
            String bindingKeyName = bindingKeyPath.getOperator() != null ? "@" + bindingKeyPath.getOperator() : bindingKeyPath.getLastBindingKeyName();
            WodCompletionUtils._fillInCompletionProposals(possibleBindingKeyMatchesList, bindingKeyName, tokenOffset + partialToken.lastIndexOf(46) + 1, offset, completionProposalsSet, true);
        }
        if (bindingKeyPath != null && bindingKeyPath.getLength() == 1) {
            checkBindingType = true;
        }
        return checkBindingType;
    }

    public static String partialToken(String token, int tokenOffset, int offset) {
        int partialIndex = offset - tokenOffset;
        String partialToken = partialIndex > token.length() ? token : token.substring(0, offset - tokenOffset);
        return partialToken;
    }

    protected static void _fillInCompletionProposals(List<BindingValueKey> bindingKeys, String token, int tokenOffset, int offset, Set<WodCompletionProposal> completionProposalsSet, boolean showUsefulSystemBindings) {
        for (BindingValueKey bindingKey : BindingReflectionUtils.filterSystemBindingValueKeys(bindingKeys, (boolean)showUsefulSystemBindings)) {
            WodCompletionProposal completionProposal = BindingReflectionUtils.bindingPointsToDeprecatedValue((BindingValueKey)bindingKey) ? new WodDeprecatedCompletionProposal(token, tokenOffset, offset, bindingKey.getBindingName()) : new WodCompletionProposal(token, tokenOffset, offset, bindingKey.getBindingName());
            completionProposalsSet.add(completionProposal);
        }
    }
}

