/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.document;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.objectstyle.wolips.bindings.wod.AbstractWodBinding;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.parser.RulePosition;

public class DocumentWodBinding
extends AbstractWodBinding {
    private RulePosition _namespace;
    private RulePosition _name;
    private RulePosition _valueNamespace;
    private RulePosition _value;
    private int _lineNumber;

    public DocumentWodBinding(RulePosition namespace, RulePosition name, RulePosition valueNamespace, RulePosition value) {
        this._namespace = namespace;
        this._name = name;
        this._valueNamespace = valueNamespace;
        this._value = value;
        this._lineNumber = -1;
    }

    public RulePosition getNamespaceRulePosition() {
        return this._namespace;
    }

    public RulePosition getNameRulePosition() {
        return this._name;
    }

    public String getNamespace() {
        return this._namespace == null ? null : this._namespace._getTextWithoutException();
    }

    public Position getNamespacePosition() {
        return this._namespace == null ? null : this._namespace.getPosition();
    }

    public String getName() {
        return this._name._getTextWithoutException();
    }

    public Position getNamePosition() {
        return this._name.getPosition();
    }

    public String getValueNamespace() {
        return this._valueNamespace == null ? null : this._valueNamespace._getTextWithoutException();
    }

    public Position getValueNamespacePosition() {
        return this._valueNamespace == null ? null : this._valueNamespace.getPosition();
    }

    public String getValue() {
        return this._value._getTextWithoutException();
    }

    public Position getValuePosition() {
        return this._value.getPosition();
    }

    public int getStartOffset() {
        int startOffset = this._namespace == null ? this._name.getTokenOffset() : this._namespace.getTokenEndOffset();
        return startOffset;
    }

    public int getEndOffset() {
        return this._value.getTokenEndOffset();
    }

    public int getLineNumber() {
        int lineNumber = this._lineNumber;
        if (lineNumber == -1) {
            try {
                lineNumber = this._name.getDocument().getLineOfOffset(this.getStartOffset());
            }
            catch (BadLocationException e) {
                Activator.getDefault().log(e);
            }
        }
        return lineNumber;
    }
}

