/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.document;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.objectstyle.wolips.bindings.wod.AbstractWodModel;
import org.objectstyle.wolips.bindings.wod.IWodBinding;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.bindings.wod.IWodUnit;
import org.objectstyle.wolips.bindings.wod.SimpleWodElement;
import org.objectstyle.wolips.bindings.wod.WodElementProblem;
import org.objectstyle.wolips.bindings.wod.WodProblem;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.completion.WodCacheEntry;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.DocumentWodBinding;
import org.objectstyle.wolips.wodclipse.core.document.DocumentWodElement;
import org.objectstyle.wolips.wodclipse.core.parser.AssignmentOperatorWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.BindingNameRule;
import org.objectstyle.wolips.wodclipse.core.parser.BindingValueNamespaceRule;
import org.objectstyle.wolips.wodclipse.core.parser.BindingValueRule;
import org.objectstyle.wolips.wodclipse.core.parser.CloseDefinitionWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.ElementNameRule;
import org.objectstyle.wolips.wodclipse.core.parser.ElementTypeOperatorWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.ElementTypeRule;
import org.objectstyle.wolips.wodclipse.core.parser.EndAssignmentWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.ICommentRule;
import org.objectstyle.wolips.wodclipse.core.parser.OpenDefinitionWordDetector;
import org.objectstyle.wolips.wodclipse.core.parser.RulePosition;
import org.objectstyle.wolips.wodclipse.core.parser.StringLiteralRule;
import org.objectstyle.wolips.wodclipse.core.parser.WOOGNLRule;
import org.objectstyle.wolips.wodclipse.core.parser.WodScanner;

public class DocumentWodModel
extends AbstractWodModel {
    private IFile _wodFile;
    private IDocument _document;

    public DocumentWodModel(IFile wodFile, IDocument document) {
        this._wodFile = wodFile;
        this._document = document;
        this.parse();
    }

    public IDocument getDocument() {
        return this._document;
    }

    public void addParseProblem(IWodElement element, String message, RulePosition rulePosition, boolean warning) {
        Position position = rulePosition.getPosition();
        try {
            int lineNumber = this._document.getLineOfOffset(position.getOffset());
            Object problem = element != null ? new WodElementProblem(element, message, position, lineNumber, warning) : new WodProblem(message, position, lineNumber, warning);
            this.addParseProblem((WodProblem)problem);
        }
        catch (BadLocationException e) {
            Activator.getDefault().log(e);
        }
    }

    protected synchronized void parse() {
        RulePosition rulePosition;
        this.clear();
        WodScanner scanner = WodScanner.wodScannerForDocument(this._document);
        DocumentWodBinding lastBinding = null;
        DocumentWodElement element = null;
        RulePosition tentativeElementName = null;
        RulePosition savedRulePosition = null;
        RulePosition savedRulePosition2 = null;
        RulePosition savedRulePosition3 = null;
        RulePosition lastRulePosition = null;
        ForgivingStack<RulePosition> rulePositions = new ForgivingStack<RulePosition>();
        while ((rulePosition = scanner.nextRulePosition()) != null) {
            boolean whitespace = false;
            boolean comment = false;
            if (RulePosition.isRulePositionOfType(rulePosition, WhitespaceRule.class)) {
                whitespace = true;
            } else if (RulePosition.isRulePositionOfType(rulePosition, ICommentRule.class)) {
                comment = true;
                if (lastBinding != null) {
                    String commentText = rulePosition._getTextWithoutException();
                    if (commentText != null && commentText.startsWith("//") && "VALID".equalsIgnoreCase(commentText = commentText.substring(2).trim())) {
                        lastBinding.setValidate(false);
                    }
                } else {
                    String commentText = rulePosition._getTextWithoutException();
                    if (commentText != null && commentText.startsWith("//") && (commentText = commentText.substring(2).trim()).toLowerCase().startsWith("inherit ")) {
                        String componentName = commentText.substring("inherit ".length()).trim();
                        try {
                            WodParserCache inheritCache = WodParserCache.parser(this._wodFile.getProject(), componentName);
                            WodCacheEntry wodCacheEntry = inheritCache.getWodEntry();
                            IWodModel parentWodModel = (IWodModel)wodCacheEntry.getModel();
                            for (IWodElement parentWodElement : parentWodModel.getElements()) {
                                SimpleWodElement inheritedWodElement = new SimpleWodElement(parentWodElement);
                                inheritedWodElement.setInherited(true);
                                this.addElement((IWodElement)inheritedWodElement);
                            }
                        }
                        catch (Throwable t) {
                            this.addParseProblem((IWodElement)element, "WOD inheritance of '" + componentName + "' failed: " + t.getMessage() + ".", rulePosition, false);
                        }
                    }
                }
            } else if (RulePosition.isRulePositionOfType(rulePosition, ElementNameRule.class)) {
                if (RulePosition.isOperatorOfType(lastRulePosition, OpenDefinitionWordDetector.class) || RulePosition.isOperatorOfType(lastRulePosition, EndAssignmentWordDetector.class)) {
                    savedRulePosition2 = rulePosition;
                    if (lastRulePosition != null && !RulePosition.isOperatorOfType(lastRulePosition, CloseDefinitionWordDetector.class)) {
                        tentativeElementName = rulePosition;
                    }
                } else {
                    if (lastRulePosition != null && !RulePosition.isOperatorOfType(lastRulePosition, CloseDefinitionWordDetector.class)) {
                        this.addParseProblem((IWodElement)element, "The element name '" + rulePosition._getTextWithoutException() + "' must start a WOD declaration", rulePosition, false);
                    }
                    savedRulePosition = rulePosition;
                    element = null;
                }
            } else if (RulePosition.isOperatorOfType(rulePosition, ElementTypeOperatorWordDetector.class)) {
                if (!RulePosition.isRulePositionOfType(lastRulePosition, ElementNameRule.class) && !RulePosition.isRulePositionOfType(lastRulePosition, BindingValueNamespaceRule.class)) {
                    this.addParseProblem((IWodElement)element, "A ':' can only appear after an element name or a binding value namespace.", rulePosition, false);
                }
            } else if (RulePosition.isRulePositionOfType(rulePosition, ElementTypeRule.class)) {
                if (tentativeElementName != null) {
                    this.addParseProblem((IWodElement)element, "The element name ' " + tentativeElementName._getTextWithoutException() + "' must start a WOD declaration", tentativeElementName, false);
                    tentativeElementName = null;
                    savedRulePosition = null;
                } else if (!RulePosition.isOperatorOfType(lastRulePosition, ElementTypeOperatorWordDetector.class)) {
                    this.addParseProblem((IWodElement)element, "The element type '" + rulePosition._getTextWithoutException() + "' can only appear after a ':'", rulePosition, false);
                } else {
                    rulePositions.clear();
                    element = new DocumentWodElement(savedRulePosition, rulePosition);
                    this.addElement((IWodElement)element);
                    savedRulePosition = null;
                }
            } else if (RulePosition.isOperatorOfType(rulePosition, OpenDefinitionWordDetector.class)) {
                if (!RulePosition.isRulePositionOfType(lastRulePosition, ElementTypeRule.class)) {
                    this.addParseProblem((IWodElement)element, "A '{' can only appear after an element type", rulePosition, false);
                }
            } else if (RulePosition.isRulePositionOfType(rulePosition, WOOGNLRule.class)) {
                boolean ognlIsName;
                boolean ognlIsValue = RulePosition.isOperatorOfType(lastRulePosition, AssignmentOperatorWordDetector.class);
                boolean bl = ognlIsName = !ognlIsValue && (RulePosition.isOperatorOfType(lastRulePosition, EndAssignmentWordDetector.class) || RulePosition.isOperatorOfType(lastRulePosition, OpenDefinitionWordDetector.class));
                if (!ognlIsValue && !ognlIsName) {
                    this.addParseProblem((IWodElement)element, "The OGNL value " + rulePosition._getTextWithoutException() + " can only appear after a '{', '=', or ';'.", rulePosition, false);
                    savedRulePosition = null;
                } else if (ognlIsName) {
                    savedRulePosition = rulePosition;
                } else if (ognlIsValue) {
                    lastBinding = this.addBinding(element, savedRulePosition2, savedRulePosition, null, rulePosition, scanner);
                    savedRulePosition = null;
                    savedRulePosition2 = null;
                    savedRulePosition3 = null;
                }
            } else if (RulePosition.isRulePositionOfType(rulePosition, StringLiteralRule.class)) {
                boolean literalIsName;
                boolean literalIsValue = RulePosition.isOperatorOfType(lastRulePosition, AssignmentOperatorWordDetector.class);
                boolean bl = literalIsName = !literalIsValue && (RulePosition.isOperatorOfType((RulePosition)rulePositions.peek(), EndAssignmentWordDetector.class) || RulePosition.isOperatorOfType((RulePosition)rulePositions.peek(), OpenDefinitionWordDetector.class));
                if (!literalIsValue && !literalIsName) {
                    this.addParseProblem((IWodElement)element, "The string literal '" + rulePosition._getTextWithoutException() + "' can only appear after a '{', '=', or ';'.", rulePosition, false);
                    savedRulePosition = null;
                } else if (literalIsName) {
                    savedRulePosition = rulePosition;
                } else if (literalIsValue) {
                    lastBinding = this.addBinding(element, savedRulePosition2, savedRulePosition, null, rulePosition, scanner);
                    savedRulePosition = null;
                    savedRulePosition2 = null;
                    savedRulePosition3 = null;
                }
                tentativeElementName = null;
            } else if (RulePosition.isRulePositionOfType(rulePosition, BindingNameRule.class)) {
                if (!(RulePosition.isOperatorOfType(lastRulePosition, OpenDefinitionWordDetector.class) || RulePosition.isOperatorOfType(lastRulePosition, EndAssignmentWordDetector.class) || RulePosition.isOperatorOfType(lastRulePosition, ElementTypeOperatorWordDetector.class))) {
                    this.addParseProblem((IWodElement)element, "The binding name '" + rulePosition._getTextWithoutException() + "' can only appear after a '{' or a ';'", rulePosition, false);
                }
                savedRulePosition = rulePosition;
                lastBinding = null;
            } else if (RulePosition.isOperatorOfType(rulePosition, AssignmentOperatorWordDetector.class)) {
                if (!RulePosition.isRulePositionOfType(lastRulePosition, BindingNameRule.class) && !RulePosition.isRulePositionOfType(lastRulePosition, StringLiteralRule.class)) {
                    this.addParseProblem((IWodElement)element, "An '=' can only appear after a binding name", rulePosition, false);
                }
            } else if (RulePosition.isRulePositionOfType(rulePosition, BindingValueNamespaceRule.class)) {
                if (!RulePosition.isOperatorOfType(lastRulePosition, AssignmentOperatorWordDetector.class)) {
                    this.addParseProblem((IWodElement)element, "The binding value namespace '" + rulePosition._getTextWithoutException() + "' can only appear after an '='", rulePosition, false);
                } else {
                    savedRulePosition3 = rulePosition;
                }
            } else if (RulePosition.isRulePositionOfType(rulePosition, BindingValueRule.class)) {
                if (!(RulePosition.isOperatorOfType(lastRulePosition, AssignmentOperatorWordDetector.class) || RulePosition.isOperatorOfType(lastRulePosition, ElementTypeOperatorWordDetector.class) && RulePosition.isRulePositionOfType(savedRulePosition3, BindingValueNamespaceRule.class))) {
                    this.addParseProblem((IWodElement)element, "The binding value '" + rulePosition._getTextWithoutException() + "' can only appear after an '=' or a 'xxx:'", rulePosition, false);
                } else {
                    lastBinding = this.addBinding(element, savedRulePosition2, savedRulePosition, savedRulePosition3, rulePosition, scanner);
                }
                savedRulePosition = null;
                savedRulePosition2 = null;
                savedRulePosition3 = null;
            } else if (RulePosition.isOperatorOfType(rulePosition, EndAssignmentWordDetector.class)) {
                if (!(RulePosition.isRulePositionOfType(lastRulePosition, BindingValueRule.class) || RulePosition.isRulePositionOfType(lastRulePosition, StringLiteralRule.class) || RulePosition.isRulePositionOfType(lastRulePosition, WOOGNLRule.class))) {
                    this.addParseProblem((IWodElement)element, "A ';' can only appear after a binding value", rulePosition, false);
                }
            } else if (RulePosition.isOperatorOfType(rulePosition, CloseDefinitionWordDetector.class)) {
                if (element != null) {
                    element.setEndOffset(rulePosition.getTokenOffset() + 1);
                }
                if (!(RulePosition.isOperatorOfType(lastRulePosition, OpenDefinitionWordDetector.class) || RulePosition.isOperatorOfType(lastRulePosition, EndAssignmentWordDetector.class) || RulePosition.isRulePositionOfType(lastRulePosition, BindingValueRule.class) || RulePosition.isRulePositionOfType(lastRulePosition, StringLiteralRule.class) || RulePosition.isRulePositionOfType(lastRulePosition, WOOGNLRule.class))) {
                    this.addParseProblem((IWodElement)element, "A '}' can only appear after a ';' or a '{'", rulePosition, false);
                } else {
                    element = null;
                }
                lastBinding = null;
            } else {
                this.addParseProblem((IWodElement)element, "'" + rulePosition._getTextWithoutException() + "' is an unknown keyword", rulePosition, false);
            }
            if (whitespace || comment) continue;
            lastRulePosition = rulePosition;
            rulePositions.push(rulePosition);
        }
        if (lastRulePosition != null && !RulePosition.isOperatorOfType(lastRulePosition, CloseDefinitionWordDetector.class)) {
            this.addParseProblem((IWodElement)element, "The last entry in a WOD file must be a '}'.", lastRulePosition, false);
        }
    }

    protected DocumentWodBinding addBinding(DocumentWodElement element, RulePosition namespaceRulePosition, RulePosition nameRulePosition, RulePosition valueNamespaceRulePosition, RulePosition valueRulePosition, WodScanner scanner) {
        DocumentWodBinding binding = null;
        if (element == null) {
            this.addParseProblem((IWodElement)element, "A binding must appear in a declaration", valueRulePosition, false);
        } else if (nameRulePosition == null) {
            this.addParseProblem((IWodElement)element, "A binding must have a name", valueRulePosition, false);
        } else if (valueRulePosition == null) {
            this.addParseProblem((IWodElement)element, "A binding must have a value", valueRulePosition, false);
        } else {
            binding = new DocumentWodBinding(namespaceRulePosition, nameRulePosition, valueNamespaceRulePosition, valueRulePosition);
            element.addBinding((IWodBinding)binding);
        }
        return binding;
    }

    public String getName() {
        return this._wodFile.getName();
    }

    public IFile getWodFile() {
        return this._wodFile;
    }

    public int getStartOffset() {
        return 0;
    }

    public int getEndOffset() {
        return this._document.getLength();
    }

    public IWodElement getWodElementAtIndex(int index) {
        IWodElement elementAtIndex = null;
        Iterator elementsIter = this.getElements().iterator();
        while (elementAtIndex == null && elementsIter.hasNext()) {
            IWodElement element = (IWodElement)elementsIter.next();
            if (!this.isIndexContainedByWodUnit(index, (IWodUnit)element)) continue;
            elementAtIndex = element;
        }
        return elementAtIndex;
    }

    public IWodUnit getWodUnitAtIndex(int index) {
        DocumentWodModel wodUnit = null;
        IWodElement elementAtIndex = this.getWodElementAtIndex(index);
        if (elementAtIndex != null) {
            Iterator bindingsIter = elementAtIndex.getBindings().iterator();
            while (wodUnit == null && bindingsIter.hasNext()) {
                IWodBinding binding = (IWodBinding)bindingsIter.next();
                if (!this.isIndexContainedByWodUnit(index, (IWodUnit)binding)) continue;
                wodUnit = binding;
            }
            if (wodUnit == null) {
                wodUnit = elementAtIndex;
            }
        }
        if (wodUnit == null) {
            wodUnit = this;
        }
        return wodUnit;
    }

    protected boolean isIndexContainedByWodUnit(int index, IWodUnit wodUnit) {
        return index >= wodUnit.getStartOffset() && index <= wodUnit.getEndOffset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ForgivingStack<T> {
        private List<T> _contents = new LinkedList<T>();

        public void push(T obj) {
            this._contents.add(0, obj);
        }

        public void clear() {
            this._contents.clear();
        }

        public T peek() {
            return this.peek(0);
        }

        public T peek(int offset) {
            T obj = null;
            if (this._contents.size() > offset) {
                obj = this._contents.get(offset);
            }
            return obj;
        }
    }
}

