/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.core.CreateFieldOperation;
import org.eclipse.jdt.internal.core.CreateImportOperation;
import org.eclipse.jdt.internal.core.CreateMethodOperation;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.ui.IEditorPart;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.wodclipse.core.refactoring.AddKeyInfo;

public class AddKeyOperation
extends JavaModelOperation {
    private boolean _force = false;
    private AddKeyInfo _info;
    private IJavaElement _sibling;

    public static void addKey(AddKeyInfo info) throws CoreException {
        IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)info.getComponentType().getCompilationUnit());
        if (editorPart != null) {
            IRewriteTarget target = (IRewriteTarget)editorPart.getAdapter(IRewriteTarget.class);
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                new AddKeyOperation(info).run(null);
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceField(AddKeyInfo info, String originalName) throws CoreException {
        IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)info.getComponentType().getCompilationUnit());
        if (editorPart != null) {
            IRewriteTarget target = (IRewriteTarget)editorPart.getAdapter(IRewriteTarget.class);
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                String newName = info.getName();
                info.setName(originalName);
                String originalFieldName = info.getFieldName();
                info.setName(newName);
                IField originalField = info.getComponentType().getField(originalFieldName);
                if (info.isCreateField() && originalField.exists()) {
                    AddKeyOperation op = new AddKeyOperation(info);
                    op._sibling = originalField;
                    op._force = true;
                    op.run(null);
                    originalField.delete(false, null);
                }
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
    }

    public AddKeyOperation(AddKeyInfo info) {
        super(new IJavaElement[]{info.getComponentType()});
        this._info = info;
    }

    private void createAccessor(String simpleTypeName, String fieldName) throws JavaModelException {
        boolean isBoolean = BindingReflectionUtils.isBoolean((String)this._info.getJavaTypeName());
        IType componentType = this.getComponentType();
        String accessorMethodName = this._info.isPrependGetToAccessorMethod() ? NamingConventions.suggestGetterName((IJavaProject)componentType.getJavaProject(), (String)fieldName, (int)1, (boolean)isBoolean, null) : this._info.getName();
        String source = null;
        if (this._info.isCreateField()) {
            try {
                source = GetterSetterUtil.getGetterStub((IField)componentType.getField(fieldName), (String)accessorMethodName, (boolean)true, (int)1);
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        } else {
            source = "public " + simpleTypeName + " " + accessorMethodName + "() {\n // TODO\nreturn null;\n}";
        }
        if (source != null) {
            String lineDelim = "\n";
            source = CodeFormatterUtil.format((int)4, (String)source, (int)1, null, (IJavaProject)componentType.getJavaProject());
            new CreateMethodOperation(componentType, source, false).runOperation(this.progressMonitor);
        }
    }

    private void createField(String simpleTypeName, String fieldName) throws JavaModelException {
        IType componentType = this.getComponentType();
        String accessModifier = "private ";
        if (!this._info.isCreateAccessorMethod() && !this._info.isCreateMutatorMethod()) {
            accessModifier = "public ";
        }
        String keyField = accessModifier + simpleTypeName + " " + fieldName + ";";
        CreateFieldOperation op = new CreateFieldOperation(componentType, keyField, this._force);
        if (this._sibling != null) {
            op.createAfter(this._sibling);
        }
        op.runOperation(this.progressMonitor);
    }

    private void createImports(String keyType, String keyParameterType) throws JavaModelException {
        if (BindingReflectionUtils.isImportRequired((String)keyType)) {
            new CreateImportOperation(keyType, this.getCompilationUnit(), 0).runOperation(this.progressMonitor);
        }
        if (BindingReflectionUtils.isImportRequired((String)keyParameterType)) {
            new CreateImportOperation(keyParameterType, this.getCompilationUnit(), 0).runOperation(this.progressMonitor);
        }
    }

    private void createMutator(String simpleTypeName, String fieldName) throws JavaModelException {
        boolean isBoolean = BindingReflectionUtils.isBoolean((String)this._info.getJavaTypeName());
        IType componentType = this.getComponentType();
        String mutatorMethodName = NamingConventions.suggestSetterName((IJavaProject)this.getJavaProject(), (String)fieldName, (int)1, (boolean)isBoolean, null);
        String source = null;
        if (this._info.isCreateField()) {
            try {
                source = GetterSetterUtil.getSetterStub((IField)componentType.getField(fieldName), (String)mutatorMethodName, (boolean)true, (int)1);
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        } else {
            source = "public void " + mutatorMethodName + "(" + simpleTypeName + " " + this._info.getName() + ") {\n // TODO\n}";
        }
        if (source != null) {
            String lineDelim = "\n";
            source = CodeFormatterUtil.format((int)4, (String)source, (int)1, null, (IJavaProject)this.getJavaProject());
            new CreateMethodOperation(componentType, source, false).runOperation(this.progressMonitor);
        }
    }

    protected void executeOperation() throws JavaModelException {
        String keyType = this._info.getJavaTypeName();
        String keyParameterType = this._info.getJavaParameterTypeName();
        String simpleTypeName = this.simpleTypeName(keyType, keyParameterType);
        String fieldName = this._info.getFieldName();
        this.createImports(keyType, keyParameterType);
        if (this._info.isCreateField()) {
            this.createField(simpleTypeName, fieldName);
        }
        if (this._info.isCreateAccessorMethod()) {
            this.createAccessor(simpleTypeName, fieldName);
        }
        if (this._info.isCreateMutatorMethod()) {
            this.createMutator(simpleTypeName, fieldName);
        }
    }

    private ICompilationUnit getCompilationUnit() {
        return this._info.getComponentType().getCompilationUnit();
    }

    private IType getComponentType() {
        return this._info.getComponentType();
    }

    private IJavaProject getJavaProject() {
        return this._info.getComponentType().getJavaProject();
    }

    private String simpleTypeName(String keyType, String keyParameterType) {
        boolean useGenerics = JavaModelUtil.is50OrHigher((IJavaProject)this.getJavaProject());
        String simpleTypeName = keyParameterType != null && useGenerics ? Signature.getSimpleName((String)keyType) + "<" + Signature.getSimpleName((String)keyParameterType) + ">" : Signature.getSimpleName((String)keyType);
        return simpleTypeName;
    }
}

