/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.util;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.part.FileEditorInput;
import org.objectstyle.wolips.baseforplugins.util.ComparisonUtils;
import org.objectstyle.wolips.bindings.api.ApiModelException;
import org.objectstyle.wolips.bindings.api.IApiBinding;
import org.objectstyle.wolips.bindings.wod.ApiBindingValidationProblem;
import org.objectstyle.wolips.bindings.wod.ApiElementValidationProblem;
import org.objectstyle.wolips.bindings.wod.HtmlElementCache;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.bindings.wod.WodBindingProblem;
import org.objectstyle.wolips.bindings.wod.WodProblem;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.DocumentWodModel;
import org.objectstyle.wolips.wodclipse.core.document.WodFileDocumentProvider;
import org.objectstyle.wolips.wodclipse.core.woo.WooModel;
import org.objectstyle.wolips.wodclipse.core.woo.WooModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WodModelUtils {
    public static IWodModel createWodModel(IFile wodFile, IDocument wodDocument) {
        return new DocumentWodModel(wodFile, wodDocument);
    }

    public static WooModel createWooModel(IDocument wooDocument) throws WooModelException {
        return new WooModel(wooDocument.get());
    }

    public static WooModel createWooModel(IFile wooFile) {
        return new WooModel(wooFile);
    }

    public static void deleteProblems(IFile wodFile) {
        try {
            if (wodFile.exists()) {
                wodFile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().debug(e);
        }
    }

    public static List<WodProblem> getProblems(IWodElement wodElement, WodParserCache cache) throws Exception {
        return WodModelUtils.getProblems(wodElement, cache.getComponentsLocateResults(), WodParserCache.getTypeCache(), cache.getHtmlEntry().getHtmlElementCache());
    }

    public static List<WodProblem> getProblems(IWodElement wodElement, LocalizedComponentsLocateResult locateResult, TypeCache typeCache, HtmlElementCache htmlCache) throws CoreException, IOException, ApiModelException {
        IFile wodFile;
        LinkedList<WodProblem> problems = new LinkedList<WodProblem>();
        if (wodElement != null && (wodFile = locateResult.getFirstWodFile()) != null) {
            IJavaProject javaProject = JavaCore.create((IProject)wodFile.getProject());
            wodElement.fillInProblems(javaProject, locateResult.getDotJavaType(), true, problems, typeCache, htmlCache);
        }
        return problems;
    }

    public static List<WodProblem> getProblems(IWodModel wodModel, WodParserCache cache) throws Exception {
        return WodModelUtils.getProblems(wodModel, cache.getComponentsLocateResults(), WodParserCache.getTypeCache(), cache.getHtmlEntry().getHtmlElementCache());
    }

    public static List<WodProblem> getProblems(IWodModel wodModel, LocalizedComponentsLocateResult locateResult, TypeCache typeCache, HtmlElementCache htmlCache) throws CoreException, IOException, ApiModelException {
        IFile wodFile;
        LinkedList<WodProblem> problems = new LinkedList<WodProblem>();
        if (wodModel != null && (wodFile = locateResult.getFirstWodFile()) != null) {
            IJavaProject javaProject = JavaCore.create((IProject)wodFile.getProject());
            wodModel.fillInProblems(javaProject, locateResult.getDotJavaType(), true, problems, typeCache, htmlCache);
        }
        return problems;
    }

    public static void validateWodDocument(IDocument wodDocument, LocalizedComponentsLocateResult locateResult, TypeCache typeCache, HtmlElementCache htmlCache) {
        try {
            IFile wodFile = locateResult.getFirstWodFile();
            if (wodFile != null) {
                WodModelUtils.deleteProblems(wodFile);
                IJavaProject javaProject = JavaCore.create((IProject)wodFile.getProject());
                IWodModel wodModel = WodModelUtils.createWodModel(wodFile, wodDocument);
                List problems = wodModel.getProblems(javaProject, locateResult.getDotJavaType(), typeCache, htmlCache);
                for (WodProblem problem : problems) {
                    WodModelUtils.createMarker(wodFile, problem);
                }
            }
        }
        catch (Exception e) {
            Activator.getDefault().log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateWodFile(IFile wodFile, LocalizedComponentsLocateResult locateResults, TypeCache typeCache, HtmlElementCache htmlCache) throws CoreException {
        FileEditorInput input = new FileEditorInput(wodFile);
        WodFileDocumentProvider provider = new WodFileDocumentProvider();
        provider.connect(input);
        try {
            IDocument document = provider.getDocument(input);
            WodModelUtils.validateWodDocument(document, locateResults, typeCache, htmlCache);
        }
        finally {
            provider.disconnect(input);
        }
    }

    public static IMarker createMarker(IFile file, WodProblem wodProblem) {
        if (file == null) {
            return null;
        }
        Position problemPosition = wodProblem.getPosition();
        IMarker marker = null;
        try {
            marker = wodProblem.getForceFile() != null ? wodProblem.getForceFile().createMarker("org.objectstyle.wolips.wodclipse.core.problem") : file.createMarker("org.objectstyle.wolips.wodclipse.core.problem");
            marker.setAttribute("message", (Object)wodProblem.getMessage());
            int severity = wodProblem.isWarning() ? 1 : 2;
            marker.setAttribute("severity", (Object)severity);
            if (problemPosition != null) {
                if (wodProblem.getLineNumber() != -1) {
                    marker.setAttribute("lineNumber", wodProblem.getLineNumber());
                }
                marker.setAttribute("charStart", problemPosition.getOffset());
                marker.setAttribute("charEnd", problemPosition.getOffset() + problemPosition.getLength());
            }
            marker.setAttribute("transient", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
            Activator.getDefault().log(e);
        }
        return marker;
    }

    public static boolean hasValidationProblem(IApiBinding binding, List<WodProblem> problems) {
        return WodModelUtils.hasValidationProblem(binding.getName(), problems);
    }

    public static boolean hasValidationProblem(String bindingName, List<WodProblem> problems) {
        boolean hasValidationProblem = false;
        if (problems != null) {
            for (WodProblem problem : problems) {
                ApiBindingValidationProblem validationProblem;
                if (problem instanceof ApiBindingValidationProblem) {
                    validationProblem = (ApiBindingValidationProblem)problem;
                    hasValidationProblem = validationProblem.getBindingName().equals(bindingName);
                } else if (problem instanceof ApiElementValidationProblem) {
                    validationProblem = (ApiElementValidationProblem)problem;
                    hasValidationProblem = validationProblem.getValidation().isAffectedByBindingNamed(bindingName);
                } else if (problem instanceof WodBindingProblem) {
                    validationProblem = (WodBindingProblem)problem;
                    hasValidationProblem = ComparisonUtils.equals((Object)bindingName, (Object)validationProblem.getBindingName());
                }
                if (!hasValidationProblem) continue;
                break;
            }
        }
        return hasValidationProblem;
    }
}

