/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.woo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.objectstyle.wolips.eomodeler.core.model.EOAttribute;
import org.objectstyle.wolips.eomodeler.core.model.EODataSource;
import org.objectstyle.wolips.eomodeler.core.model.EODataSourceFactory;
import org.objectstyle.wolips.eomodeler.core.model.EODatabaseDataSource;
import org.objectstyle.wolips.eomodeler.core.model.EODetailDataSource;
import org.objectstyle.wolips.eomodeler.core.model.EODisplayGroupSortOrdering;
import org.objectstyle.wolips.eomodeler.core.model.EOEntity;
import org.objectstyle.wolips.eomodeler.core.model.EOFetchSpecification;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.EORelationship;
import org.objectstyle.wolips.eomodeler.core.model.EOSortOrdering;
import org.objectstyle.wolips.eomodeler.core.utils.IPropertyChangeSource;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.woo.WooModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayGroup
implements IPropertyChangeSource {
    public static final String NAME = "name";
    public static final String CLASS_NAME = "className";
    public static final String CLASS_NAME_INDEX = "classNameIndex";
    public static final String CLASS_NAME_LIST = "classNameList";
    public static final String QUALIFICATION_INDEX = "qualificationIndex";
    public static final String QUALIFICATION_LIST = "qualificationList";
    public static final String ENTITY_NAME = "entityName";
    public static final String ENTITY_LIST = "entityList";
    public static final String MASTER_ENTITY_NAME = "masterEntityName";
    public static final String DETAIL_KEY_NAME = "detailKeyName";
    public static final String DETAIL_KEY_LIST = "detailKeyList";
    public static final String SORT_LIST = "sortList";
    public static final String HAS_MASTER_DETAIL = "hasMasterDetail";
    public static final String SORT_ORDER = "sortOrder";
    public static final String SORT_ORDER_KEY = "sortOrderKey";
    public static final String FETCH_SPEC_LIST = "fetchSpecList";
    public static final String FETCH_SPEC_NAME = "fetchSpecName";
    public static final String ENTRIES_PER_BATCH = "entriesPerBatch";
    public static final String FETCHES_ON_LOAD = "fetchesOnLoad";
    public static final String SELECTS_FIRST_OBJECT = "selectsFirstObject";
    public static final String EDITING_CONTEXT = "editingContext";
    public static final String ASCENDING = "Ascending";
    public static final String DESCENDING = "Descending";
    public static final String NOT_SORTED = "Not Sorted";
    public static final String FETCH_SPEC_NONE = "<None>";
    public static final String[] SORT_OPTIONS = new String[]{"Ascending", "Descending", "Not Sorted"};
    private static final String QUALIFIER_PREFIX = "%@*";
    private static final String QUALIFIER_SUFFIX = "*%@";
    private static final String QUALIFIER_CONTAINS = "*%@*";
    private static final String[] QUALIFICATION_LABELS = new String[]{"Prefix", "Contains", "Suffix"};
    private static final String[] QUALIFICATION_FORMATS = new String[]{"%@*", "*%@*", "*%@"};
    private String _originalName;
    private String _name = "newDisplayGroup";
    private WooModel _wooModel;
    private int _qualificationIndex;
    private List<String> _entityList;
    private EOEntity _entity;
    private String _entityName;
    private EOEntity _masterEntity;
    private String _masterEntityName;
    private String _detailKeyName;
    private boolean _hasMasterDetail;
    private boolean _fetchesOnLoad;
    private String _className;
    private int _classNameIndex;
    private List<String> _classNameList;
    private String _qualifierFormat;
    private int _entriesPerBatch;
    private List<String> _localKeys;
    private boolean _selectsFirstObject;
    private PropertyChangeSupport _changeSupport;
    private EODataSource _dataSource;
    private EODatabaseDataSource _databaseDataSource;
    private EODetailDataSource _detailDataSource;
    private EOSortOrdering _sortOrder;
    private boolean _isSorted;

    public DisplayGroup(WooModel model) {
        this._wooModel = model;
        this._wooModel.getModelGroup();
        this._databaseDataSource = new EODatabaseDataSource(this._wooModel.getModelGroup());
        this._detailDataSource = new EODetailDataSource(this._wooModel.getModelGroup());
        this._dataSource = this._databaseDataSource;
        this._qualificationIndex = 0;
        this._qualifierFormat = QUALIFICATION_FORMATS[0];
        this._className = "WODisplayGroup";
        this._classNameIndex = this.getClassNameList().indexOf(this._className);
        this._isSorted = false;
        this._hasMasterDetail = false;
        this._changeSupport = new PropertyChangeSupport(this);
        this._sortOrder = new EODisplayGroupSortOrdering();
        this._selectsFirstObject = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(name, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != newValue || oldValue != null && !oldValue.equals(newValue) || newValue != null && !newValue.equals(oldValue)) {
            this._wooModel.markAsDirty();
            this._changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public String getClassName() {
        return this._className;
    }

    public int getClassNameIndex() {
        return this._classNameIndex;
    }

    public List<String> getClassNameList() {
        if (this._classNameList == null) {
            this._classNameList = new ArrayList<String>();
            try {
                IJavaProject project = JavaCore.create((IProject)this._wooModel.getProject());
                IType displayGroupType = project.findType("com.webobjects.appserver.WODisplayGroup");
                List subTypes = WodParserCache.getTypeCache().getSubtypesOfInProject(displayGroupType, project);
                for (IType type : subTypes) {
                    this._classNameList.add(type.getElementName());
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return this._classNameList;
    }

    public List<String> getDetailKeyList() {
        if (this._masterEntity != null) {
            ArrayList<String> keyList = new ArrayList<String>();
            Set relationships = this._masterEntity.getRelationships();
            for (EORelationship relation : relationships) {
                if (relation.getToMany() == null || !relation.getToMany().booleanValue()) continue;
                keyList.add(relation.getName());
            }
            return keyList;
        }
        return null;
    }

    public String getDetailKeyName() {
        return this._detailKeyName;
    }

    public String getEditingContext() {
        return this._databaseDataSource.getEditingContext();
    }

    public EOEntity getEntity() {
        return this._entity;
    }

    public List<String> getEntityList() {
        if (this._entityList == null) {
            this._entityList = new ArrayList<String>(this._wooModel.getModelGroup().getNonPrototypeEntityNames());
        }
        return this._entityList;
    }

    public String getEntityName() {
        return this._entityName;
    }

    public int getEntriesPerBatch() {
        return this._entriesPerBatch;
    }

    public boolean getFetchesOnLoad() {
        return this._fetchesOnLoad;
    }

    public List<String> getFetchSpecList() {
        if (this._entity != null) {
            try {
                Set fetchSpecs = this._entity.getSortedFetchSpecs();
                if (fetchSpecs.size() > 0) {
                    ArrayList<String> fetchSpecList = new ArrayList<String>(fetchSpecs.size() + 1);
                    fetchSpecList.add(FETCH_SPEC_NONE);
                    for (EOFetchSpecification fspec : fetchSpecs) {
                        fetchSpecList.add(fspec.getName());
                    }
                    return fetchSpecList;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String getFetchSpecName() {
        String name = this._databaseDataSource.getFetchSpecification().getName();
        return name;
    }

    public List<String> getLocalKeys() {
        return this._localKeys;
    }

    public EOEntity getMasterEntity() {
        return this._masterEntity;
    }

    public String getMasterEntityName() {
        return this._masterEntityName;
    }

    public String getName() {
        return this._name;
    }

    public String getOriginalName() {
        return this._originalName;
    }

    public int getQualificationIndex() {
        return this._qualificationIndex;
    }

    public String[] getQualificationList() {
        return (String[])QUALIFICATION_LABELS.clone();
    }

    public boolean getSelectsFirstObject() {
        return this._selectsFirstObject;
    }

    public List<String> getSortList() {
        if (this._entity != null) {
            Set attributes = this._entity.getSortedClassAttributes();
            ArrayList<String> attribList = new ArrayList<String>(attributes.size());
            for (EOAttribute attribute : attributes) {
                attribList.add(attribute.getName());
            }
            return attribList;
        }
        return new ArrayList<String>();
    }

    public String getSortOrder() {
        String order = null;
        if (!this._isSorted) {
            order = NOT_SORTED;
        } else {
            String selector = this._sortOrder.getSelectorName();
            if (selector.equals("compareAscending")) {
                order = ASCENDING;
            }
            if (selector.equals("compareDescending")) {
                order = DESCENDING;
            }
        }
        return order;
    }

    public String getSortOrderKey() {
        return this._sortOrder.getKey();
    }

    public WooModel getWooModel() {
        return this._wooModel;
    }

    public boolean isHasMasterDetail() {
        return this._hasMasterDetail;
    }

    public void loadFromMap(EOModelMap map, Set<EOModelVerificationFailure> failures) {
        List sortOrderList;
        this._originalName = this._name;
        this._className = map.getString("class", true);
        this._localKeys = map.getList("localKeys");
        if (map.containsKey((Object)"numberOfObjectsPerBatch")) {
            this._entriesPerBatch = map.getInteger("numberOfObjectsPerBatch");
        }
        if (map.containsKey((Object)"selectsFirstObjectAfterFetch")) {
            this._selectsFirstObject = map.getBoolean("selectsFirstObjectAfterFetch");
        }
        if (map.containsKey((Object)FETCHES_ON_LOAD)) {
            this._fetchesOnLoad = map.getBoolean(FETCHES_ON_LOAD);
        }
        this._qualifierFormat = map.getString("formatForLikeQualifier", true);
        List<String> qualificationFormatList = Arrays.asList(QUALIFICATION_FORMATS);
        this._qualificationIndex = qualificationFormatList.indexOf(this._qualifierFormat);
        if (map.containsKey((Object)"dataSource")) {
            EODetailDataSource ds;
            EOModelMap dataSourceMap = new EOModelMap(map.getMap("dataSource"));
            try {
                EODataSource dataSource = EODataSourceFactory.createDataSourceFromMap((EOModelMap)dataSourceMap, (EOModelGroup)this._wooModel.getModelGroup());
                dataSource.loadFromMap(dataSourceMap, failures);
                this._dataSource = dataSource;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (this._dataSource instanceof EODetailDataSource) {
                ds = (EODetailDataSource)this._dataSource;
                this._hasMasterDetail = true;
                this.setMasterEntityName(ds.getMasterClass());
                this.setDetailKeyName(ds.getDetailKey());
                this._detailDataSource = ds;
            } else if (this._dataSource instanceof EODatabaseDataSource) {
                ds = (EODatabaseDataSource)this._dataSource;
                this._hasMasterDetail = false;
                this.setEntityName(ds.getEntityName());
                this._databaseDataSource = ds;
            }
            if (this._entityName == null) {
                if (dataSourceMap.containsKey((Object)"fetchSpecification")) {
                    EOModelMap fetchSpecMap = new EOModelMap(dataSourceMap.getMap("fetchSpecification"));
                    this._entityName = fetchSpecMap.getString(ENTITY_NAME, true);
                } else if (dataSourceMap.containsKey((Object)"masterClassDescription")) {
                    this._entityName = dataSourceMap.getString("masterClassDescription", true);
                }
            }
        }
        if ((sortOrderList = map.getList("sortOrdering")) != null) {
            for (Map sortOrdering : sortOrderList) {
                if (sortOrdering == null) continue;
                EOModelMap sortOrderingMap = new EOModelMap(sortOrdering);
                this._sortOrder.loadFromMap(sortOrderingMap);
                this._isSorted = true;
            }
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(name, listener);
    }

    public void setClassName(String className) {
        String oldClass = this.getClassName();
        String _name = className;
        if (className == null || !this.getClassNameList().contains(className)) {
            _name = "WODisplayGroup";
        }
        this._className = _name;
        this.firePropertyChange(CLASS_NAME, oldClass, _name);
        this.setClassNameIndex(this.getClassNameList().indexOf(_name));
    }

    public void setClassNameIndex(int index) {
        int oldIndex = this._classNameIndex;
        this._classNameIndex = index;
        this._className = this._classNameList.get(index);
        this.firePropertyChange(CLASS_NAME_INDEX, oldIndex, this._classNameIndex);
    }

    public void setDetailKeyName(String key) {
        String oldDetailKeyName = this._detailKeyName;
        this._detailKeyName = key;
        if (key != null && this.isHasMasterDetail()) {
            EORelationship relation = this._masterEntity.getRelationshipNamed(key);
            if (relation != null) {
                this.setEntity(relation.getDestination().getEntity());
            } else {
                this.setEntity(this._masterEntity);
            }
        }
        this._detailDataSource.setDetailKey(this._detailKeyName);
        this.firePropertyChange(DETAIL_KEY_NAME, oldDetailKeyName, this._detailKeyName);
    }

    public void setEditingContext(String ec) {
        String oldEditingContext = this._databaseDataSource.getEditingContext();
        this._databaseDataSource.setEditingContext(ec);
        this.firePropertyChange(EDITING_CONTEXT, oldEditingContext, this._databaseDataSource.getEditingContext());
    }

    private void setEntity(EOEntity entity) {
        if (entity == null || !entity.equals(this._entity)) {
            List<String> oldFetchSpecList = this.getFetchSpecList();
            List<String> oldSortList = this.getSortList();
            this._entity = entity;
            if (this._entity != null) {
                this.setEntityName(this._entity.getName());
            }
            if (!this.isHasMasterDetail()) {
                this.setMasterEntity(entity);
            }
            this._databaseDataSource.getFetchSpecification().setEntity(entity);
            this.firePropertyChange(FETCH_SPEC_LIST, oldFetchSpecList, this.getFetchSpecList());
            this.setFetchSpecName(null);
            this.firePropertyChange(SORT_LIST, oldSortList, this.getSortList());
            this.setSortOrderKey(null);
        }
    }

    public void setEntityName(String entity) {
        String oldEntityName = this._entityName;
        if (entity == null || !entity.equals(this._entityName)) {
            this._entityName = entity;
            this.firePropertyChange(ENTITY_NAME, oldEntityName, this._entityName);
            try {
                EOEntity eoentity = this._wooModel.getModelGroup().getEntityNamed(entity);
                this.setEntity(eoentity);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setEntity(null);
            }
        }
    }

    public void setEntriesPerBatch(int entriesPerBatch) {
        int oldEntriesPerBatch = this._entriesPerBatch;
        this._entriesPerBatch = entriesPerBatch;
        this.firePropertyChange(ENTRIES_PER_BATCH, oldEntriesPerBatch, this._entriesPerBatch);
    }

    public void setFetchesOnLoad(boolean fetchesOnLoad) {
        boolean oldFetchesOnLoad = this._fetchesOnLoad;
        this._fetchesOnLoad = fetchesOnLoad;
        this.firePropertyChange(FETCHES_ON_LOAD, oldFetchesOnLoad, this._fetchesOnLoad);
    }

    public void setFetchSpecName(String fetchSpec) {
        String _fetchSpec = fetchSpec;
        String oldFetchSpecName = this.getFetchSpecName();
        EOFetchSpecification myFetchSpec = null;
        if (fetchSpec != null && this._entity != null) {
            myFetchSpec = this._entity.getFetchSpecNamed(fetchSpec);
        }
        if (myFetchSpec != null) {
            this._databaseDataSource.setFetchSpecification(myFetchSpec);
        } else {
            EOFetchSpecification newFetchSpec = new EOFetchSpecification(null);
            newFetchSpec.setEntity(this._entity);
            newFetchSpec.setDeep(Boolean.valueOf(true));
            this._databaseDataSource.setFetchSpecification(newFetchSpec);
        }
        if (fetchSpec == null && this.getFetchSpecList() != null) {
            _fetchSpec = FETCH_SPEC_NONE;
        }
        this.firePropertyChange(FETCH_SPEC_NAME, oldFetchSpecName, _fetchSpec);
    }

    public void setHasMasterDetail(boolean hasMasterDetail) {
        if (this._hasMasterDetail == hasMasterDetail) {
            return;
        }
        boolean oldHasMasterDetail = this._hasMasterDetail;
        this._hasMasterDetail = hasMasterDetail;
        this._dataSource = hasMasterDetail ? this._detailDataSource : this._databaseDataSource;
        this.firePropertyChange(HAS_MASTER_DETAIL, oldHasMasterDetail, this._hasMasterDetail);
    }

    public void setLocalKeys(List<String> localKeys) {
        this._localKeys = localKeys;
    }

    private void setMasterEntity(EOEntity entity) {
        List<String> oldDetailKeyList = this.getDetailKeyList();
        if (entity == null || !entity.equals(this._masterEntity)) {
            this._masterEntity = entity;
            if (this._masterEntity != null) {
                this.setMasterEntityName(this._masterEntity.getName());
            }
            if (this.isHasMasterDetail()) {
                this.setEntity(entity);
            }
            this._detailDataSource.setMasterClass(this._masterEntityName);
            this.firePropertyChange(DETAIL_KEY_LIST, oldDetailKeyList, this.getDetailKeyList());
        }
    }

    public void setMasterEntityName(String entity) {
        String oldMasterEntityName = this._masterEntityName;
        if (entity == null || !entity.equals(this._masterEntityName)) {
            this._masterEntityName = entity;
            this.firePropertyChange(MASTER_ENTITY_NAME, oldMasterEntityName, this._masterEntityName);
            try {
                EOEntity eoentity = this._wooModel.getModelGroup().getEntityNamed(entity);
                this.setMasterEntity(eoentity);
            }
            catch (Exception e) {
                this.setMasterEntity(null);
            }
        }
    }

    public void setName(String name) {
        String oldName = this._name;
        this._name = name;
        this.firePropertyChange(NAME, oldName, this._name);
    }

    public void setQualificationIndex(int qualification) {
        int oldQualificationIndex = this._qualificationIndex;
        this._qualificationIndex = qualification;
        this._qualifierFormat = QUALIFICATION_FORMATS[this._qualificationIndex];
        this.firePropertyChange(QUALIFICATION_INDEX, oldQualificationIndex, this._qualificationIndex);
    }

    public void setSelectsFirstObject(boolean value) {
        boolean oldSelectsFirstObject = this._selectsFirstObject;
        this._selectsFirstObject = value;
        this.firePropertyChange(SELECTS_FIRST_OBJECT, oldSelectsFirstObject, this._selectsFirstObject);
    }

    public void setSortOrder(String order) {
        String oldSortOrder = this.getSortOrder();
        if (order.equals(ASCENDING)) {
            this._sortOrder.setSelectorName("compareAscending");
            this._isSorted = true;
        }
        if (order.equals(DESCENDING)) {
            this._sortOrder.setSelectorName("compareDescending");
            this._isSorted = true;
        }
        if (order.equals(NOT_SORTED)) {
            this._isSorted = false;
        }
        this.firePropertyChange(SORT_ORDER, oldSortOrder, this.getSortOrder());
    }

    public void setSortOrderKey(String key) {
        String oldSortOrderKey = this.getSortOrderKey();
        String _key = key;
        if (key == null && this.getSortList().size() > 0) {
            _key = this.getSortList().get(0);
        }
        this._sortOrder.setKey(_key);
        this.firePropertyChange(SORT_ORDER_KEY, oldSortOrderKey, _key);
    }

    public void setWooModel(WooModel model) {
        this._wooModel = model;
    }

    public EOModelMap toMap() {
        if (this._entity == null) {
            // empty if block
        }
        EOModelMap modelMap = new EOModelMap();
        modelMap.setString("class", this._className, true);
        modelMap.setMap("dataSource", (Map)this._dataSource.toMap(), true);
        modelMap.setBoolean(FETCHES_ON_LOAD, Boolean.valueOf(this._fetchesOnLoad), 1);
        modelMap.setString("formatForLikeQualifier", this._qualifierFormat, true);
        modelMap.setList("localKeys", this._localKeys, true);
        modelMap.setInteger("numberOfObjectsPerBatch", Integer.valueOf(this._entriesPerBatch));
        modelMap.setBoolean("selectsFirstObjectAfterFetch", Boolean.valueOf(this._selectsFirstObject), 1);
        if (this._isSorted) {
            ArrayList<EOModelMap> sortOrderingList = new ArrayList<EOModelMap>();
            sortOrderingList.add(this._sortOrder.toMap());
            modelMap.setList("sortOrdering", sortOrderingList, true);
        }
        this._originalName = this._name;
        return modelMap;
    }
}

