/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.core.woo;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.woenvironment.plist.PropertyListParserException;
import org.objectstyle.woenvironment.plist.WOLPropertyListSerialization;
import org.objectstyle.wolips.baseforplugins.util.CharSetUtils;
import org.objectstyle.wolips.bindings.Activator;
import org.objectstyle.wolips.bindings.utils.BindingReflectionUtils;
import org.objectstyle.wolips.bindings.wod.BindingValueKeyPath;
import org.objectstyle.wolips.bindings.wod.TypeCache;
import org.objectstyle.wolips.bindings.wod.WodProblem;
import org.objectstyle.wolips.core.resources.types.TypeNameCollector;
import org.objectstyle.wolips.eomodeler.core.model.EOModelGroup;
import org.objectstyle.wolips.eomodeler.core.model.EOModelMap;
import org.objectstyle.wolips.eomodeler.core.model.EOModelParserDataStructureFactory;
import org.objectstyle.wolips.eomodeler.core.model.EOModelVerificationFailure;
import org.objectstyle.wolips.eomodeler.core.model.PropertyListMap;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.refactoring.AddKeyInfo;
import org.objectstyle.wolips.wodclipse.core.refactoring.AddKeyOperation;
import org.objectstyle.wolips.wodclipse.core.util.EOModelGroupCache;
import org.objectstyle.wolips.wodclipse.core.woo.DisplayGroup;
import org.objectstyle.wolips.wodclipse.core.woo.WooModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WooModel {
    public static final String IS_DIRTY = "IS_DIRTY";
    public static final String DISPLAY_GROUP_NAME = "DISPLAY_GROUP_NAME";
    public static final String ENCODING = "encoding";
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_WO_RELEASE = "WebObjects 5.0";
    private IFile _file;
    private boolean _isDirty;
    private EOModelGroup _modelGroup;
    private String _encoding;
    private String _woRelease = "WebObjects 5.0";
    private EOModelMap _modelMap;
    private PropertyListMap<Object, Object> _variables;
    private List<DisplayGroup> _displayGroups;
    private List<DisplayGroup> _removedDisplayGroups;
    private PropertyChangeSupport _changes = new PropertyChangeSupport(this);
    private PropertyChangeListener _displayGroupListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("name".equals(evt.getPropertyName())) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(evt.getSource(), WooModel.DISPLAY_GROUP_NAME, evt.getOldValue(), evt.getNewValue());
                WooModel.this._changes.firePropertyChange(newEvent);
            }
        }
    };

    public WooModel(IFile file) {
        this._file = file;
        try {
            this.init();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public WooModel(URL url) {
    }

    public WooModel(String contents) throws WooModelException {
        ByteArrayInputStream input = new ByteArrayInputStream(contents.getBytes());
        try {
            this.loadModelFromStream(input);
        }
        catch (Throwable e) {
            throw new WooModelException(e.getMessage(), e);
        }
    }

    public WooModel(InputStream input) throws WooModelException {
        try {
            this.loadModelFromStream(input);
        }
        catch (Throwable e) {
            throw new WooModelException(e.getMessage(), e);
        }
    }

    public WooModel(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            this._file = ((IFileEditorInput)editorInput).getFile();
        }
        try {
            this.init();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void init() throws IOException, PropertyListParserException {
        if (this._file == null || !this._file.exists()) {
            this.loadModelFromStream(new ByteArrayInputStream(this.blankContent().getBytes()));
        } else {
            this.loadModelFromFile(this._file.getLocation().toFile());
        }
    }

    public String blankContent() {
        StringBuffer sb = new StringBuffer();
        sb.append("{\n");
        sb.append("    \"WebObjects Release\" = \"WebObjects 5.0\";\n");
        sb.append("     encoding = \"" + this.getEncoding() + "\";\n");
        sb.append("}\n");
        return sb.toString();
    }

    private void resetModel() {
        this._encoding = null;
        this._woRelease = DEFAULT_WO_RELEASE;
        this._variables = null;
        this._modelMap = null;
        this._displayGroups = null;
        this._removedDisplayGroups = null;
    }

    public String getLocation() {
        String location = this._file != null ? this._file.getFullPath().toString() : null;
        return location;
    }

    public DisplayGroup[] getDisplayGroups() {
        if (this._displayGroups != null) {
            return this._displayGroups.toArray(new DisplayGroup[0]);
        }
        return new DisplayGroup[0];
    }

    public String getEncoding() {
        if (this._encoding == null && this._modelMap != null && this._modelMap.containsKey((Object)ENCODING)) {
            this._encoding = this._modelMap.getString(ENCODING, true);
        }
        if (this._encoding == null) {
            if (this._file != null && this._file.exists()) {
                try {
                    this._encoding = this._file.getParent().getDefaultCharset();
                    return this._encoding;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this._encoding = DEFAULT_ENCODING;
        }
        return this._encoding;
    }

    public EOModelGroup getModelGroup() {
        if (this._modelGroup == null) {
            this._modelGroup = WodParserCache.getModelGroupCache().getModelGroup(this._file.getProject());
        }
        return this._modelGroup;
    }

    public void setEncoding(String encoding) {
        String oldEncoding = this._encoding;
        this._encoding = encoding;
        this._changes.firePropertyChange(ENCODING, oldEncoding, this._encoding);
    }

    private void loadModelFromFile(File file) throws IOException, PropertyListParserException {
        this._modelMap = new EOModelMap((Map)WOLPropertyListSerialization.propertyListFromFile((File)file, (ParserDataStructureFactory)new EOModelParserDataStructureFactory()));
    }

    public void loadModelFromStream(InputStream input) throws IOException, PropertyListParserException {
        this._modelMap = new EOModelMap((Map)WOLPropertyListSerialization.propertyListFromStream((InputStream)input, (ParserDataStructureFactory)new EOModelParserDataStructureFactory()));
    }

    public void parseModel() {
        HashSet<EOModelVerificationFailure> failures = new HashSet<EOModelVerificationFailure>();
        if (this._modelMap == null) {
            return;
        }
        if (this._modelMap.containsKey((Object)ENCODING)) {
            this._encoding = this._modelMap.getString(ENCODING, true);
        }
        if (this._modelMap.containsKey((Object)"WebObjects Release")) {
            this._woRelease = this._modelMap.getString("WebObjects Release", true);
        }
        this._variables = new PropertyListMap();
        this._displayGroups = new ArrayList<DisplayGroup>();
        Map variables = this._modelMap.getMap("variables");
        if (variables != null) {
            EOModelMap variableMap = new EOModelMap(variables);
            Set variableEntries = variableMap.entrySet();
            for (Map.Entry entry : variableEntries) {
                if (entry.getValue() instanceof Map) {
                    EOModelMap entryMap = new EOModelMap((Map)entry.getValue());
                    String className = entryMap.getString("class", true);
                    try {
                        IType classType = this.findDisplayGroupClass(className);
                        if (classType != null) {
                            DisplayGroup displayGroup = new DisplayGroup(this);
                            displayGroup.setName((String)entry.getKey());
                            displayGroup.setClassName(className);
                            displayGroup.loadFromMap(entryMap, failures);
                            this._displayGroups.add(displayGroup);
                            displayGroup.addPropertyChangeListener(this._displayGroupListener);
                            continue;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if ("WODisplayGroup".equals(className) || "ERXDisplayGroup".equals(className)) {
                        DisplayGroup displayGroup = new DisplayGroup(this);
                        displayGroup.setName((String)entry.getKey());
                        displayGroup.setClassName(className);
                        displayGroup.loadFromMap(entryMap, failures);
                        this._displayGroups.add(displayGroup);
                        displayGroup.addPropertyChangeListener(this._displayGroupListener);
                        continue;
                    }
                }
                this._variables.put(entry.getKey(), entry.getValue());
            }
        }
        this._isDirty = false;
    }

    private IType findDisplayGroupClass(String className) throws JavaModelException {
        IJavaProject javaProject;
        IType classType = null;
        TypeCache typeCache = WodParserCache.getTypeCache();
        String typeName = typeCache.getApiCache(javaProject = JavaCore.create((IProject)this._file.getProject())).getElementTypeNamed(className);
        if (typeName != null) {
            classType = javaProject.findType(typeName);
        } else {
            TypeNameCollector typeNameCollector = new TypeNameCollector("com.webobjects.appserver.WODisplayGroup", javaProject, true);
            BindingReflectionUtils.findMatchingElementClassNames((String)className, (int)0, (TypeNameCollector)typeNameCollector, null);
            if (!typeNameCollector.isEmpty()) {
                String matchingElementClassName = typeNameCollector.firstTypeName();
                classType = typeNameCollector.getTypeForClassName(matchingElementClassName);
            }
            if (classType != null) {
                typeCache.getApiCache(javaProject).setElementTypeForName(classType, className);
            }
        }
        return classType;
    }

    public void refactor(Shell shell, IRunnableContext context) {
        try {
            IType componentType;
            if (this._file != null && (componentType = LocatePlugin.getDefault().getLocalizedComponentsLocateResult((IResource)this._file).getDotJavaType()) != null) {
                for (DisplayGroup displayGroup : this.getDisplayGroups()) {
                    String originalParameterType;
                    String originalName = displayGroup.getOriginalName();
                    String newName = displayGroup.getName();
                    String newClassName = displayGroup.getClassName();
                    AddKeyInfo info = new AddKeyInfo(componentType);
                    info.setTypeName(displayGroup.getClassName());
                    info.setName(newName);
                    info.setCreateAccessorMethod(false);
                    info.setCreateMutatorMethod(false);
                    IType classType = this.findDisplayGroupClass(displayGroup.getClassName());
                    String newParameterType = "";
                    if (classType != null && classType.getTypeParameters().length > 0) {
                        newParameterType = displayGroup.getEntityName();
                        info.setParameterTypeName(newParameterType);
                    }
                    IField field = componentType.getField(info.getFieldName());
                    if (originalName == null) {
                        if (field.exists()) continue;
                        AddKeyOperation.addKey(info);
                        continue;
                    }
                    info.setName(originalName);
                    field = componentType.getField(info.getFieldName());
                    if (!field.exists()) continue;
                    String originalClassName = Signature.getSignatureSimpleName((String)Signature.getTypeErasure((String)field.getTypeSignature()));
                    String[] types = Signature.getTypeArguments((String)field.getTypeSignature());
                    String string = originalParameterType = types.length > 0 ? Signature.getSignatureSimpleName((String)types[0]) : "";
                    if (originalName.equals(newName) && originalClassName.equals(displayGroup.getClassName()) && originalParameterType.equals(newParameterType)) continue;
                    info.setName(newName);
                    AddKeyOperation.replaceField(info, originalName);
                }
                if (this._removedDisplayGroups != null) {
                    for (DisplayGroup displayGroup : this._removedDisplayGroups) {
                        String originalName = displayGroup.getOriginalName();
                        if (originalName == null) continue;
                        AddKeyInfo info = new AddKeyInfo(componentType);
                        info.setName(originalName);
                        IField field = componentType.getField(info.getFieldName());
                        if (!field.exists()) continue;
                        field.delete(false, null);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave() throws IOException {
        if (this._file == null) {
            throw new IOException("You can not save changes to a WooModel that is not backed by a file.");
        }
        File file = this._file.getLocation().toFile();
        FileOutputStream writer = new FileOutputStream(file);
        try {
            this.doSave(writer);
            this._isDirty = false;
            this._removedDisplayGroups = null;
            this._file.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        finally {
            writer.close();
        }
    }

    public void doSave(OutputStream writer) throws IOException {
        EOModelMap modelMap = this.toModelMap();
        try {
            WOLPropertyListSerialization.propertyListToStream((OutputStream)writer, (Object)modelMap);
        }
        catch (PropertyListParserException e) {
            e.printStackTrace();
        }
    }

    public void doRevertToSaved() throws IOException, PropertyListParserException {
        this.resetModel();
        this.loadModelFromFile(this._file.getLocation().toFile());
        this.parseModel();
    }

    public EOModelMap toModelMap() {
        EOModelMap modelMap = this._modelMap.cloneModelMap();
        modelMap.setString("WebObjects Release", this._woRelease, true);
        modelMap.setString(ENCODING, this._encoding, true);
        EOModelMap variableMap = new EOModelMap();
        if (this._variables != null) {
            variableMap.putAll(this._variables);
        }
        for (DisplayGroup displayGroup : this._displayGroups) {
            String displayGroupName = displayGroup.getName();
            EOModelMap displayGroupMap = displayGroup.toMap();
            variableMap.setMap(displayGroupName, (Map)displayGroupMap, true);
        }
        modelMap.setMap("variables", (Map)variableMap, true);
        return modelMap;
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    public void markAsDirty() {
        boolean oldIsDirty = this._isDirty;
        this._isDirty = true;
        this._changes.firePropertyChange(IS_DIRTY, oldIsDirty, this._isDirty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changes.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this._changes.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changes.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this._changes.removePropertyChangeListener(name, listener);
    }

    public void createDisplayGroup(String name) {
        DisplayGroup displayGroup = new DisplayGroup(this);
        displayGroup.addPropertyChangeListener(this._displayGroupListener);
        displayGroup.setName(name);
        this._displayGroups.add(displayGroup);
        this.markAsDirty();
    }

    public void removeDisplayGroup(DisplayGroup selection) {
        selection.removePropertyChangeListener(this._displayGroupListener);
        this._displayGroups.remove(selection);
        if (this._removedDisplayGroups == null) {
            this._removedDisplayGroups = new LinkedList<DisplayGroup>();
        }
        this._removedDisplayGroups.add(selection);
        this.markAsDirty();
    }

    public String toString() {
        ByteArrayOutputStream modelStream = new ByteArrayOutputStream();
        try {
            this.doSave(modelStream);
        }
        catch (Exception e) {
            return null;
        }
        return ((Object)modelStream).toString();
    }

    public List<WodProblem> getProblems(IJavaProject javaProject, IType type, TypeCache typeCache, EOModelGroupCache modelCache) {
        ArrayList<WodProblem> problems = new ArrayList<WodProblem>();
        try {
            this.parseModel();
        }
        catch (Throwable e) {
            e.printStackTrace();
            problems.add(new WodProblem(e.getMessage(), null, 0, true));
            return problems;
        }
        if (this._file == null) {
            return problems;
        }
        boolean validateWooEncodings = Activator.getDefault().getPluginPreferences().getBoolean("ValidateWooEncodingsKey");
        if (validateWooEncodings) {
            try {
                String componentCharset = this._file.getParent().getDefaultCharset();
                String encoding = CharSetUtils.encodingNameFromObjectiveC((String)this.getEncoding());
                if (!encoding.equals(componentCharset)) {
                    problems.add(new WodProblem("WOO Encoding type " + encoding + " doesn't match component " + componentCharset, null, 0, true));
                }
                if (this._file.getParent().exists()) {
                    for (IResource element : this._file.getParent().members()) {
                        IFile file;
                        String fileExtension;
                        if (element.getType() != 1 || (fileExtension = (file = (IFile)element).getFileExtension()) == null || !file.getFileExtension().matches("(xml|html|xhtml|wod)") || file.getCharset().equals(encoding)) continue;
                        problems.add(new WodProblem("WOO Encoding type " + encoding + " doesn't match " + file.getName() + " of " + file.getCharset(), null, 0, true));
                    }
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        if (type == null) {
            if (this.getDisplayGroups().length != 0) {
                problems.add(new WodProblem("Display groups are defined for component " + this._file.getParent().getName() + " but class was not found", null, 0, false));
            }
            return problems;
        }
        for (DisplayGroup displayGroup : this.getDisplayGroups()) {
            try {
                if (type == null) continue;
                BindingValueKeyPath bindingValueKeyPath = new BindingValueKeyPath(displayGroup.getName(), type, type.getJavaProject(), WodParserCache.getTypeCache());
                if (!bindingValueKeyPath.isValid() || bindingValueKeyPath.isAmbiguous()) {
                    problems.add(new WodProblem("WODisplayGroup " + displayGroup.getName() + " is configured but not declared in class", null, 0, false));
                }
                if (displayGroup.isHasMasterDetail() || (bindingValueKeyPath = new BindingValueKeyPath(displayGroup.getEditingContext(), type, type.getJavaProject(), WodParserCache.getTypeCache())).isValid() && !bindingValueKeyPath.isAmbiguous()) continue;
                problems.add(new WodProblem("Editing context for display group " + displayGroup.getName() + " not found", null, 0, false));
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return problems;
    }

    public IProject getProject() {
        if (this._file != null) {
            return this._file.getProject();
        }
        return null;
    }

    public String getName() {
        return this._file.getName();
    }

    public static void updateEncoding(IFile file, String charset) {
        WooModel model = new WooModel(file);
        String encoding = CharSetUtils.encodingNameFromObjectiveC((String)model.getEncoding());
        System.out.println("WooModel.updateEncoding: Setting encoding of " + file + " from " + encoding + " to " + charset);
        if (!encoding.equals(charset)) {
            try {
                model._modelMap.setString(ENCODING, charset, true);
                File _file = file.getLocation().toFile();
                if (!_file.exists()) {
                    System.out.println("WooModel.updateEncoding: creating file " + _file);
                    _file.createNewFile();
                }
                FileOutputStream writer = new FileOutputStream(_file);
                WOLPropertyListSerialization.propertyListToStream((OutputStream)writer, (Object)model._modelMap);
            }
            catch (PropertyListParserException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public IFile getFile() {
        return this._file;
    }

    public void setFile(IFile file) {
        this._file = file;
    }
}

