/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.wodclipse.editor;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.objectstyle.wolips.baseforplugins.util.Throttle;
import org.objectstyle.wolips.bindings.wod.IWodElement;
import org.objectstyle.wolips.bindings.wod.IWodModel;
import org.objectstyle.wolips.components.editor.ComponentEditorInteraction;
import org.objectstyle.wolips.components.editor.IEmbeddedEditor;
import org.objectstyle.wolips.components.editor.IWebobjectTagListener;
import org.objectstyle.wolips.components.editor.IWodDocumentProvider;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.locate.LocatePlugin;
import org.objectstyle.wolips.locate.result.LocalizedComponentsLocateResult;
import org.objectstyle.wolips.wodclipse.WodclipsePlugin;
import org.objectstyle.wolips.wodclipse.core.Activator;
import org.objectstyle.wolips.wodclipse.core.completion.WodParserCache;
import org.objectstyle.wolips.wodclipse.core.document.DocumentWodElement;
import org.objectstyle.wolips.wodclipse.core.document.ITextWOEditor;
import org.objectstyle.wolips.wodclipse.core.util.CursorPositionSupport;
import org.objectstyle.wolips.wodclipse.core.util.ICursorPositionListener;
import org.objectstyle.wolips.wodclipse.core.util.WodModelUtils;
import org.objectstyle.wolips.wodclipse.editor.WodContentOutlinePage;
import org.objectstyle.wolips.wodclipse.editor.WodSourceViewerConfiguration;

public class WodEditor
extends TextEditor
implements IEmbeddedEditor,
IWebobjectTagListener,
IWodDocumentProvider,
ITextWOEditor {
    private WodParserCache _cache;
    private CursorPositionSupport _cursorPositionSupport;
    private WodContentOutlinePage _contentOutlinePage;
    private IEditorInput _input;
    private LocalizedComponentsLocateResult _componentsLocateResults;
    private ComponentEditorInteraction _editorInteraction;
    private Throttle _wodOutlineUpdateThrottle = new Throttle("WodOutline", 1000L, (Runnable)new WodOutlineUpdater());

    public WodEditor() {
        this._cursorPositionSupport = new CursorPositionSupport(this);
        this.setSourceViewerConfiguration(new WodSourceViewerConfiguration(this));
    }

    public void doSave(IProgressMonitor progressMonitor) {
        if (this._editorInteraction == null || this._editorInteraction.embeddedEditorWillSave(progressMonitor)) {
            super.doSave(progressMonitor);
            this.updateValidation();
            this._editorInteraction.fireWebObjectChanged();
        }
    }

    public void doSaveAs() {
        super.doSaveAs();
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this._cache = null;
        this.updateValidation();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSourceViewer().getTextWidget().getParent().setBackground(parent.getBackground());
    }

    protected void performRevert() {
        super.performRevert();
        this.updateValidation();
        this._editorInteraction.fireWebObjectChanged();
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        super.performSaveAs(progressMonitor);
        this.updateValidation();
        this._editorInteraction.fireWebObjectChanged();
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        super.performSave(overwrite, progressMonitor);
    }

    public WodParserCache getParserCache() throws CoreException, LocateException {
        if (this._cache == null) {
            IFileEditorInput input = (IFileEditorInput)this.getEditorInput();
            IFile inputFile = input.getFile();
            this._cache = WodParserCache.parser((IResource)inputFile);
        }
        return this._cache;
    }

    protected void updateValidation() {
        try {
            this.getParserCache().scheduleValidate(true, true);
        }
        catch (Throwable e) {
            Activator.getDefault().log(e);
        }
    }

    public synchronized void addCursorPositionListener(ICursorPositionListener listener) {
        this._cursorPositionSupport.addCursorPositionListener(listener);
    }

    public synchronized void removeCursorPositionListener(ICursorPositionListener listener) {
        this._cursorPositionSupport.removeCursorPositionListener(listener);
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        this._cursorPositionSupport.cursorPositionChanged(this.getViewer().getSelectedRange());
    }

    public ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.objectstyle.wolips.componenteditor.componentEditorScope"});
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        return super.createSourceViewer(parent, verticalRuler, styles);
    }

    protected void createActions() {
        super.createActions();
        String BUNDLE_FOR_CONSTRUCTED_KEYS = "org.eclipse.jdt.internal.ui.javaeditor.ConstructedJavaEditorMessages";
        ResourceBundle fgBundleForConstructedKeys = ResourceBundle.getBundle(BUNDLE_FOR_CONSTRUCTED_KEYS);
        ContentAssistAction action = new ContentAssistAction(fgBundleForConstructedKeys, "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.ui.content_assist_action_context");
    }

    public void updateWebObjectsTagNames() {
    }

    public Object getAdapter(Class adapter) {
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this._contentOutlinePage == null) {
                this._contentOutlinePage = new WodContentOutlinePage(this.getDocumentProvider(), (ITextEditor)this);
                this._contentOutlinePage.setInput(this._input);
            }
            return this._contentOutlinePage;
        }
        return super.getAdapter(adapter);
    }

    protected Throttle getWodOutlineUpdateThrottle() {
        return this._wodOutlineUpdateThrottle;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this._wodOutlineUpdateThrottle.stop();
        this._input = input;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        document.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                WodEditor.this.getWodOutlineUpdateThrottle().ping();
            }
        });
        try {
            this.getParserCache().getWodEntry().setDocument(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._wodOutlineUpdateThrottle.start();
    }

    public void dispose() {
        try {
            this.getParserCache().getWodEntry().setDocument(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this._wodOutlineUpdateThrottle.stop();
        super.dispose();
    }

    public LocalizedComponentsLocateResult getComponentsLocateResults() throws CoreException, LocateException {
        if (this._componentsLocateResults == null) {
            this._componentsLocateResults = LocatePlugin.getDefault().getLocalizedComponentsLocateResult((IResource)((IFileEditorInput)this._input).getFile());
        }
        return this._componentsLocateResults;
    }

    public void initEditorInteraction(ComponentEditorInteraction editorInteraction) {
        this._editorInteraction = editorInteraction;
        this._editorInteraction.addWebObjectTagListener((IWebobjectTagListener)this);
        this._editorInteraction.setWodDocumentProvider((IWodDocumentProvider)this);
    }

    public void webObjectChanged() {
    }

    public void webObjectTagSelected(String name) {
        try {
            IWodElement wodElement = this.getWodModel(false).getElementNamed(name);
            if (wodElement instanceof DocumentWodElement) {
                DocumentWodElement docWodElement = (DocumentWodElement)wodElement;
                Position namePosition = docWodElement.getElementNamePosition();
                this.getSourceViewer().setSelectedRange(namePosition.getOffset(), namePosition.getLength());
                this.getSourceViewer().revealRange(namePosition.getOffset(), namePosition.getLength());
            }
        }
        catch (BadLocationException e) {
            WodclipsePlugin.getDefault().log(e);
        }
        catch (Exception e) {
            WodclipsePlugin.getDefault().log(e);
        }
    }

    public IDocument getWodEditDocument() {
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        return document;
    }

    public ComponentEditorInteraction getEditorInteraction() {
        return this._editorInteraction;
    }

    public ISourceViewer getWOSourceViewer() {
        return this.getViewer();
    }

    public StyledText getWOEditorControl() {
        return this.getViewer().getTextWidget();
    }

    public int getOffsetAtPoint(Point point) {
        int modelOffset;
        StyledText st = this.getViewer().getTextWidget();
        if (!st.getBounds().contains(point)) {
            modelOffset = -1;
        } else {
            try {
                int offset = st.getOffsetAtLocation(point);
                modelOffset = AbstractTextEditor.widgetOffset2ModelOffset((ISourceViewer)this.getSourceViewer(), (int)offset);
            }
            catch (IllegalArgumentException e) {
                modelOffset = -1;
            }
        }
        return modelOffset;
    }

    public IWodModel getWodModel(boolean refreshModel) throws Exception {
        IWodModel model;
        WodParserCache cache = this.getParserCache();
        if (refreshModel || this.isDirty()) {
            model = WodModelUtils.createWodModel(cache.getWodEntry().getFile(), cache.getWodEntry().getDocument());
            cache.getWodEntry().setModel(model);
        } else {
            model = (IWodModel)cache.getWodEntry().getModel();
        }
        return model;
    }

    public IWodElement getWodElementAtPoint(Point point, boolean resolveWodElement, boolean refreshModel) throws Exception {
        int offset = this.getOffsetAtPoint(point);
        IWodElement element = this.getWodModel(refreshModel).getWodElementAtIndex(offset);
        return element;
    }

    public IWodElement getSelectedElement(boolean resolveWodElement, boolean refreshModel) throws Exception {
        ISelection selection;
        IWodElement element = null;
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            int offset = ((ITextSelection)selection).getOffset();
            element = this.getWodModel(refreshModel).getWodElementAtIndex(offset);
        }
        return element;
    }

    protected class WodOutlineUpdater
    implements Runnable {
        protected WodOutlineUpdater() {
        }

        public void run() {
            IContentOutlinePage contentOutlinePage = (IContentOutlinePage)WodEditor.this.getAdapter(IContentOutlinePage.class);
            if (contentOutlinePage instanceof WodContentOutlinePage) {
                final WodContentOutlinePage wodContentOutlinePage = (WodContentOutlinePage)contentOutlinePage;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        wodContentOutlinePage.update();
                    }
                });
            }
        }
    }
}

