/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforuiplugins.plist;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.objectstyle.woenvironment.plist.ParserDataStructureFactory;
import org.objectstyle.wolips.baseforuiplugins.plist.PropertyListPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyListContentProvider
implements ITreeContentProvider {
    private ParserDataStructureFactory _factory;
    private boolean _rootVisible;
    private Set<String> _filteredKeyPaths;

    public PropertyListContentProvider(ParserDataStructureFactory factory, boolean rootVisible, Set<String> filteredKeyPaths) {
        this._factory = factory;
        this._rootVisible = rootVisible;
        this._filteredKeyPaths = filteredKeyPaths;
    }

    public void setFactory(ParserDataStructureFactory factory) {
        this._factory = factory;
    }

    public ParserDataStructureFactory getFactory() {
        return this._factory;
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        Object parent;
        if (element instanceof PropertyListPath) {
            PropertyListPath path = (PropertyListPath)element;
            parent = path.getParent();
            if (parent == null) {
                parent = path.getRawObject();
            }
        } else {
            parent = null;
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof PropertyListPath) {
            PropertyListPath path = (PropertyListPath)element;
            hasChildren = path.isCollectionValue();
        } else {
            hasChildren = true;
        }
        return hasChildren;
    }

    public Object[] getElements(Object inputElement) {
        List<PropertyListPath> children;
        boolean filter = false;
        if (inputElement instanceof PropertyListPath) {
            PropertyListPath path = (PropertyListPath)inputElement;
            children = path.getChildren();
            if (path.getParent() == null) {
                filter = true;
            }
        } else if (this._rootVisible) {
            children = new LinkedList<PropertyListPath>();
            children.add(new PropertyListPath(inputElement, this._factory));
        } else {
            children = new PropertyListPath(inputElement, this._factory).getChildren();
        }
        if (this._filteredKeyPaths != null && !this._filteredKeyPaths.isEmpty() && filter) {
            Iterator<PropertyListPath> childrenIter = children.iterator();
            while (childrenIter.hasNext()) {
                PropertyListPath child = childrenIter.next();
                if (!this._filteredKeyPaths.contains(child.getKeyPath())) continue;
                childrenIter.remove();
            }
        }
        return children.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

