/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.classpath;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.objectstyle.wolips.jdt.classpath.model.EclipseDependency;
import org.objectstyle.wolips.launching.classpath.EclipseDependencyOrdering;
import org.objectstyle.wolips.preferences.Preferences;
import org.objectstyle.wolips.variables.BuildProperties;

public class WORuntimeClasspathProvider
extends StandardClasspathProvider {
    public static final String ID = "org.objectstyle.wolips.launching.WORuntimeClasspathProvider";
    public static final String OLD_ID = "org.objectstyle.wolips.launching.classpath.WORuntimeClasspathProvider";
    public static final String VERY_OLD_ID = "org.objectstyle.wolips.launching.WORuntimeClasspath";

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        return super.computeUnresolvedClasspath(configuration);
    }

    public IRuntimeClasspathEntry[] superResolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        LinkedHashSet<IRuntimeClasspathEntry> all = new LinkedHashSet<IRuntimeClasspathEntry>(entries.length);
        for (int i = 0; i < entries.length; ++i) {
            IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entries[i], (ILaunchConfiguration)configuration);
            for (int j = 0; j < resolved.length; ++j) {
                all.add(resolved[j]);
            }
        }
        return all.toArray(new IRuntimeClasspathEntry[all.size()]);
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] orderedEntries;
        boolean newNSBundle;
        IRuntimeClasspathEntry[] resolvedEntries = this.superResolveClasspath(entries, configuration);
        IProject project = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration).getProject();
        boolean bl = newNSBundle = ((BuildProperties)project.getAdapter(BuildProperties.class)).getWOVersion().isAtLeastVersion(5, 6) || !Preferences.mockBundleEnabled();
        if (newNSBundle) {
            orderedEntries = resolvedEntries;
        } else {
            ArrayList<EclipseDependency> unorderedDependencies = new ArrayList<EclipseDependency>(resolvedEntries.length);
            for (IRuntimeClasspathEntry entry : resolvedEntries) {
                unorderedDependencies.add(new EclipseDependency(project, entry));
            }
            List orderedDependencies = new EclipseDependencyOrdering(project, newNSBundle).orderDependencies(unorderedDependencies);
            orderedEntries = new IRuntimeClasspathEntry[orderedDependencies.size()];
            int orderedEntryNum = 0;
            for (EclipseDependency dependency : orderedDependencies) {
                orderedEntries[orderedEntryNum++] = dependency.getClasspathEntry();
            }
        }
        return orderedEntries;
    }
}

