/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.launching.delegates;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.objectstyle.woenvironment.util.FileStringScanner;
import org.objectstyle.wolips.baseforplugins.util.StringUtilities;
import org.objectstyle.wolips.baseforuiplugins.utils.WorkbenchUtilities;
import org.objectstyle.wolips.core.resources.types.project.ProjectAdapter;
import org.objectstyle.wolips.launching.LaunchingPlugin;
import org.objectstyle.wolips.preferences.ILaunchInfo;
import org.objectstyle.wolips.preferences.Preferences;
import org.objectstyle.wolips.variables.VariablesPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WOJavaLocalApplicationLaunchConfigurationDelegate
extends JavaLaunchDelegate {
    public static final String WOJavaLocalApplicationID = "org.objectstyle.wolips.launching.WOLocalJavaApplication";
    public static final String ATTR_WOLIPS_LAUNCH_WOARGUMENTS = "org.objectstyle.wolips.launchinfo";
    public static final String ATTR_WOLIPS_LAUNCH_DEBUG_GROUPS = "WOJavaLocalApplicationLaunchConfigurationDelegate.NSDebugGroups";
    public static final String ATTR_WOLIPS_LAUNCH_OPEN_IN_BROWSER = "WOJavaLocalApplicationLaunchConfigurationDelegate.OpenInBrowser";
    public static final String ATTR_WOLIPS_LAUNCH_WEBSERVER_CONNECT = "WOJavaLocalApplicationLaunchConfigurationDelegate.WebServerConnect";

    public static void initConfiguration(ILaunchConfigurationWorkingCopy config) {
        try {
            IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)config);
            if (javaProject != null) {
                config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, "${working_dir_loc_WOLips:" + javaProject.getProject().getName() + "}");
            }
        }
        catch (CoreException ce) {
            LaunchingPlugin.getDefault().log(ce);
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.objectstyle.wolips.launching.WORuntimeClasspathProvider");
        config.setAttribute(ATTR_WOLIPS_LAUNCH_OPEN_IN_BROWSER, "false");
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        return super.getClasspath(configuration);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String notFound = "notFound";
        if (configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, notFound).equals(notFound)) {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.objectstyle.wolips.launching.WORuntimeClasspathProvider");
            workingCopy.doSave();
            this.informUser("LaunchConfiguration update. The message should occur only once. Please launch your app again.");
            return false;
        }
        if (configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, notFound).equals("org.objectstyle.wolips.launching.classpath.WORuntimeClasspathProvider")) {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.objectstyle.wolips.launching.WORuntimeClasspathProvider");
            workingCopy.doSave();
            this.informUser("LaunchConfiguration update. The message should occur only once. Please launch your app again.");
            return false;
        }
        if (configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, notFound).equals("org.objectstyle.wolips.launching.WORuntimeClasspath")) {
            ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.objectstyle.wolips.launching.WORuntimeClasspathProvider");
            workingCopy.doSave();
            this.informUser("LaunchConfiguration update. The message should occur only once. Please launch your app again.");
            return false;
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    private final void informUser(final String message) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RunnableExceptionHandler
        implements Runnable {
            RunnableExceptionHandler() {
            }

            @Override
            public void run() {
                Status status = new Status(4, "org.objectstyle.wolips.launching", 4, "Classpath Provider missing or invalid", null);
                WorkbenchUtilities.errorDialog((Shell)Display.getCurrent().getActiveShell(), (String)"WOLips", (String)message, (IStatus)status);
            }
        }
        RunnableExceptionHandler runnable = new RunnableExceptionHandler();
        Display.getDefault().asyncExec((Runnable)runnable);
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IProject theProject = this.getJavaProject(configuration).getProject();
        ProjectAdapter projectAdaptor = (ProjectAdapter)theProject.getAdapter(ProjectAdapter.class);
        IContainer workingDirectoryFolder = projectAdaptor.getWorkingDirFolder();
        File workingDirectoryFile = workingDirectoryFolder == null ? super.verifyWorkingDirectory(configuration) : workingDirectoryFolder.getLocation().toFile();
        return workingDirectoryFile;
    }

    public boolean isValidProjectPath(IProject project) {
        try {
            return true;
        }
        catch (Exception anException) {
            LaunchingPlugin.getDefault().log(anException);
            return false;
        }
    }

    protected void addProjectsToSearchPath(IProject buildProject, IProject project, StringBuffer searchPathBuffer, Set<IProject> visitedProjects, Set<IProject> invalidProjects) throws JavaModelException {
        if (!visitedProjects.contains(project)) {
            visitedProjects.add(project);
            if (project.equals(buildProject)) {
                searchPathBuffer.append("\"..\",\"../..\"");
            }
            if (this.isValidProjectPath(project)) {
                ProjectAdapter projectAdapter = (ProjectAdapter)project.getAdapter(ProjectAdapter.class);
                if (projectAdapter != null && projectAdapter.isFramework()) {
                    searchPathBuffer.append(",\"");
                    searchPathBuffer.append(project.getLocation().toOSString());
                    searchPathBuffer.append("\"");
                }
            } else {
                invalidProjects.add(project);
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject != null) {
                String[] requiredProjectNames = javaProject.getRequiredProjectNames();
                for (int requiredProjectNameNum = 0; requiredProjectNameNum < requiredProjectNames.length; ++requiredProjectNameNum) {
                    String requiredProjectName = requiredProjectNames[requiredProjectNameNum];
                    IProject requiredProject = ResourcesPlugin.getWorkspace().getRoot().getProject(requiredProjectName);
                    this.addProjectsToSearchPath(buildProject, requiredProject, searchPathBuffer, visitedProjects, invalidProjects);
                }
            }
        }
    }

    private String addPreferencesValue(String aString, String projectSearchPathPreferences) {
        String value = aString;
        if (value == null) {
            return value;
        }
        String nsProjectSarchPath = projectSearchPathPreferences;
        if (nsProjectSarchPath == null || nsProjectSarchPath.length() == 0) {
            return value;
        }
        if (value.length() > 0) {
            value = value + ",";
        }
        return value + nsProjectSarchPath;
    }

    public String getGeneratedByWOLips(IProject project, String projectSearchPathPreferences) throws JavaModelException {
        StringBuffer searchPathBuffer = new StringBuffer();
        HashSet<IProject> invalidProjects = new HashSet<IProject>();
        this.addProjectsToSearchPath(project, project, searchPathBuffer, new HashSet<IProject>(), invalidProjects);
        String returnValue = FileStringScanner.replace((String)searchPathBuffer.toString(), (String)"\\", (String)"/");
        returnValue = this.addPreferencesValue(returnValue, projectSearchPathPreferences);
        if ("".equals(returnValue)) {
            returnValue = "\"..\"";
        }
        returnValue = "(" + returnValue + ")";
        return returnValue;
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return this.getProgramArguments(configuration, true, true, false);
    }

    public String getProgramArguments(ILaunchConfiguration configuration, boolean includeDash, boolean includeDashD, boolean equalSeparator) throws CoreException {
        String debugGroups;
        IProject theProject = this.getJavaProject(configuration).getProject();
        StringBuffer launchArgument = new StringBuffer();
        if (includeDash) {
            launchArgument.append(super.getProgramArguments(configuration));
        }
        launchArgument.append(" ");
        String mainTypeName = this.verifyMainTypeName(configuration);
        File workingDir = this.verifyWorkingDirectory(configuration);
        String launchArguments = configuration.getAttribute(ATTR_WOLIPS_LAUNCH_WOARGUMENTS, Preferences.getLaunchGlobal());
        if (launchArguments != null && launchArguments.indexOf("<>-EOAdaptorDebugEnabled=<>") != -1) {
            launchArguments = launchArguments.replaceAll("\\Q<>-EOAdaptorDebugEnabled=<>\\E", "<>-EOAdaptorDebugEnabled<>");
        }
        ILaunchInfo[] launchInfo = Preferences.getLaunchInfoFrom((String)launchArguments);
        String automatic = "Automatic";
        boolean isMacOSX = System.getProperty("os.name", "Unknown").contains("Mac");
        boolean nsProjectBundleEnabledExists = false;
        for (int i = 0; i < launchInfo.length; ++i) {
            if (launchInfo[i].isEnabled()) {
                String parameter = launchInfo[i].getParameter();
                String argument = launchInfo[i].getArgument();
                boolean includeParam = true;
                includeParam = parameter.startsWith("-D") ? includeDashD : includeDash;
                if (includeParam) {
                    if (automatic.equals(argument)) {
                        IPath systemRoot;
                        if ("-WOApplicationClassName".equals(parameter)) {
                            argument = mainTypeName;
                        }
                        if ("-DWORoot=".equals(parameter)) {
                            systemRoot = VariablesPlugin.getDefault().getProjectVariables(theProject).getSystemRoot();
                            if (isMacOSX || systemRoot == null) {
                                parameter = "";
                                argument = "";
                            } else {
                                argument = systemRoot.toOSString();
                            }
                        }
                        if ("-DWORootDirectory=".equals(parameter)) {
                            systemRoot = VariablesPlugin.getDefault().getProjectVariables(theProject).getSystemRoot();
                            if (isMacOSX || systemRoot == null) {
                                parameter = "";
                                argument = "";
                            } else {
                                argument = systemRoot.toOSString();
                            }
                        }
                        if ("-DWOUserDirectory=".equals(parameter)) {
                            argument = workingDir.getAbsolutePath();
                        }
                        if ("-NSProjectSearchPath".equals(parameter) || "-DNSProjectSearchPath".equals(parameter)) {
                            argument = this.getGeneratedByWOLips(theProject, Preferences.getNSProjectSearchPath());
                        }
                    }
                    if (parameter != null && parameter.length() > 0) {
                        launchArgument.append(StringUtilities.toCommandlineParameterFormat((String)parameter, (String)argument, (boolean)true, (boolean)equalSeparator));
                        launchArgument.append(" ");
                    }
                }
            }
            if (launchInfo[i].getParameter() == null || !launchInfo[i].getParameter().contains("NSProjectBundleEnabled")) continue;
            nsProjectBundleEnabledExists = true;
        }
        if (!nsProjectBundleEnabledExists && !Preferences.mockBundleEnabled()) {
            launchArgument.append(" -DNSProjectBundleEnabled=true");
        }
        if ((debugGroups = configuration.getAttribute(ATTR_WOLIPS_LAUNCH_DEBUG_GROUPS, "")) != null && debugGroups.length() > 0 && includeDashD) {
            launchArgument.append(" -DNSDebugGroups=\"(");
            launchArgument.append(debugGroups);
            launchArgument.append(")\"");
        }
        return launchArgument.toString();
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String vmArguments = super.getVMArguments(configuration);
        StringBuffer vmArgumentsBuffer = new StringBuffer();
        if (vmArguments != null) {
            vmArgumentsBuffer.append(vmArguments);
        }
        vmArgumentsBuffer.append(this.getProgramArguments(configuration, false, true, true));
        return vmArgumentsBuffer.toString();
    }

    public String getVMArguments(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        return this.getVMArguments(configuration);
    }
}

