/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.locate;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.objectstyle.wolips.locate.LocateException;
import org.objectstyle.wolips.locate.result.ILocateResult;
import org.objectstyle.wolips.locate.scope.ILocateScope;

public class Locate {
    private ILocateScope locateScope;
    private ILocateResult locateResult;

    public Locate(ILocateScope locateScope, ILocateResult locateResult) {
        this.locateScope = locateScope;
        this.locateResult = locateResult;
    }

    public void locate() throws CoreException, LocateException {
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        for (int i = 0; i < allProjects.length; ++i) {
            this.investigate(allProjects[i]);
        }
    }

    private void investigate(IProject project) throws CoreException, LocateException {
        if (project.isOpen() && project.isAccessible() && !this.locateScope.ignoreContainer((IContainer)project)) {
            this.investigate(project.members());
        }
    }

    private void investigate(IResource[] resources) throws CoreException, LocateException {
        for (int i = 0; i < resources.length; ++i) {
            IResource resource = resources[i];
            if (!resource.isAccessible() || resource.isDerived()) continue;
            if (resource.getType() == 2) {
                this.investigate((IFolder)resource);
                continue;
            }
            if (resource.getType() != 1) continue;
            this.investigate((IFile)resource);
        }
    }

    private void investigate(IFolder folder) throws CoreException, LocateException {
        if (!this.locateScope.ignoreContainer((IContainer)folder)) {
            if (this.locateScope.addToResult((IContainer)folder)) {
                this.locateResult.add((IResource)folder);
            }
            this.investigate(folder.members());
        }
    }

    private void investigate(IFile file) throws LocateException {
        if (this.locateScope.addToResult(file)) {
            this.locateResult.add((IResource)file);
        }
    }
}

