/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.baseforplugins.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class URLUtils {
    public static String getExtension(URL url) {
        return URLUtils.getExtension(url.getPath());
    }

    public static String getExtension(URI uri) {
        return URLUtils.getExtension(uri.getPath());
    }

    public static String getExtension(String path) {
        int dotIndex;
        String extension = null;
        if (path != null && (dotIndex = path.lastIndexOf(46)) != -1) {
            extension = path.substring(dotIndex + 1);
        }
        return extension;
    }

    public static String getName(URL url) {
        return URLUtils.getName(url.getPath());
    }

    public static String getName(URI uri) {
        return URLUtils.getName(uri.getPath());
    }

    public static String getName(String path) {
        String name = null;
        if (path != null) {
            int slashIndex = path.lastIndexOf(47);
            name = slashIndex != -1 ? path.substring(slashIndex + 1) : path;
        }
        return name;
    }

    public static boolean isFolder(URL url) throws IOException {
        boolean isFolder = false;
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            File f = new File(url.getPath());
            isFolder = f.isDirectory();
        } else if ("jar".equals(protocol)) {
            JarURLConnection conn = (JarURLConnection)url.openConnection();
            isFolder = conn.getJarEntry().isDirectory();
        } else {
            throw new IllegalArgumentException(url + " is not a File.");
        }
        return isFolder;
    }

    public static boolean isFileOrBundleResource(URL url) {
        String protocol = url.getProtocol();
        if ("bundleresource".equals(protocol) || "file".equals(protocol)) {
            return URLUtils.exists(url);
        }
        return false;
    }

    public static boolean isJarURL(URL url) {
        return "jar".equals(url.getProtocol());
    }

    public static URL[] getChildrenFolders(URL url) throws IOException {
        URL[] children;
        URL parentUrl = url;
        String protocol = parentUrl.getProtocol();
        if ("bundleresource".equals(protocol)) {
            URLConnection conn = parentUrl.openConnection();
            parentUrl = conn.getURL();
            protocol = parentUrl.getProtocol();
        }
        if ("file".equals(protocol)) {
            File f = new File(parentUrl.getPath()).getAbsoluteFile();
            if (!f.exists()) {
                children = new URL[]{};
            } else {
                File[] files = f.listFiles();
                if (files == null) {
                    children = new URL[]{};
                } else {
                    LinkedList<URL> childrenList = new LinkedList<URL>();
                    for (int i = 0; i < files.length; ++i) {
                        File child = files[i];
                        if (child.isHidden() || !child.isDirectory()) continue;
                        childrenList.add(child.toURI().toURL());
                    }
                    children = childrenList.toArray(new URL[childrenList.size()]);
                }
            }
        } else if ("jar".equals(protocol)) {
            LinkedList<URL> childEntries = new LinkedList<URL>();
            JarURLConnection conn = (JarURLConnection)parentUrl.openConnection();
            JarFile jarFile = null;
            try {
                jarFile = conn.getJarFile();
                JarEntry folderJarEntry = conn.getJarEntry();
                String folderName = folderJarEntry.getName();
                Enumeration<JarEntry> jarEntriesEnum = jarFile.entries();
                while (jarEntriesEnum.hasMoreElements()) {
                    JarEntry jarEntry = jarEntriesEnum.nextElement();
                    String name = jarEntry.getName();
                    if (!name.startsWith(folderName)) continue;
                    URL childURL = new URL(parentUrl, name);
                    childEntries.add(childURL);
                }
                children = childEntries.toArray(new URL[childEntries.size()]);
            }
            catch (Exception e) {
                children = new URL[]{};
            }
        } else {
            throw new IllegalArgumentException(parentUrl + " is not a format that can have its children retrieved.");
        }
        return children;
    }

    public static File cheatAndTurnIntoFile(URI uri) {
        try {
            return URLUtils.cheatAndTurnIntoFile(uri.toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to turn '" + uri + "' into a URL.", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File cheatAndTurnIntoFile(URL url) {
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        if ("jar".equals(protocol)) {
            String externalForm = url.toExternalForm();
            int colonIndex = externalForm.indexOf(58);
            int bangIndex = externalForm.indexOf(33);
            String jarPath = bangIndex == -1 ? externalForm.substring(colonIndex + 1) : externalForm.substring(colonIndex + 1, bangIndex);
            try {
                return new File(new URI(jarPath));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(url + " cannot be turned into a File.", e);
            }
        }
        if ("file".equals(protocol)) {
            try {
                String externalForm = url.getPath();
                File f = new File(externalForm);
                if (f.exists()) return f;
                externalForm = URLDecoder.decode(externalForm, "UTF-8");
                return new File(externalForm);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(url + " cannot be turned into a File.", e);
            }
        }
        if (!"bundleresource".equals(protocol)) throw new IllegalArgumentException(url + " is not a File.");
        try {
            URLConnection conn = url.openConnection();
            String externalForm = conn.getURL().toExternalForm();
            externalForm = URLDecoder.decode(externalForm, "UTF-8");
            externalForm = externalForm.replaceAll(" ", "%20");
            return new File(new URI(externalForm));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(url + " cannot be turned into a File.", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(url + " cannot be turned into a File.", e);
        }
    }

    public static boolean exists(URL url) {
        boolean exists = false;
        String protocol = url.getProtocol();
        if ("jar".equals(protocol)) {
            try {
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                conn.getJarEntry();
                exists = true;
            }
            catch (FileNotFoundException e) {
                exists = false;
            }
            catch (IOException e) {}
        } else if ("file".equals(protocol) || "bundleresource".equals(protocol)) {
            File file = URLUtils.cheatAndTurnIntoFile(url);
            if (file != null) {
                exists = file.exists();
            }
        } else {
            throw new IllegalArgumentException(url + " is not a File.");
        }
        return exists;
    }
}

