/*
 * Decompiled with CFR 0.152.
 */
package org.objectstyle.wolips.ui.preferences;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.objectstyle.wolips.baseforplugins.util.ArrayUtilities;
import org.objectstyle.wolips.baseforplugins.util.StringUtilities;
import org.objectstyle.wolips.preferences.ILaunchInfo;
import org.objectstyle.wolips.preferences.Preferences;
import org.objectstyle.wolips.preferences.PreferencesMessages;

public class LaunchPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table includeTable;
    private Button addButton;
    private Button removeButton;
    private Button changeButton;
    private String preferencesKey;
    private List<String> allParameter;
    private List<String> allArguments;

    public void init(IWorkbench workbench) {
        this.setDescription(PreferencesMessages.getString((String)"LaunchPreferencesPage.description"));
        this.preferencesKey = "org.objectstyle.wolips.Preference.Launch_Global";
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        parent.setLayoutData((Object)data);
        Label l1 = new Label(parent, 0);
        l1.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.label"));
        data = new GridData(2);
        data.horizontalSpan = 3;
        l1.setLayoutData((Object)data);
        this.includeTable = new Table(parent, 2080);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        this.includeTable.setLayoutData((Object)gd);
        this.includeTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LaunchPreferencesPage.this.handleSelection();
            }
        });
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.add"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = Math.max(data.heightHint, this.addButton.computeSize((int)-1, (int)-1, (boolean)true).y);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.addButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LaunchPreferencesPage.this.addIgnore();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.remove"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = Math.max(data.heightHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).y);
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LaunchPreferencesPage.this.removeIgnore();
            }
        });
        this.changeButton = new Button(buttons, 8);
        this.changeButton.setText(PreferencesMessages.getString((String)"LaunchPreferencesPage.change"));
        data = new GridData();
        data.horizontalAlignment = 4;
        data.heightHint = Math.max(data.heightHint, this.changeButton.computeSize((int)-1, (int)-1, (boolean)true).y);
        widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.changeButton.setLayoutData((Object)data);
        this.changeButton.setEnabled(false);
        this.changeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                LaunchPreferencesPage.this.changeArgument();
            }
        });
        this.fillTable(Preferences.getLaunchInfoForKey((String)this.preferencesKey));
        Dialog.applyDialogFont((Control)ancestor);
        return parent;
    }

    public boolean performOk() {
        int count = this.includeTable.getItemCount();
        String[] parameter = new String[count];
        String[] arguments = new String[count];
        boolean[] enabled = new boolean[count];
        TableItem[] items = this.includeTable.getItems();
        for (int i = 0; i < count; ++i) {
            parameter[i] = this.allParameter.get(i);
            arguments[i] = this.allArguments.get(i);
            enabled[i] = items[i].getChecked();
        }
        Preferences.setLaunchInfoForKey((String[])parameter, (String[])arguments, (boolean[])enabled, (String)this.preferencesKey);
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.includeTable.removeAll();
        String string = PreferencesMessages.getString((String)this.preferencesKey);
        Preferences.setString((String)this.preferencesKey, (String)string);
        this.fillTable(Preferences.getLaunchInfoForKey((String)this.preferencesKey));
    }

    private void fillTable(ILaunchInfo[] launchInfoArray) {
        this.allArguments = new LinkedList<String>();
        this.allParameter = new LinkedList<String>();
        for (int i = 0; i < launchInfoArray.length; ++i) {
            ILaunchInfo launchInfo = launchInfoArray[i];
            TableItem item = new TableItem(this.includeTable, 0);
            item.setText(StringUtilities.toCommandlineParameterFormat((String)launchInfo.getParameter(), (String)launchInfo.getArgument(), (boolean)false));
            this.allParameter.add(launchInfo.getParameter());
            this.allArguments.add(launchInfo.getArgument());
            item.setChecked(launchInfo.isEnabled());
        }
    }

    void addIgnore() {
        InputDialog parameterDialog = new InputDialog(this.getShell(), PreferencesMessages.getString((String)"LaunchPreferencesPage.enterParameterShort"), PreferencesMessages.getString((String)"LaunchPreferencesPage.enterPatternLong"), null, null);
        parameterDialog.open();
        if (parameterDialog.getReturnCode() != 0) {
            return;
        }
        InputDialog argumentDialog = new InputDialog(this.getShell(), PreferencesMessages.getString((String)"LaunchPreferencesPage.enterArgumentShort"), PreferencesMessages.getString((String)"LaunchPreferencesPage.enterArgumentLong"), null, null);
        argumentDialog.open();
        if (argumentDialog.getReturnCode() != 0) {
            return;
        }
        String parameter = parameterDialog.getValue();
        String argument = argumentDialog.getValue();
        if (parameter.equals("") || argument.equals("")) {
            return;
        }
        TableItem[] items = this.includeTable.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].getText(1).equals(parameter)) continue;
            MessageDialog.openWarning((Shell)this.getShell(), (String)PreferencesMessages.getString((String)"LaunchPreferencesPage.parameterExistsShort"), (String)PreferencesMessages.getString((String)"LaunchPreferencesPage.patternExistsLong"));
            return;
        }
        TableItem item = new TableItem(this.includeTable, 0);
        item.setText(StringUtilities.toCommandlineParameterFormat((String)parameter, (String)argument, (boolean)false));
        this.allParameter.add(parameter);
        this.allArguments.add(argument);
        item.setChecked(true);
    }

    void removeIgnore() {
        int[] selection = this.includeTable.getSelectionIndices();
        this.includeTable.remove(selection);
        if (selection == null) {
            return;
        }
        int[] newIndices = new int[selection.length];
        System.arraycopy(selection, 0, newIndices, 0, selection.length);
        ArrayUtilities.sort((int[])selection);
        int last = -1;
        for (int i = 0; i < newIndices.length; ++i) {
            int index = newIndices[i];
            if (index != last || i == 0) {
                this.allParameter.remove(index);
                this.allArguments.remove(index);
            }
            last = index;
        }
    }

    void changeArgument() {
        int[] selection = this.includeTable.getSelectionIndices();
        if (selection.length != 1) {
            return;
        }
        int index = selection[0];
        InputDialog argumentDialog = new InputDialog(this.getShell(), PreferencesMessages.getString((String)"LaunchPreferencesPage.enterArgumentShort"), PreferencesMessages.getString((String)"LaunchPreferencesPage.enterArgumentLong"), this.allArguments.get(index), null);
        argumentDialog.open();
        if (argumentDialog.getReturnCode() != 0) {
            return;
        }
        String argument = argumentDialog.getValue();
        String parameter = this.allParameter.get(index);
        TableItem item = this.includeTable.getItem(index);
        item.setText(StringUtilities.toCommandlineParameterFormat((String)parameter, (String)argument, (boolean)false));
        this.allArguments.set(index, argument);
    }

    void handleSelection() {
        if (this.includeTable.getSelectionCount() > 0) {
            this.changeButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.changeButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }
}

